/*
 * Decompiled with CFR 0.152.
 */
package com.keypoint;

import Acme.IntHashtable;
import com.keypoint.PngEncoderHashitem;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PngEncoderIndexed {
    protected static final byte[] IHDR = new byte[]{73, 72, 68, 82};
    protected static final byte[] PLTE = new byte[]{80, 76, 84, 69};
    protected static final byte[] tRNS = new byte[]{116, 82, 78, 83};
    protected static final byte[] IDAT = new byte[]{73, 68, 65, 84};
    protected static final byte[] IEND = new byte[]{73, 69, 78, 68};
    protected static final int DEFAULT_COMPRESSION = 5;
    protected byte[] pngBytes;
    protected Image image;
    protected int width;
    protected int height;
    protected int bytePos;
    protected int maxPos;
    protected CRC32 crc = new CRC32();
    protected long crcValue;
    protected int compressionLevel;

    public PngEncoderIndexed() {
        this(null, 5);
    }

    public PngEncoderIndexed(Image image) {
        this(image, 5);
    }

    public PngEncoderIndexed(Image image, int n) {
        this.image = image;
        if (n >= 0 && n <= 9) {
            this.compressionLevel = n;
        }
    }

    public void setImage(Image image) {
        this.image = image;
        this.pngBytes = null;
    }

    public byte[] pngEncode() {
        byte[] byArray = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        if (this.image == null) {
            return null;
        }
        this.width = this.image.getWidth(null);
        this.height = this.image.getHeight(null);
        this.pngBytes = new byte[(this.width + 1) * this.height * 3 + 200];
        this.maxPos = 0;
        this.bytePos = this.writeBytes(byArray, 0);
        this.writeHeader();
        if (this.writeImageData()) {
            this.writeEnd();
            this.pngBytes = this.resizeByteArray(this.pngBytes, this.maxPos);
        } else {
            this.pngBytes = null;
        }
        return this.pngBytes;
    }

    public void setCompressionLevel(int n) {
        if (n >= 0 && n <= 9) {
            this.compressionLevel = n;
        }
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    protected byte[] resizeByteArray(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        int n2 = byArray.length;
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(n2, n));
        return byArray2;
    }

    protected int writeBytes(byte[] byArray, int n) {
        this.maxPos = Math.max(this.maxPos, n + byArray.length);
        if (byArray.length + n > this.pngBytes.length) {
            this.pngBytes = this.resizeByteArray(this.pngBytes, this.pngBytes.length + Math.max(1000, byArray.length));
        }
        System.arraycopy(byArray, 0, this.pngBytes, n, byArray.length);
        return n + byArray.length;
    }

    protected int writeBytes(byte[] byArray, int n, int n2) {
        this.maxPos = Math.max(this.maxPos, n2 + n);
        if (n + n2 > this.pngBytes.length) {
            this.pngBytes = this.resizeByteArray(this.pngBytes, this.pngBytes.length + Math.max(1000, n));
        }
        System.arraycopy(byArray, 0, this.pngBytes, n2, n);
        return n2 + n;
    }

    protected int writeInt2(int n, int n2) {
        byte[] byArray = new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        return this.writeBytes(byArray, n2);
    }

    protected int writeInt4(int n, int n2) {
        byte[] byArray = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        return this.writeBytes(byArray, n2);
    }

    protected int writeByte(int n, int n2) {
        byte[] byArray = new byte[]{(byte)n};
        return this.writeBytes(byArray, n2);
    }

    protected void writeHeader() {
        int n = this.bytePos = this.writeInt4(13, this.bytePos);
        this.bytePos = this.writeBytes(IHDR, this.bytePos);
        this.width = this.image.getWidth(null);
        this.height = this.image.getHeight(null);
        this.bytePos = this.writeInt4(this.width, this.bytePos);
        this.bytePos = this.writeInt4(this.height, this.bytePos);
        this.bytePos = this.writeByte(8, this.bytePos);
        this.bytePos = this.writeByte(3, this.bytePos);
        this.bytePos = this.writeByte(0, this.bytePos);
        this.bytePos = this.writeByte(0, this.bytePos);
        this.bytePos = this.writeByte(0, this.bytePos);
        this.crc.reset();
        this.crc.update(this.pngBytes, n, this.bytePos - n);
        this.crcValue = this.crc.getValue();
        this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
    }

    protected boolean writeImageData() {
        IntHashtable intHashtable = new IntHashtable();
        int n = 0;
        int n2 = -1;
        boolean bl = false;
        Deflater deflater = new Deflater(this.compressionLevel);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
        try {
            PngEncoderHashitem pngEncoderHashitem;
            int n3;
            int n4;
            int n5;
            PixelGrabber pixelGrabber;
            Object[] objectArray;
            int n6;
            int n7;
            int n8 = 0;
            for (n6 = this.height; n6 > 0; n6 -= n7) {
                n7 = Math.min(64000 / (this.width * 4), n6);
                n7 = Math.max(n7, 1);
                objectArray = new int[this.width * n7];
                pixelGrabber = new PixelGrabber(this.image, 0, n8, this.width, n7, (int[])objectArray, 0, this.width);
                try {
                    pixelGrabber.grabPixels();
                }
                catch (Exception exception) {
                    System.err.println("interrupted waiting for pixels!");
                    return false;
                }
                if ((pixelGrabber.getStatus() & 0x80) != 0) {
                    System.err.println("image fetch aborted or errored");
                    return false;
                }
                n5 = 0;
                n4 = 1;
                for (int i = 0; i < this.width * n7; ++i) {
                    n3 = objectArray[i];
                    pngEncoderHashitem = (PngEncoderHashitem)intHashtable.get(n3);
                    if (pngEncoderHashitem == null) {
                        if (n >= 256) {
                            throw new IOException("too many colors for a PNG");
                        }
                        pngEncoderHashitem = new PngEncoderHashitem(n3, 1, n, false);
                        intHashtable.put(n3, (Object)pngEncoderHashitem);
                        ++n;
                        continue;
                    }
                    ++pngEncoderHashitem.count;
                }
                n8 += n7;
            }
            this.crc.reset();
            this.bytePos = this.writeInt4(n * 3, this.bytePos);
            this.bytePos = this.writeBytes(PLTE, this.bytePos);
            this.crc.update(PLTE);
            objectArray = new byte[n * 3];
            Object object = intHashtable.elements();
            while (object.hasMoreElements()) {
                pngEncoderHashitem = (PngEncoderHashitem)object.nextElement();
                objectArray[pngEncoderHashitem.index * 3] = (byte)(pngEncoderHashitem.rgba >> 16 & 0xFF);
                objectArray[pngEncoderHashitem.index * 3 + 1] = (byte)(pngEncoderHashitem.rgba >> 8 & 0xFF);
                objectArray[pngEncoderHashitem.index * 3 + 2] = (byte)(pngEncoderHashitem.rgba & 0xFF);
            }
            this.bytePos = this.writeBytes((byte[])objectArray, this.bytePos);
            this.crc.update((byte[])objectArray);
            this.crcValue = this.crc.getValue();
            this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
            n8 = 0;
            for (n6 = this.height; n6 > 0; n6 -= n7) {
                n7 = Math.min(64000 / (this.width * 4), n6);
                n7 = Math.max(n7, 1);
                object = new int[this.width * n7];
                pixelGrabber = new PixelGrabber(this.image, 0, n8, this.width, n7, (int[])object, 0, this.width);
                try {
                    pixelGrabber.grabPixels();
                }
                catch (Exception exception) {
                    System.err.println("interrupted waiting for pixels!");
                    return false;
                }
                if ((pixelGrabber.getStatus() & 0x80) != 0) {
                    System.err.println("image fetch aborted or errored");
                    return false;
                }
                byte[] byArray = new byte[this.width * n7 + n7];
                n5 = 0;
                n4 = 1;
                for (n3 = 0; n3 < this.width * n7; ++n3) {
                    if (n3 % this.width == 0) {
                        byArray[n5++] = 0;
                        n4 = n5;
                    }
                    if ((pngEncoderHashitem = (PngEncoderHashitem)intHashtable.get((int)object[n3])) == null) {
                        throw new IOException("color not found");
                    }
                    byArray[n5++] = (byte)pngEncoderHashitem.index;
                }
                deflaterOutputStream.write(byArray, 0, n5);
                n8 += n7;
            }
            deflaterOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            int n9 = byArray.length;
            this.crc.reset();
            this.bytePos = this.writeInt4(n9, this.bytePos);
            this.bytePos = this.writeBytes(IDAT, this.bytePos);
            this.crc.update(IDAT);
            this.bytePos = this.writeBytes(byArray, n9, this.bytePos);
            this.crc.update(byArray, 0, n9);
            this.crcValue = this.crc.getValue();
            this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
            deflater.finish();
            return true;
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
            return false;
        }
    }

    protected void writeEnd() {
        this.bytePos = this.writeInt4(0, this.bytePos);
        this.bytePos = this.writeBytes(IEND, this.bytePos);
        this.crc.reset();
        this.crc.update(IEND);
        this.crcValue = this.crc.getValue();
        this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
    }
}

