/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=25
//  date=$Date: 2014-03-06 06:14:25 +0100 (Thu, 06 Mar 2014) $
//  number=$Revision: 9876 $
//  type=chr

/**
 * Localized names for the "chr" locale.
 */
public class LocalizedNamesImpl_chr extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "BQ",
        "CP",
        "DG",
        "EA",
        "EH",
        "ET",
        "EU",
        "HN",
        "IC",
        "LC",
        "NE",
        "QO",
        "RE",
        "SJ",
        "SM",
        "SN",
        "SO",
        "SR",
        "SS",
        "ST",
        "SV",
        "SX",
        "SY",
        "SZ",
        "TA",
        "TC",
        "TD",
        "TF",
        "TG",
        "TH",
        "TJ",
        "TK",
        "TL",
        "TM",
        "TN",
        "TO",
        "TR",
        "TT",
        "TV",
        "TW",
        "TZ",
        "UA",
        "UG",
        "UM",
        "UY",
        "UZ",
        "VA",
        "VC",
        "VE",
        "VG",
        "VI",
        "VN",
        "VU",
        "WF",
        "WS",
        "XK",
        "YE",
        "YT",
        "ZA",
        "ZM",
        "ZW",
        "IE",
        "AM",
        "AL",
        "DZ",
        "AW",
        "US",
        "AS",
        "PF",
        "GF",
        "AI",
        "AO",
        "PH",
        "ES",
        "AD",
        "DE",
        "AT",
        "AZ",
        "CK",
        "SH",
        "BL",
        "MF",
        "AR",
        "AF",
        "KN",
        "FM",
        "AU",
        "ER",
        "EC",
        "GQ",
        "EE",
        "CV",
        "IQ",
        "IR",
        "ID",
        "IN",
        "IL",
        "NC",
        "GL",
        "NZ",
        "EG",
        "CI",
        "AX",
        "OM",
        "IM",
        "AG",
        "GH",
        "FR",
        "GM",
        "GA",
        "GY",
        "KI",
        "HR",
        "CM",
        "KH",
        "CD",
        "CG",
        "KZ",
        "QA",
        "KY",
        "CA",
        "KE",
        "GB",
        "KG",
        "GR",
        "CC",
        "CO",
        "KM",
        "CR",
        "CU",
        "GN",
        "GW",
        "KW",
        "CF",
        "GG",
        "HT",
        "HK",
        "HU",
        "HM",
        "LR",
        "LV",
        "LA",
        "LB",
        "LS",
        "LI",
        "LY",
        "LT",
        "RO",
        "RW",
        "LU",
        "MO",
        "MW",
        "MY",
        "ML",
        "MT",
        "MV",
        "MD",
        "MC",
        "MN",
        "MS",
        "MH",
        "MK",
        "MG",
        "MR",
        "MQ",
        "MM",
        "MU",
        "MA",
        "ME",
        "MZ",
        "NA",
        "MP",
        "BS",
        "NP",
        "NL",
        "CW",
        "NI",
        "NG",
        "NU",
        "NR",
        "NF",
        "NO",
        "PK",
        "BH",
        "PY",
        "PW",
        "PS",
        "GU",
        "PA",
        "BJ",
        "BD",
        "PG",
        "BB",
        "BM",
        "BR",
        "BW",
        "PR",
        "BY",
        "BZ",
        "BE",
        "PE",
        "PN",
        "IO",
        "PL",
        "BO",
        "BA",
        "PT",
        "BG",
        "BN",
        "BT",
        "BV",
        "BF",
        "BI",
        "GD",
        "CY",
        "SA",
        "AE",
        "LK",
        "SK",
        "SI",
        "MX",
        "CH",
        "SE",
        "PM",
        "SL",
        "SC",
        "SG",
        "SB",
        "SD",
        "RS",
        "CN",
        "CX",
        "DK",
        "DM",
        "DO",
        "GE",
        "JM",
        "JP",
        "CZ",
        "CL",
        "GI",
        "DJ",
        "JO",
        "KR",
        "GS",
        "AQ",
        "IS",
        "KP",
        "JE",
        "FK",
        "GP",
        "GT",
        "FO",
        "FI",
        "FJ",
        "IT",
        "RU",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "ᎡᎶᎯ");
    namesMap.put("003", "ᏧᏴᏢ ᎠᎺᎵᎦ");
    namesMap.put("005", "ᏧᎦᏃᏮ ᎠᎺᎵᎦ");
    namesMap.put("019", "ᎠᎺᎵᎦᎢ");
    namesMap.put("AD", "ᎠᏂᏙᎳ");
    namesMap.put("AE", "ᏌᏊ ᎢᏳᎾᎵᏍᏔᏅ ᎡᎳᏈ ᎢᎹᎵᏘᏏ");
    namesMap.put("AF", "ᎠᏫᎨᏂᏍᏖᏂ");
    namesMap.put("AG", "ᎤᏪᏘ ᎠᎴ ᏆᏊᏓ");
    namesMap.put("AI", "ᎠᏂᎩᎳ");
    namesMap.put("AL", "ᎠᎵᏇᏂᏯ");
    namesMap.put("AM", "ᎠᎵᎻᏂᎠ");
    namesMap.put("AO", "ᎠᏂᎪᎳ");
    namesMap.put("AQ", "ᏧᏁᏍᏓᎸ");
    namesMap.put("AR", "ᎠᏥᏂᏘᏂᎠ");
    namesMap.put("AS", "ᎠᎺᎵᎧ ᏌᎼᎠ");
    namesMap.put("AT", "ᎠᏍᏟᏯ");
    namesMap.put("AU", "ᎡᎳᏗᏜ");
    namesMap.put("AW", "ᎠᎷᏆ");
    namesMap.put("AX", "ᎣᎴᏅᏓ ᏚᎦᏚᏛ");
    namesMap.put("AZ", "ᎠᏏᎵᏆᏌᏂ");
    namesMap.put("BA", "ᏉᏏᏂᎠ ᎠᎴ ᎲᏤᎪᏫ");
    namesMap.put("BB", "ᏆᏇᏙᏍ");
    namesMap.put("BD", "ᏆᏂᎦᎵᏕᏍ");
    namesMap.put("BE", "ᏇᎵᏥᎥᎻ");
    namesMap.put("BF", "ᏋᎩᎾ ᏩᏐ");
    namesMap.put("BG", "ᏊᎵᎨᎵᎠ");
    namesMap.put("BH", "ᏆᎭᎴᎢᏂ");
    namesMap.put("BI", "ᏋᎷᏂᏗ");
    namesMap.put("BJ", "ᏆᏂᎢᏂ");
    namesMap.put("BL", "ᎠᏥᎸᏉᏗ ᏆᏕᎳᎻ");
    namesMap.put("BM", "ᏆᏊᏓ");
    namesMap.put("BN", "ᏊᎾᎢ");
    namesMap.put("BO", "ᏉᎵᏫᎠ");
    namesMap.put("BR", "ᏆᏏᎵᎢ");
    namesMap.put("BS", "ᎾᏍᎩ ᏆᎭᎹᏍ");
    namesMap.put("BT", "ᏊᏔᏂ");
    namesMap.put("BV", "ᏊᏪ ᎤᎦᏚᏛ");
    namesMap.put("BW", "ᏆᏣᏩᎾ");
    namesMap.put("BY", "ᏇᎳᎷᏍ");
    namesMap.put("BZ", "ᏇᎵᏍ");
    namesMap.put("CA", "ᎨᎾᏓ");
    namesMap.put("CC", "ᎪᎪᏍ (ᎩᎵᏂ) ᏚᎦᏚᏛ");
    namesMap.put("CD", "ᎧᏂᎪ");
    namesMap.put("CF", "ᎬᎿᎨᏍᏛ ᎠᏰᏟ ᏍᎦᏚᎩ");
    namesMap.put("CG", "ᎧᏂᎪ (ᏍᎦᏚᎩ)");
    namesMap.put("CH", "ᏍᏫᏍ");
    namesMap.put("CI", "ᎢᏬᎵ ᎾᎿ ᎠᎹᏳᎶᏗ");
    namesMap.put("CK", "ᎠᏓᏍᏓᏴᎲᏍᎩ ᎤᎦᏚᏛ");
    namesMap.put("CL", "ᏥᎵ");
    namesMap.put("CM", "ᎧᎹᎷᏂ");
    namesMap.put("CN", "ᏓᎶᏂᎨᏍᏛ");
    namesMap.put("CO", "ᎪᎸᎻᏈᎢᎠ");
    namesMap.put("CR", "ᎪᏍᏓ ᎵᎧ");
    namesMap.put("CU", "ᎫᏆ");
    namesMap.put("CV", "ᎢᎬᎾᏕᎾ ᎢᏤᏳᏍᏗ");
    namesMap.put("CW", "ᏂᎦᏓ ᎤᏂᎲ ᎾᎿ ᎫᎳᎨᎣ");
    namesMap.put("CX", "ᏓᏂᏍᏓᏲᎯᎲ ᎤᎦᏚᏛ");
    namesMap.put("CY", "ᏌᎢᏆᏍ");
    namesMap.put("CZ", "ᏤᎩ ᏍᎦᏚᎩ");
    namesMap.put("DE", "ᎠᏂᏛᏥ");
    namesMap.put("DJ", "ᏥᏊᏗ");
    namesMap.put("DK", "ᏗᏂᎹᎦ");
    namesMap.put("DM", "ᏙᎻᏂᎧ");
    namesMap.put("DO", "ᏙᎻᏂᎧᏂ ᏍᎦᏚᎩ");
    namesMap.put("DZ", "ᎠᎵᏥᎵᏯ");
    namesMap.put("EC", "ᎡᏆᏙᎵ");
    namesMap.put("EE", "ᎡᏍᏙᏂᏯ");
    namesMap.put("EG", "ᎢᏥᏈᎢ");
    namesMap.put("ER", "ᎡᎵᏟᏯ");
    namesMap.put("ES", "ᎠᏂᏍᏆᏂᏱ");
    namesMap.put("FI", "ᏫᏂᎦᏙᎯ");
    namesMap.put("FJ", "ᏫᏥ");
    namesMap.put("FK", "ᏩᎩ ᎤᎦᏚᏛ");
    namesMap.put("FM", "ᎠᏰᏟ ᏧᎾᎵᎪᎯ ᎾᎿ ᎹᎢᏉᏂᏏᏯ");
    namesMap.put("FO", "ᏪᎶ ᏚᎦᏚᏛ");
    namesMap.put("FR", "ᎦᎸᏥᏱ");
    namesMap.put("GA", "ᎦᏉᏂ");
    namesMap.put("GB", "ᎩᎵᏏᏲ");
    namesMap.put("GD", "ᏋᎾᏓ");
    namesMap.put("GE", "ᏣᎠᏥᎢ");
    namesMap.put("GF", "ᎠᏂᎦᎸᏥ ᎩᎠ");
    namesMap.put("GG", "ᎬᏂᏏ");
    namesMap.put("GH", "ᎦᎠᎾ");
    namesMap.put("GI", "ᏥᏆᎵᏓ");
    namesMap.put("GL", "ᎢᏤᏍᏛᏱ");
    namesMap.put("GM", "ᎦᎹᏈᎢᎠ");
    namesMap.put("GN", "ᎫᏇ");
    namesMap.put("GP", "ᏩᏓᎷᏇ");
    namesMap.put("GQ", "ᎡᏆᏙᎵᎠᎵ ᎩᎢᏂ");
    namesMap.put("GR", "ᎪᎢᎯ");
    namesMap.put("GS", "ᏧᎦᏃᏮ ᏣᏥᏱ ᎠᎴ ᎾᏍᎩ ᏧᎦᏃᏮ ᎠᏍᏛᎭᏟ ᏚᎦᏚᏛ");
    namesMap.put("GT", "ᏩᏔᎹᎳ");
    namesMap.put("GU", "ᏆᎻ");
    namesMap.put("GW", "ᎫᏇ-ᏈᏌᎤᏫ");
    namesMap.put("GY", "ᎦᏯᎾ");
    namesMap.put("HK", "ᎰᏂᎩ ᎪᏂᎩ");
    namesMap.put("HM", "ᎲᏗ ᎤᎦᏚᏛ ᎠᎴ ᎺᎩᏓᎾᎵᏗ ᏚᎦᏚᏛ");
    namesMap.put("HR", "ᎧᎶᎡᏏᎠ");
    namesMap.put("HT", "ᎮᎢᏘ");
    namesMap.put("HU", "ᎲᏂᎦᎵ");
    namesMap.put("ID", "ᎢᏂᏙᏂᏍᏯ");
    namesMap.put("IE", "ᎠᎢᎴᏂᏗ");
    namesMap.put("IL", "ᎢᏏᎵᏱ");
    namesMap.put("IM", "ᎤᏍᏗ ᎤᎦᏚᏛ ᎾᎿ ᎠᏍᎦᏯ");
    namesMap.put("IN", "ᎢᏅᏗᎾ");
    namesMap.put("IO", "ᏈᏗᏏ ᏴᏫᏯ ᎠᎺᏉ ᎢᎬᎾᏕᏅ");
    namesMap.put("IQ", "ᎢᎳᎩ");
    namesMap.put("IR", "ᎢᎴᏂ");
    namesMap.put("IS", "ᏧᏁᏍᏓᎸᎯ");
    namesMap.put("IT", "ᏲᎶ");
    namesMap.put("JE", "ᏨᎵᏏ");
    namesMap.put("JM", "ᏣᎺᎢᎧ");
    namesMap.put("JO", "ᏦᏓᏂ");
    namesMap.put("JP", "ᏣᏩᏂᏏ");
    namesMap.put("KE", "ᎨᏂᏯ");
    namesMap.put("KG", "ᎩᎵᏣᎢᏍ");
    namesMap.put("KH", "ᎧᎹᏉᏗᎠᏂ");
    namesMap.put("KI", "ᎧᎵᏆᏘ");
    namesMap.put("KM", "ᎪᎼᎳᏍ");
    namesMap.put("KN", "ᎠᏰᏟ ᎾᎿ ᎨᏥᎸᏉᏗ ᎠᏂᏪᏌ ᎠᎴ ᎠᏂᏁᏫᏍ");
    namesMap.put("KP", "ᏧᏴᏢ ᎪᎵᎠ");
    namesMap.put("KR", "ᏧᎦᏃᏮ ᎪᎵᎠ");
    namesMap.put("KW", "ᎫᏪᎢᏘ");
    namesMap.put("KY", "ᎨᎢᎹᏂ ᏚᎦᏚᏛᎢ");
    namesMap.put("KZ", "ᎧᏎᎧᏍᏕᏂ");
    namesMap.put("LA", "ᎴᎣᏍ");
    namesMap.put("LB", "ᎴᏆᎾᏂ");
    namesMap.put("LI", "ᎵᎦᏗᏂᏍᏓᏂ");
    namesMap.put("LK", "ᏍᎵ ᎳᏂᎧ");
    namesMap.put("LR", "ᎳᏈᎵᏯ");
    namesMap.put("LS", "ᎴᏐᏙ");
    namesMap.put("LT", "ᎵᏗᏪᏂᎠ");
    namesMap.put("LU", "ᎸᎧᏎᏋᎩ");
    namesMap.put("LV", "ᎳᏘᏫᎠ");
    namesMap.put("LY", "ᎵᏈᏯ");
    namesMap.put("MA", "ᎼᎶᎪ");
    namesMap.put("MC", "ᎹᎾᎪ");
    namesMap.put("MD", "ᎹᎵᏙᏫᎠ");
    namesMap.put("ME", "ᎼᏂᏔᏁᎦᎶ");
    namesMap.put("MF", "ᎠᏥᎸᏉᏗ ᏡᏡ");
    namesMap.put("MG", "ᎹᏓᎦᏍᎧᎵ");
    namesMap.put("MH", "ᎹᏌᎵ ᏚᎪᏚᏛ");
    namesMap.put("MK", "ᎹᏏᏙᏂᎢᎠ");
    namesMap.put("ML", "ᎹᎵ");
    namesMap.put("MM", "ᎹᏯᎹᎵ");
    namesMap.put("MN", "ᎹᏂᎪᎵᎠ");
    namesMap.put("MO", "ᎹᎧᎣ (ᎤᏓᏤᎵᏓ ᏧᏂᎸᏫᏍᏓᏁᏗ ᎢᎬᎾᏕᎾ) ᏣᎢ");
    namesMap.put("MP", "ᎾᏍᎩ ᎤᏴᏢ ᏗᏜ ᎹᎵᎠᎾ ᏚᎦᏚᏛ");
    namesMap.put("MQ", "ᎹᏘᏂᎨ");
    namesMap.put("MR", "ᎹᏘᎢᏯ");
    namesMap.put("MS", "ᎹᏂᏘᏌᎳᏗ");
    namesMap.put("MT", "ᎹᎵᏔ");
    namesMap.put("MU", "ᎼᎵᏏᎥᏍ");
    namesMap.put("MV", "ᎹᎵᏗᏫᏍ");
    namesMap.put("MW", "ᎹᎳᏫ");
    namesMap.put("MX", "ᏍᏆᏂᏱ");
    namesMap.put("MY", "ᎹᎴᏏᎢᎠ");
    namesMap.put("MZ", "ᎼᏎᎻᏇᎩ");
    namesMap.put("NA", "ᎾᎻᏈᎢᏯ");
    namesMap.put("NC", "ᎢᏤ ᎧᎵᏙᏂᎠᏂ");
    namesMap.put("NF", "ᏃᎵᏬᎵᎩ ᎤᎦᏚᏛ");
    namesMap.put("NG", "ᏂᏥᎵᏯ");
    namesMap.put("NI", "ᏂᎧᎳᏆ");
    namesMap.put("NL", "ᏁᏛᎳᏂ");
    namesMap.put("NO", "ᏃᏪ");
    namesMap.put("NP", "ᏁᏆᎵ");
    namesMap.put("NR", "ᏃᎤᎷ");
    namesMap.put("NU", "ᏂᏳ");
    namesMap.put("NZ", "ᎢᏤ ᏏᎢᎴᏂᏗ");
    namesMap.put("OM", "ᎣᎺᏂ");
    namesMap.put("PA", "ᏆᎾᎹ");
    namesMap.put("PE", "ᏇᎷ");
    namesMap.put("PF", "ᎠᏂᎦᎸᏣ ᏆᎵᏂᏏᎠ");
    namesMap.put("PG", "ᏆᏇ ᎢᏤ ᎩᏂ");
    namesMap.put("PH", "ᎠᏂᏈᎵᎩᏃ");
    namesMap.put("PK", "ᏆᎩᏍᏖᏂ");
    namesMap.put("PL", "ᏉᎳᏂ");
    namesMap.put("PM", "ᏎᏂᏘ ᏈᏓ ᎠᎴ ᎻᏇᎶᏂ");
    namesMap.put("PN", "ᏈᎧᎵᏂ ᎤᎦᏚᏛᎢ");
    namesMap.put("PR", "ᏇᎡᏙ ᎵᎢᎪ");
    namesMap.put("PS", "ᏆᎴᏍᏗᏂᎠᏂ ᏄᎬᏫᏳᏌᏕᎩ");
    namesMap.put("PT", "ᏉᏥᎦᎳ");
    namesMap.put("PW", "ᏆᎴᎠᏫ");
    namesMap.put("PY", "ᏆᎳᏇᎢᏯ");
    namesMap.put("QA", "ᎧᏔᎵ");
    namesMap.put("RO", "ᎶᎹᏂᏯ");
    namesMap.put("RS", "ᏒᏈᏯ");
    namesMap.put("RU", "ᏲᏂᎢ");
    namesMap.put("RW", "ᎶᏩᏂᏓ");
    namesMap.put("SA", "ᏌᎤᏗ ᎡᎴᏈᎠ");
    namesMap.put("SB", "ᏐᎶᎹᏂ ᏚᎦᏚᏛ");
    namesMap.put("SC", "ᏏᎡᏥᎵᏍ");
    namesMap.put("SD", "ᏑᏕᏂ");
    namesMap.put("SE", "ᏍᏫᏕᏂ");
    namesMap.put("SG", "ᏏᏂᎦᏉᎵ");
    namesMap.put("SH", "ᎠᏥᎸᏉᏗ ᎮᎵᎾ");
    namesMap.put("SI", "ᏍᎶᏫᏂᎠ");
    namesMap.put("SK", "ᏍᎶᏩᎩᎠ");
    namesMap.put("SL", "ᏏᎡᎳ ᎴᎣᏂ");
    namesMap.put("US", "ᎠᎹᏰᏟ");
    namesMap.put("ZZ", "ᏄᏬᎵᏍᏛᎾ ᎤᏔᏂᏗᎦᏙᎯ");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "ᎡᎶᎯ",
        "003": "ᏧᏴᏢ ᎠᎺᎵᎦ",
        "005": "ᏧᎦᏃᏮ ᎠᎺᎵᎦ",
        "019": "ᎠᎺᎵᎦᎢ",
        "AD": "ᎠᏂᏙᎳ",
        "AE": "ᏌᏊ ᎢᏳᎾᎵᏍᏔᏅ ᎡᎳᏈ ᎢᎹᎵᏘᏏ",
        "AF": "ᎠᏫᎨᏂᏍᏖᏂ",
        "AG": "ᎤᏪᏘ ᎠᎴ ᏆᏊᏓ",
        "AI": "ᎠᏂᎩᎳ",
        "AL": "ᎠᎵᏇᏂᏯ",
        "AM": "ᎠᎵᎻᏂᎠ",
        "AO": "ᎠᏂᎪᎳ",
        "AQ": "ᏧᏁᏍᏓᎸ",
        "AR": "ᎠᏥᏂᏘᏂᎠ",
        "AS": "ᎠᎺᎵᎧ ᏌᎼᎠ",
        "AT": "ᎠᏍᏟᏯ",
        "AU": "ᎡᎳᏗᏜ",
        "AW": "ᎠᎷᏆ",
        "AX": "ᎣᎴᏅᏓ ᏚᎦᏚᏛ",
        "AZ": "ᎠᏏᎵᏆᏌᏂ",
        "BA": "ᏉᏏᏂᎠ ᎠᎴ ᎲᏤᎪᏫ",
        "BB": "ᏆᏇᏙᏍ",
        "BD": "ᏆᏂᎦᎵᏕᏍ",
        "BE": "ᏇᎵᏥᎥᎻ",
        "BF": "ᏋᎩᎾ ᏩᏐ",
        "BG": "ᏊᎵᎨᎵᎠ",
        "BH": "ᏆᎭᎴᎢᏂ",
        "BI": "ᏋᎷᏂᏗ",
        "BJ": "ᏆᏂᎢᏂ",
        "BL": "ᎠᏥᎸᏉᏗ ᏆᏕᎳᎻ",
        "BM": "ᏆᏊᏓ",
        "BN": "ᏊᎾᎢ",
        "BO": "ᏉᎵᏫᎠ",
        "BR": "ᏆᏏᎵᎢ",
        "BS": "ᎾᏍᎩ ᏆᎭᎹᏍ",
        "BT": "ᏊᏔᏂ",
        "BV": "ᏊᏪ ᎤᎦᏚᏛ",
        "BW": "ᏆᏣᏩᎾ",
        "BY": "ᏇᎳᎷᏍ",
        "BZ": "ᏇᎵᏍ",
        "CA": "ᎨᎾᏓ",
        "CC": "ᎪᎪᏍ (ᎩᎵᏂ) ᏚᎦᏚᏛ",
        "CD": "ᎧᏂᎪ",
        "CF": "ᎬᎿᎨᏍᏛ ᎠᏰᏟ ᏍᎦᏚᎩ",
        "CG": "ᎧᏂᎪ (ᏍᎦᏚᎩ)",
        "CH": "ᏍᏫᏍ",
        "CI": "ᎢᏬᎵ ᎾᎿ ᎠᎹᏳᎶᏗ",
        "CK": "ᎠᏓᏍᏓᏴᎲᏍᎩ ᎤᎦᏚᏛ",
        "CL": "ᏥᎵ",
        "CM": "ᎧᎹᎷᏂ",
        "CN": "ᏓᎶᏂᎨᏍᏛ",
        "CO": "ᎪᎸᎻᏈᎢᎠ",
        "CR": "ᎪᏍᏓ ᎵᎧ",
        "CU": "ᎫᏆ",
        "CV": "ᎢᎬᎾᏕᎾ ᎢᏤᏳᏍᏗ",
        "CW": "ᏂᎦᏓ ᎤᏂᎲ ᎾᎿ ᎫᎳᎨᎣ",
        "CX": "ᏓᏂᏍᏓᏲᎯᎲ ᎤᎦᏚᏛ",
        "CY": "ᏌᎢᏆᏍ",
        "CZ": "ᏤᎩ ᏍᎦᏚᎩ",
        "DE": "ᎠᏂᏛᏥ",
        "DJ": "ᏥᏊᏗ",
        "DK": "ᏗᏂᎹᎦ",
        "DM": "ᏙᎻᏂᎧ",
        "DO": "ᏙᎻᏂᎧᏂ ᏍᎦᏚᎩ",
        "DZ": "ᎠᎵᏥᎵᏯ",
        "EC": "ᎡᏆᏙᎵ",
        "EE": "ᎡᏍᏙᏂᏯ",
        "EG": "ᎢᏥᏈᎢ",
        "ER": "ᎡᎵᏟᏯ",
        "ES": "ᎠᏂᏍᏆᏂᏱ",
        "FI": "ᏫᏂᎦᏙᎯ",
        "FJ": "ᏫᏥ",
        "FK": "ᏩᎩ ᎤᎦᏚᏛ",
        "FM": "ᎠᏰᏟ ᏧᎾᎵᎪᎯ ᎾᎿ ᎹᎢᏉᏂᏏᏯ",
        "FO": "ᏪᎶ ᏚᎦᏚᏛ",
        "FR": "ᎦᎸᏥᏱ",
        "GA": "ᎦᏉᏂ",
        "GB": "ᎩᎵᏏᏲ",
        "GD": "ᏋᎾᏓ",
        "GE": "ᏣᎠᏥᎢ",
        "GF": "ᎠᏂᎦᎸᏥ ᎩᎠ",
        "GG": "ᎬᏂᏏ",
        "GH": "ᎦᎠᎾ",
        "GI": "ᏥᏆᎵᏓ",
        "GL": "ᎢᏤᏍᏛᏱ",
        "GM": "ᎦᎹᏈᎢᎠ",
        "GN": "ᎫᏇ",
        "GP": "ᏩᏓᎷᏇ",
        "GQ": "ᎡᏆᏙᎵᎠᎵ ᎩᎢᏂ",
        "GR": "ᎪᎢᎯ",
        "GS": "ᏧᎦᏃᏮ ᏣᏥᏱ ᎠᎴ ᎾᏍᎩ ᏧᎦᏃᏮ ᎠᏍᏛᎭᏟ ᏚᎦᏚᏛ",
        "GT": "ᏩᏔᎹᎳ",
        "GU": "ᏆᎻ",
        "GW": "ᎫᏇ-ᏈᏌᎤᏫ",
        "GY": "ᎦᏯᎾ",
        "HK": "ᎰᏂᎩ ᎪᏂᎩ",
        "HM": "ᎲᏗ ᎤᎦᏚᏛ ᎠᎴ ᎺᎩᏓᎾᎵᏗ ᏚᎦᏚᏛ",
        "HR": "ᎧᎶᎡᏏᎠ",
        "HT": "ᎮᎢᏘ",
        "HU": "ᎲᏂᎦᎵ",
        "ID": "ᎢᏂᏙᏂᏍᏯ",
        "IE": "ᎠᎢᎴᏂᏗ",
        "IL": "ᎢᏏᎵᏱ",
        "IM": "ᎤᏍᏗ ᎤᎦᏚᏛ ᎾᎿ ᎠᏍᎦᏯ",
        "IN": "ᎢᏅᏗᎾ",
        "IO": "ᏈᏗᏏ ᏴᏫᏯ ᎠᎺᏉ ᎢᎬᎾᏕᏅ",
        "IQ": "ᎢᎳᎩ",
        "IR": "ᎢᎴᏂ",
        "IS": "ᏧᏁᏍᏓᎸᎯ",
        "IT": "ᏲᎶ",
        "JE": "ᏨᎵᏏ",
        "JM": "ᏣᎺᎢᎧ",
        "JO": "ᏦᏓᏂ",
        "JP": "ᏣᏩᏂᏏ",
        "KE": "ᎨᏂᏯ",
        "KG": "ᎩᎵᏣᎢᏍ",
        "KH": "ᎧᎹᏉᏗᎠᏂ",
        "KI": "ᎧᎵᏆᏘ",
        "KM": "ᎪᎼᎳᏍ",
        "KN": "ᎠᏰᏟ ᎾᎿ ᎨᏥᎸᏉᏗ ᎠᏂᏪᏌ ᎠᎴ ᎠᏂᏁᏫᏍ",
        "KP": "ᏧᏴᏢ ᎪᎵᎠ",
        "KR": "ᏧᎦᏃᏮ ᎪᎵᎠ",
        "KW": "ᎫᏪᎢᏘ",
        "KY": "ᎨᎢᎹᏂ ᏚᎦᏚᏛᎢ",
        "KZ": "ᎧᏎᎧᏍᏕᏂ",
        "LA": "ᎴᎣᏍ",
        "LB": "ᎴᏆᎾᏂ",
        "LI": "ᎵᎦᏗᏂᏍᏓᏂ",
        "LK": "ᏍᎵ ᎳᏂᎧ",
        "LR": "ᎳᏈᎵᏯ",
        "LS": "ᎴᏐᏙ",
        "LT": "ᎵᏗᏪᏂᎠ",
        "LU": "ᎸᎧᏎᏋᎩ",
        "LV": "ᎳᏘᏫᎠ",
        "LY": "ᎵᏈᏯ",
        "MA": "ᎼᎶᎪ",
        "MC": "ᎹᎾᎪ",
        "MD": "ᎹᎵᏙᏫᎠ",
        "ME": "ᎼᏂᏔᏁᎦᎶ",
        "MF": "ᎠᏥᎸᏉᏗ ᏡᏡ",
        "MG": "ᎹᏓᎦᏍᎧᎵ",
        "MH": "ᎹᏌᎵ ᏚᎪᏚᏛ",
        "MK": "ᎹᏏᏙᏂᎢᎠ",
        "ML": "ᎹᎵ",
        "MM": "ᎹᏯᎹᎵ",
        "MN": "ᎹᏂᎪᎵᎠ",
        "MO": "ᎹᎧᎣ (ᎤᏓᏤᎵᏓ ᏧᏂᎸᏫᏍᏓᏁᏗ ᎢᎬᎾᏕᎾ) ᏣᎢ",
        "MP": "ᎾᏍᎩ ᎤᏴᏢ ᏗᏜ ᎹᎵᎠᎾ ᏚᎦᏚᏛ",
        "MQ": "ᎹᏘᏂᎨ",
        "MR": "ᎹᏘᎢᏯ",
        "MS": "ᎹᏂᏘᏌᎳᏗ",
        "MT": "ᎹᎵᏔ",
        "MU": "ᎼᎵᏏᎥᏍ",
        "MV": "ᎹᎵᏗᏫᏍ",
        "MW": "ᎹᎳᏫ",
        "MX": "ᏍᏆᏂᏱ",
        "MY": "ᎹᎴᏏᎢᎠ",
        "MZ": "ᎼᏎᎻᏇᎩ",
        "NA": "ᎾᎻᏈᎢᏯ",
        "NC": "ᎢᏤ ᎧᎵᏙᏂᎠᏂ",
        "NF": "ᏃᎵᏬᎵᎩ ᎤᎦᏚᏛ",
        "NG": "ᏂᏥᎵᏯ",
        "NI": "ᏂᎧᎳᏆ",
        "NL": "ᏁᏛᎳᏂ",
        "NO": "ᏃᏪ",
        "NP": "ᏁᏆᎵ",
        "NR": "ᏃᎤᎷ",
        "NU": "ᏂᏳ",
        "NZ": "ᎢᏤ ᏏᎢᎴᏂᏗ",
        "OM": "ᎣᎺᏂ",
        "PA": "ᏆᎾᎹ",
        "PE": "ᏇᎷ",
        "PF": "ᎠᏂᎦᎸᏣ ᏆᎵᏂᏏᎠ",
        "PG": "ᏆᏇ ᎢᏤ ᎩᏂ",
        "PH": "ᎠᏂᏈᎵᎩᏃ",
        "PK": "ᏆᎩᏍᏖᏂ",
        "PL": "ᏉᎳᏂ",
        "PM": "ᏎᏂᏘ ᏈᏓ ᎠᎴ ᎻᏇᎶᏂ",
        "PN": "ᏈᎧᎵᏂ ᎤᎦᏚᏛᎢ",
        "PR": "ᏇᎡᏙ ᎵᎢᎪ",
        "PS": "ᏆᎴᏍᏗᏂᎠᏂ ᏄᎬᏫᏳᏌᏕᎩ",
        "PT": "ᏉᏥᎦᎳ",
        "PW": "ᏆᎴᎠᏫ",
        "PY": "ᏆᎳᏇᎢᏯ",
        "QA": "ᎧᏔᎵ",
        "RO": "ᎶᎹᏂᏯ",
        "RS": "ᏒᏈᏯ",
        "RU": "ᏲᏂᎢ",
        "RW": "ᎶᏩᏂᏓ",
        "SA": "ᏌᎤᏗ ᎡᎴᏈᎠ",
        "SB": "ᏐᎶᎹᏂ ᏚᎦᏚᏛ",
        "SC": "ᏏᎡᏥᎵᏍ",
        "SD": "ᏑᏕᏂ",
        "SE": "ᏍᏫᏕᏂ",
        "SG": "ᏏᏂᎦᏉᎵ",
        "SH": "ᎠᏥᎸᏉᏗ ᎮᎵᎾ",
        "SI": "ᏍᎶᏫᏂᎠ",
        "SK": "ᏍᎶᏩᎩᎠ",
        "SL": "ᏏᎡᎳ ᎴᎣᏂ",
        "US": "ᎠᎹᏰᏟ",
        "ZZ": "ᏄᏬᎵᏍᏛᎾ ᎤᏔᏂᏗᎦᏙᎯ"
    };
  }-*/;
}
