/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.transport;

import gnu.classpath.jdwp.Jdwp;
import gnu.classpath.jdwp.event.Event;
import gnu.classpath.jdwp.event.EventRequest;
import gnu.classpath.jdwp.transport.ITransport;
import gnu.classpath.jdwp.transport.JdwpPacket;
import gnu.classpath.jdwp.transport.TransportException;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class JdwpConnection
extends Thread {
    private static final byte[] _HANDSHAKE = new byte[]{74, 68, 87, 80, 45, 72, 97, 110, 100, 115, 104, 97, 107, 101};
    private ITransport _transport;
    private ArrayList _commandQueue;
    private boolean _shutdown;
    private DataInputStream _inStream;
    private DataOutputStream _outStream;
    private ByteArrayOutputStream _bytes;
    private DataOutputStream _doStream;

    public void initialize() throws TransportException {
        this._transport.initialize();
        try {
            this._inStream = new DataInputStream(this._transport.getInputStream());
            this._outStream = new DataOutputStream(this._transport.getOutputStream());
            this._doHandshake();
        }
        catch (IOException iOException) {
            throw new TransportException(iOException);
        }
    }

    private final void _doHandshake() throws IOException {
        byte[] byArray = new byte[_HANDSHAKE.length];
        this._inStream.readFully(byArray, 0, _HANDSHAKE.length);
        if (Arrays.equals(byArray, _HANDSHAKE)) {
            this._outStream.write(_HANDSHAKE, 0, _HANDSHAKE.length);
            return;
        }
        throw new IOException("invalid JDWP handshake (\"" + byArray + "\")");
    }

    public void run() {
        while (!this._shutdown) {
            try {
                this._readOnePacket();
            }
            catch (IOException iOException) {
                Jdwp.getDefault().shutdown();
            }
            catch (Throwable throwable) {
                System.out.println("JdwpConnection.run: caught an exception: " + throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void _readOnePacket() throws IOException {
        byte[] byArray = null;
        int n = this._inStream.readInt();
        if (n < 11) {
            throw new IOException("JDWP packet length < 11 (" + n + ')');
        }
        byArray = new byte[n];
        byArray[0] = (byte)(n >>> 24);
        byArray[1] = (byte)(n >>> 16);
        byArray[2] = (byte)(n >>> 8);
        byArray[3] = (byte)n;
        this._inStream.readFully(byArray, 4, n - 4);
        JdwpPacket jdwpPacket = JdwpPacket.fromBytes(byArray);
        if (jdwpPacket == null) return;
        ArrayList arrayList = this._commandQueue;
        synchronized (arrayList) {
            this._commandQueue.add(jdwpPacket);
            this._commandQueue.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JdwpPacket getPacket() {
        ArrayList arrayList = this._commandQueue;
        synchronized (arrayList) {
            while (this._commandQueue.isEmpty()) {
                try {
                    this._commandQueue.wait();
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
            }
            return (JdwpPacket)this._commandQueue.remove(0);
        }
    }

    public void sendPacket(JdwpPacket jdwpPacket) throws IOException {
        jdwpPacket.write(this._outStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendEvent(EventRequest eventRequest, Event event) throws IOException {
        JdwpPacket jdwpPacket;
        ByteArrayOutputStream byteArrayOutputStream = this._bytes;
        synchronized (byteArrayOutputStream) {
            this._bytes.reset();
            jdwpPacket = event.toPacket(this._doStream, eventRequest);
            jdwpPacket.setData(this._bytes.toByteArray());
        }
        this.sendPacket(jdwpPacket);
    }

    public void shutdown() {
        if (!this._shutdown) {
            this._transport.shutdown();
            this._shutdown = true;
            this.interrupt();
        }
    }

    public JdwpConnection(ThreadGroup threadGroup, ITransport iTransport) {
        super(threadGroup, "JDWP connection thread");
        this._transport = iTransport;
        this._commandQueue = new ArrayList();
        this._shutdown = false;
        this._bytes = new ByteArrayOutputStream();
        this._doStream = new DataOutputStream(this._bytes);
    }
}

