/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.SSLSocket;
import gnu.javax.net.ssl.provider.SessionContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

class SSLSocketFactory
extends javax.net.ssl.SSLSocketFactory {
    private final X509TrustManager trustManager;
    private final X509KeyManager keyManager;
    private final SecureRandom random;
    private final SessionContext sessionContext;

    public String[] getDefaultCipherSuites() {
        return (String[])CipherSuite.availableSuiteNames().toArray(new String[0]);
    }

    public String[] getSupportedCipherSuites() {
        return this.getDefaultCipherSuites();
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
        return this.setup(new SSLSocket(socket, string, n, bl));
    }

    public Socket createSocket() throws IOException {
        return this.setup(new SSLSocket());
    }

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        return this.setup(new SSLSocket(string, n));
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        return this.setup(new SSLSocket(string, n, inetAddress, n2));
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        return this.setup(new SSLSocket(inetAddress, n));
    }

    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        return this.setup(new SSLSocket(inetAddress, n, inetAddress2, n2));
    }

    private final SSLSocket setup(SSLSocket sSLSocket) {
        sSLSocket.setTrustManager(this.trustManager);
        sSLSocket.setKeyManager(this.keyManager);
        sSLSocket.setRandom(this.random);
        sSLSocket.setSessionContext(this.sessionContext);
        sSLSocket.setUseClientMode(true);
        return sSLSocket;
    }

    SSLSocketFactory(X509TrustManager x509TrustManager, X509KeyManager x509KeyManager, SecureRandom secureRandom, SessionContext sessionContext) {
        this.trustManager = x509TrustManager;
        this.keyManager = x509KeyManager;
        this.random = secureRandom;
        this.sessionContext = sessionContext;
    }
}

