/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;

public class PipedOutputStream
extends OutputStream {
    PipedInputStream sink;
    boolean closed;

    public void connect(PipedInputStream pipedInputStream) throws IOException {
        if (this.sink != null || pipedInputStream.source != null) {
            throw new IOException("Already connected");
        }
        pipedInputStream.connect(this);
    }

    public void write(int n) throws IOException {
        if (this.sink == null) {
            throw new IOException("Not connected");
        }
        if (this.closed) {
            throw new IOException("Pipe closed");
        }
        this.sink.receive(n);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.sink == null) {
            throw new IOException("Not connected");
        }
        if (this.closed) {
            throw new IOException("Pipe closed");
        }
        this.sink.receive(byArray, n, n2);
    }

    public void flush() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        if (this.sink == null) return;
        this.closed = true;
        PipedInputStream pipedInputStream = this.sink;
        synchronized (pipedInputStream) {
            this.sink.notifyAll();
            return;
        }
    }

    public PipedOutputStream() {
    }

    public PipedOutputStream(PipedInputStream pipedInputStream) throws IOException {
        pipedInputStream.connect(this);
    }
}

