# Copyright (C) 2008 LottaNZB Development Team
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

"""Contains classes for all messages put out by the SmartPar module."""

from lottanzb.hellalog import LogRecord, _Plural
from lottanzb.util import _

class SmartDequeueFatal(LogRecord): # smartDequeue(...)
    PATTERN = r"^smartDequeue on number > 1$"
    TEMPLATE = _("smartDequeue only accepts the first segment.")

class SkippedInfo(LogRecord): # smartDequeue(...)
    PATTERN = r"^Skipped (?P<par_type>.+): (?P<file_name>.+) \((?P<size>\d+)MB\)$"
    TEMPLATE = _("Skipped %(par_type)s: %(file_name)s (%(size)sMB)")

class SkippingInfo(LogRecord): # smartDequeue(...)
    PATTERN = r"^Skipping pars\.\. \(Skipped (?P<par_type>.+): (?P<file_name>.+) \((?P<size>\d+)MB\)\)$"
    TEMPLATE = _("Skipping pars... (Skipped %(par_type)s: %(file_name)s (%(size)sMB))")

class QueuedInfo(LogRecord): # smartDequeue(...)
    PATTERN = r"^Queued (?P<par_type>.+): (?P<file_name>.+) \((?P<size>\d+)MB, (?P<par_size>\d+) (?P<recovery_name>.*)\)$"
    TEMPLATE = _("Queued %(par_type)s: %(file_name)s (%(size)sMB, %(par_size)s %(recovery_name)s)")

class ParOnlyRequeueingInfo(LogRecord): # smartRequeue(...)
    PATTERN = r"^(?P<archive_name>.+): Par only archive: requeueing all pars for download$"
    TEMPLATE = _("%(archive_name)s: PAR-only archive: Requeueing all PAR files for download")

class MainMissingRequeueingInfo(LogRecord): # smartRequeue(...)
    PATTERN = r"^(?P<archive_name>.+): didn't find a main par file, requeueing extra par: (?P<file_name>.+)$"
    TEMPLATE = _("%(archive_name)s: Could not find a main PAR file: Requeueing additional PAR file: %(file_name)s")

class AcutualSkippedInfo(_Plural, LogRecord): # logSkippedPars(...)
    PATTERN = r"^Skipped pars: (?P<file_count>\d+) files, (?P<size>.+) \(actual skipped: (?P<actual_size>.+)\)$"
    TEMPLATE = _("Skipped pars: %(file_count)s file, %(size)s (Actual skipped: %(actual_size)s)")
    TEMPLATE_2 = _("Skipped pars: %(file_count)s files, %(size)s (Actual skipped: %(actual_size)s)")

# Interesting information, but horrible to translate. Untested. ^^
class DetailedSkippedInfo(LogRecord):  # logSkippedPars(...)
    PATTERN = r"^ (?P<first_file_name>.+)((,\n | ->\n )(?P<last_file_name>.+))? \(((?P<file_count>\d+) files, (?P<size>.+), )?(?P<skipped_block_groups>.+) (?P<recovery_name>.*)\)$"

