/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image.renderable;

import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ContextualRenderedImageFactory;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.util.Vector;

public class RenderableImageOp
implements RenderableImage {
    private final ContextualRenderedImageFactory crif;
    private ParameterBlock block;

    public Vector getSources() {
        if (this.block.sources == null) {
            return null;
        }
        int size = this.block.sources.size();
        Vector v = new Vector();
        int i = 0;
        while (i < size) {
            Object o = this.block.sources.get(i);
            if (o instanceof RenderableImage) {
                v.add(o);
            }
            ++i;
        }
        return v;
    }

    public Object getProperty(String name) {
        return this.crif.getProperty(this.block, name);
    }

    public String[] getPropertyNames() {
        return this.crif.getPropertyNames();
    }

    public boolean isDynamic() {
        return this.crif.isDynamic();
    }

    public float getWidth() {
        return (float)this.crif.getBounds2D(this.block).getWidth();
    }

    public float getHeight() {
        return (float)this.crif.getBounds2D(this.block).getHeight();
    }

    public float getMinX() {
        return (float)this.crif.getBounds2D(this.block).getX();
    }

    public float getMinY() {
        return (float)this.crif.getBounds2D(this.block).getY();
    }

    public ParameterBlock setParameterBlock(ParameterBlock block) {
        ParameterBlock result = this.block;
        this.block = (ParameterBlock)block.clone();
        return result;
    }

    public ParameterBlock getParameterBlock() {
        return this.block;
    }

    public RenderedImage createScaledRendering(int w, int h, RenderingHints hints) {
        if (w == 0) {
            if (h == 0) {
                throw new IllegalArgumentException();
            }
            w = Math.round((float)h * this.getWidth() / this.getHeight());
        }
        if (h == 0) {
            h = Math.round((float)w * this.getHeight() / this.getWidth());
        }
        AffineTransform xform = AffineTransform.getScaleInstance((float)w * this.getWidth(), (float)h * this.getHeight());
        return this.createRendering(new RenderContext(xform, hints));
    }

    public RenderedImage createDefaultRendering() {
        return this.createRendering(new RenderContext(new AffineTransform()));
    }

    public RenderedImage createRendering(RenderContext context) {
        ParameterBlock copy = (ParameterBlock)this.block.clone();
        int i = this.block.sources.size();
        while (--i >= 0) {
            Object o = this.block.sources.get(i);
            if (!(o instanceof RenderableImage)) continue;
            RenderableImage ri = (RenderableImage)o;
            RenderContext rc = this.crif.mapRenderContext(i, context, this.block, ri);
            copy.sources.set(i, ri.createRendering(rc));
        }
        return this.crif.create(context, copy);
    }

    public RenderableImageOp(ContextualRenderedImageFactory crif, ParameterBlock block) {
        this.crif = crif;
        this.block = (ParameterBlock)block.clone();
    }
}

