/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.dto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.activemq.apollo.util.ClassFinder;
import org.apache.activemq.apollo.util.DtoModule$;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlCodec {
    private static final XMLInputFactory factory = XMLInputFactory.newInstance();
    public static volatile JAXBContext _context;

    private static JAXBContext context() throws JAXBException {
        JAXBContext rc = _context;
        if (rc == null) {
            rc = _context = XmlCodec.createContext();
        }
        return rc;
    }

    private static JAXBContext createContext() throws JAXBException {
        String packages = "";
        for (String p : DtoModule$.MODULE$.packages()) {
            if (packages.length() != 0) {
                packages = packages + ":";
            }
            packages = packages + p;
        }
        return JAXBContext.newInstance((String)packages);
    }

    public static <T> T decode(Class<T> clazz, URL url) throws IOException, XMLStreamException, JAXBException, SAXException {
        return XmlCodec.decode(clazz, url, null);
    }

    public static <T> T decode(Class<T> clazz, URL url, Properties props) throws IOException, XMLStreamException, JAXBException, SAXException {
        return XmlCodec.decode(clazz, url.openStream(), props);
    }

    public static <T> T decode(Class<T> clazz, InputStream is) throws IOException, XMLStreamException, JAXBException, SAXException {
        return XmlCodec.decode(clazz, is, null);
    }

    public static <T> T decode(Class<T> clazz, InputStream is, Properties props) throws IOException, XMLStreamException, JAXBException, SAXException {
        return XmlCodec.decode(clazz, is, props, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T decode(Class<T> clazz, InputStream is, Properties props, ValidationEventHandler validationHandler) throws IOException, XMLStreamException, JAXBException, SAXException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            T t;
            Thread.currentThread().setContextClassLoader(ClassFinder.class_loader());
            if (is == null) {
                throw new IllegalArgumentException("input stream was null");
            }
            try {
                XMLStreamReader reader = factory.createXMLStreamReader(is);
                if (props != null) {
                    reader = new PropertiesFilter(reader, props);
                }
                Unmarshaller unmarshaller = XmlCodec.context().createUnmarshaller();
                if (validationHandler != null) {
                    try {
                        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                        sf.setFeature("http://apache.org/xml/features/validation/schema-full-checking", false);
                        Schema schema = sf.newSchema(XmlCodec.class.getResource("apollo.xsd"));
                        unmarshaller.setSchema(schema);
                        unmarshaller.setEventHandler(validationHandler);
                    }
                    catch (Exception e) {
                        System.err.println("Could not load schema: " + e.getMessage());
                    }
                }
                t = clazz.cast(unmarshaller.unmarshal(reader));
            }
            catch (Throwable throwable) {
                is.close();
                throw throwable;
            }
            is.close();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encode(Object in, OutputStream os, boolean format) throws JAXBException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ClassFinder.class_loader());
            Marshaller marshaller = XmlCodec.context().createMarshaller();
            if (format) {
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            }
            marshaller.marshal(in, (Writer)new OutputStreamWriter(os));
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public static class PropertiesFilter
    extends StreamReaderDelegate {
        static final Pattern pattern = Pattern.compile("\\$\\{([^\\}]+)\\}");
        private final Properties props;

        public PropertiesFilter(XMLStreamReader parent, Properties props) {
            super(parent);
            this.props = props;
        }

        public String getAttributeValue(int index) {
            return this.filter(super.getAttributeValue(index));
        }

        public String filter(String str) {
            Matcher matcher;
            int start = 0;
            while ((matcher = pattern.matcher(str)).find(start)) {
                String group = matcher.group(1);
                String property = this.props.getProperty(group);
                if (property != null) {
                    str = matcher.replaceFirst(Matcher.quoteReplacement(property));
                    continue;
                }
                start = matcher.end();
            }
            return str;
        }
    }
}

