/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.util;

import java.util.LinkedList;
import org.apache.activemq.apollo.util.Service;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.Task;

public abstract class JavaBaseService
implements Service {
    public static final State CREATED = new State();
    public static final State STARTED = new State(){

        public boolean isStarted() {
            return true;
        }
    };
    public static final State STOPPED = new State();
    protected State _serviceState = CREATED;

    public final void start(final Task onCompleted) {
        this.getDispatchQueue().execute(new Task(){

            public void run() {
                if (JavaBaseService.this._serviceState == CREATED || JavaBaseService.this._serviceState == STOPPED) {
                    final STARTING state = new STARTING();
                    state.add(onCompleted);
                    JavaBaseService.this._serviceState = state;
                    JavaBaseService.this._start(new Task(){

                        public void run() {
                            JavaBaseService.this._serviceState = STARTED;
                            state.done();
                        }
                    });
                } else if (JavaBaseService.this._serviceState instanceof STARTING) {
                    ((STARTING)JavaBaseService.this._serviceState).add(onCompleted);
                } else if (JavaBaseService.this._serviceState == STARTED) {
                    if (onCompleted != null) {
                        onCompleted.run();
                    }
                } else {
                    if (onCompleted != null) {
                        onCompleted.run();
                    }
                    JavaBaseService.this.error("start should not be called from state: " + JavaBaseService.this._serviceState);
                }
            }
        });
    }

    public final void stop(final Task onCompleted) {
        this.getDispatchQueue().execute(new Task(){

            public void run() {
                if (JavaBaseService.this._serviceState == STARTED) {
                    final STOPPING state = new STOPPING();
                    state.add(onCompleted);
                    JavaBaseService.this._serviceState = state;
                    JavaBaseService.this._stop(new Task(){

                        public void run() {
                            JavaBaseService.this._serviceState = STOPPED;
                            state.done();
                        }
                    });
                } else if (JavaBaseService.this._serviceState instanceof STOPPING) {
                    ((STOPPING)JavaBaseService.this._serviceState).add(onCompleted);
                } else if (JavaBaseService.this._serviceState == STOPPED) {
                    if (onCompleted != null) {
                        onCompleted.run();
                    }
                } else {
                    if (onCompleted != null) {
                        onCompleted.run();
                    }
                    JavaBaseService.this.error("stop should not be called from state: " + JavaBaseService.this._serviceState);
                }
            }
        });
    }

    private void error(String msg) {
        try {
            throw new AssertionError((Object)msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    protected State getServiceState() {
        return this._serviceState;
    }

    protected abstract DispatchQueue getDispatchQueue();

    protected abstract void _start(Task var1);

    protected abstract void _stop(Task var1);

    public static class STOPPING
    extends CallbackSupport {
    }

    public static class STARTING
    extends CallbackSupport {
    }

    static class CallbackSupport
    extends State {
        LinkedList<Task> callbacks = new LinkedList();

        CallbackSupport() {
        }

        void add(Task r) {
            if (r != null) {
                this.callbacks.add(r);
            }
        }

        void done() {
            for (Task callback2 : this.callbacks) {
                callback2.run();
            }
        }
    }

    public static class State {
        public String toString() {
            return this.getClass().getSimpleName();
        }

        public boolean isStarted() {
            return false;
        }
    }
}

