/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.jsp.logic;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.igoweb.igoweb.jsp.logic.TimeUnit;
import org.igoweb.igoweb.shared.I18nDesc;
import org.igoweb.util.DbConn;
import org.igoweb.util.DbConnFactory;

public class Product {
    private int id;
    private I18nDesc names;
    private int duration;
    private TimeUnit units;
    private double cost;
    private boolean available;
    private boolean tournPrize;
    private boolean adminsOnly;
    private int roomRequired;

    private Product(DbConn db, ResultSet rs) throws SQLException {
        this.id = rs.getInt("id");
        this.cost = rs.getDouble("cost");
        if (rs.wasNull()) {
            this.cost = 0.0;
        }
        this.duration = rs.getInt("duration");
        if (rs.wasNull()) {
            this.duration = 0;
        } else {
            this.units = TimeUnit.get(rs.getString("duration_units"));
        }
        this.tournPrize = rs.getBoolean("has_tourn");
        this.available = rs.getBoolean("available");
        this.adminsOnly = rs.getBoolean("admins_only");
        this.roomRequired = rs.getInt("room_id");
        if (rs.wasNull()) {
            this.roomRequired = 0;
        }
        this.names = new I18nDesc(db, this.id, I18nDesc.Type.PRODUCT_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Product> getAll(DbConn db) throws SQLException {
        try (ResultSet rs = null;){
            rs = db.executeQuery("SELECT * FROM products");
            ArrayList<Product> result = new ArrayList<Product>();
            while (rs.next()) {
                Product product = new Product(db, rs);
                while (result.size() <= product.id) {
                    result.add(null);
                }
                result.set(product.id, product);
            }
            ArrayList<Product> arrayList = result;
            return arrayList;
        }
    }

    public int getId() {
        return this.id;
    }

    public double getCost() {
        return this.cost;
    }

    public final boolean isPurchaseable(int userAuthLevel, int userId, DbConn db) throws SQLException {
        return this.isPurchaseable(userAuthLevel, userId, null, db);
    }

    public final boolean isPurchaseable(int userAuthLevel, int userId, DbConnFactory dbFactory) throws SQLException {
        return this.isPurchaseable(userAuthLevel, userId, dbFactory, null);
    }

    protected boolean isPurchaseable(int userAuthLevel, int userId, DbConnFactory dbFactory, DbConn db) throws SQLException {
        if (!this.available || this.adminsOnly && userAuthLevel < 3) {
            return false;
        }
        if (this.roomRequired == 0) {
            return true;
        }
        boolean keepDb = true;
        if (db == null) {
            db = dbFactory.getDbConn();
            keepDb = false;
        }
        ResultSet rs = null;
        try {
            PreparedStatement stmt = db.get("SELECT COUNT(*) FROM rooms_members  WHERE room_id = ? AND account_id = ? AND type = 'access'");
            stmt.setInt(1, this.roomRequired);
            stmt.setInt(2, userId);
            rs = stmt.executeQuery();
            rs.next();
            boolean bl = rs.getInt(1) > 0;
            return bl;
        }
        catch (SQLException excep) {
            db.error();
            throw excep;
        }
        finally {
            if (keepDb) {
                rs.close();
            } else {
                db.close(rs);
            }
        }
    }

    public boolean isAvailable() {
        return this.available;
    }

    public int getDuration() {
        return this.duration;
    }

    public TimeUnit getDurationUnits() {
        return this.units;
    }

    public boolean isTournPrize() {
        return this.tournPrize;
    }

    public void testDuration(int testDuration, TimeUnit testUnits) {
        if (this.duration != 0 && (this.duration != testDuration || this.units != testUnits)) {
            throw new IllegalArgumentException("Product ID " + this.id + " must have a duration of " + this.duration + " " + (Object)((Object)this.units) + ", but " + testDuration + " " + (Object)((Object)testUnits) + " was requested");
        }
    }

    public I18nDesc getNames() {
        return this.names;
    }

    public String toString() {
        return "Product[id=" + this.id + ", duration=" + this.duration + ", units=" + (Object)((Object)this.units) + ", cost=" + this.cost + (this.available ? ", available" : "") + (this.tournPrize ? ", tournPrize" : "") + (this.adminsOnly ? ", adminsOnly" : "") + "]";
    }
}

