/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.presenter;

import java.awt.Point;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.ComponentType;
import org.diylc.common.Orientation;
import org.diylc.common.OrientationHV;
import org.diylc.common.PropertyWrapper;
import org.diylc.core.CreationMethod;
import org.diylc.core.IDIYComponent;
import org.diylc.core.Project;
import org.diylc.core.Template;
import org.diylc.core.measures.Size;
import org.diylc.presenter.CalcUtils;
import org.diylc.presenter.ComponentProcessor;

public class InstantiationManager {
    private static final Logger LOG = Logger.getLogger(InstantiationManager.class);
    public static int MAX_RECENT_COMPONENTS = 16;
    private ComponentType componentTypeSlot;
    private Template template;
    private List<IDIYComponent<?>> componentSlot;
    private Point firstControlPoint;
    private Point potentialControlPoint;
    private static final ComponentType clipboardType = new ComponentType("Clipboard contents", "Components from the clipboard", CreationMethod.SINGLE_CLICK, "Multi", "", "", null, null, 0.0, false, false, null, false, true);

    public ComponentType getComponentTypeSlot() {
        return this.componentTypeSlot;
    }

    public Template getTemplate() {
        return this.template;
    }

    public List<IDIYComponent<?>> getComponentSlot() {
        return this.componentSlot;
    }

    public Point getFirstControlPoint() {
        return this.firstControlPoint;
    }

    public Point getPotentialControlPoint() {
        return this.potentialControlPoint;
    }

    public void setComponentTypeSlot(ComponentType componentType, Template template, Project project) throws Exception {
        this.componentTypeSlot = componentType;
        this.template = template;
        if (componentType == null) {
            this.componentSlot = null;
        } else {
            switch (componentType.getCreationMethod()) {
                case POINT_BY_POINT: {
                    this.componentSlot = null;
                    break;
                }
                case SINGLE_CLICK: {
                    this.componentSlot = this.instantiateComponent(componentType, template, new Point(0, 0), project);
                }
            }
        }
        this.firstControlPoint = null;
        this.potentialControlPoint = null;
    }

    public void instatiatePointByPoint(Point point, Project project) throws Exception {
        this.firstControlPoint = point;
        this.componentSlot = this.instantiateComponent(this.componentTypeSlot, this.template, this.firstControlPoint, project);
        this.componentSlot.get(0).setControlPoint(this.firstControlPoint, 0);
        this.componentSlot.get(0).setControlPoint(this.firstControlPoint, 1);
    }

    public boolean updatePointByPoint(Point point) {
        boolean bl = !point.equals(this.potentialControlPoint);
        this.potentialControlPoint = point;
        if (this.componentSlot != null && !this.componentSlot.isEmpty()) {
            this.componentSlot.get(0).setControlPoint(point, 1);
        }
        return bl;
    }

    public void pasteComponents(List<IDIYComponent<?>> list, Point point, boolean bl, Size size) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (IDIYComponent<?> iDIYComponent : list) {
            for (int i = 0; i < iDIYComponent.getControlPointCount(); ++i) {
                Point serializable = iDIYComponent.getControlPoint(i);
                if (serializable.x > n2) {
                    n2 = serializable.x;
                }
                if (serializable.x < n) {
                    n = serializable.x;
                }
                if (serializable.y > n4) {
                    n4 = serializable.y;
                }
                if (serializable.y >= n3) continue;
                n3 = serializable.y;
            }
        }
        int n5 = n;
        int n6 = n3;
        if (bl) {
            n5 = CalcUtils.roundToGrid(n5, size);
            n5 = CalcUtils.roundToGrid(n5, size);
        }
        for (IDIYComponent<?> iDIYComponent : list) {
            for (int i = 0; i < iDIYComponent.getControlPointCount(); ++i) {
                Point point2 = iDIYComponent.getControlPoint(i);
                point2.translate(-n5, -n6);
                iDIYComponent.setControlPoint(point2, i);
            }
        }
        this.componentSlot = new ArrayList(list);
        this.componentTypeSlot = clipboardType;
        if (bl) {
            point = new Point(point);
            CalcUtils.snapPointToGrid(point, size);
        }
        this.updateSingleClick(point, bl, size);
    }

    public boolean updateSingleClick(Point point, boolean bl, Size size) {
        if (this.potentialControlPoint == null) {
            this.potentialControlPoint = new Point(0, 0);
        }
        if (point == null) {
            point = new Point(0, 0);
        }
        int n = point.x - this.potentialControlPoint.x;
        int n2 = point.y - this.potentialControlPoint.y;
        if (bl) {
            n = CalcUtils.roundToGrid(n, size);
            n2 = CalcUtils.roundToGrid(n2, size);
        }
        if (n == 0 && n2 == 0) {
            return false;
        }
        this.potentialControlPoint.translate(n, n2);
        if (this.componentSlot == null) {
            LOG.error((Object)"Component slot should not be null!");
        } else {
            Point point2 = new Point();
            for (IDIYComponent<?> iDIYComponent : this.componentSlot) {
                for (int i = 0; i < iDIYComponent.getControlPointCount(); ++i) {
                    point2.setLocation(iDIYComponent.getControlPoint(i));
                    point2.translate(n, n2);
                    iDIYComponent.setControlPoint(point2, i);
                }
            }
        }
        return true;
    }

    public List<IDIYComponent<?>> instantiateComponent(ComponentType componentType, Template template, Point point, Project project) throws Exception {
        Object object;
        LOG.info((Object)("Instatiating component of type: " + componentType.getInstanceClass().getName()));
        IDIYComponent<?> iDIYComponent = componentType.getInstanceClass().newInstance();
        iDIYComponent.setName(this.createUniqueName(componentType, project));
        if (point != null) {
            for (int i = 0; i < iDIYComponent.getControlPointCount(); ++i) {
                object = new Point(iDIYComponent.getControlPoint(i));
                ((Point)object).translate(point.x, point.y);
                iDIYComponent.setControlPoint((Point)object, i);
            }
        }
        this.loadComponentShapeFromTemplate(iDIYComponent, template);
        this.fillWithDefaultProperties(iDIYComponent, template);
        List list = (List)ConfigurationManager.getInstance().readObject("recentComponents", new ArrayList());
        object = componentType.getInstanceClass().getName();
        if (list.size() == 0 || !((String)list.get(0)).equals(object)) {
            list.remove(object);
            list.add(0, object);
            if (list.size() > MAX_RECENT_COMPONENTS) {
                list.remove(list.size() - 1);
            }
            ConfigurationManager.getInstance().writeValue("recentComponents", (Object)list);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(iDIYComponent);
        return arrayList;
    }

    public String createUniqueName(ComponentType componentType, Project project) {
        int n;
        boolean bl = true;
        List<IDIYComponent<?>> list = project.getComponents();
        Object[] objectArray = new String[list.size()];
        for (n = 0; n < project.getComponents().size(); ++n) {
            objectArray[n] = list.get(n).getName();
        }
        Arrays.sort(objectArray);
        n = 0;
        while (bl) {
            String string = componentType.getNamePrefix() + ++n;
            bl = false;
            if (Arrays.binarySearch(objectArray, string) < 0) continue;
            bl = true;
        }
        return componentType.getNamePrefix() + n;
    }

    public void fillWithDefaultProperties(Object object, Template template) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Object object2;
        List<PropertyWrapper> list = ComponentProcessor.getInstance().extractProperties(object.getClass());
        HashMap<String, PropertyWrapper> hashMap = new HashMap<String, PropertyWrapper>();
        for (PropertyWrapper object3 : list) {
            hashMap.put(object3.getName(), object3);
            object2 = ConfigurationManager.getInstance().readObject("default." + object.getClass().getName() + ":" + object3.getName(), null);
            if (object2 == null) continue;
            object3.setValue(object2);
            object3.writeTo(object);
        }
        if (template != null) {
            for (Map.Entry entry : template.getValues().entrySet()) {
                object2 = (PropertyWrapper)hashMap.get(entry.getKey());
                if (object2 == null) {
                    LOG.warn((Object)("Cannot find property " + (String)entry.getKey()));
                    continue;
                }
                LOG.debug((Object)("Filling value from template for " + (String)entry.getKey()));
                ((PropertyWrapper)object2).setValue(entry.getValue());
                ((PropertyWrapper)object2).writeTo(object);
            }
        }
    }

    public void loadComponentShapeFromTemplate(IDIYComponent<?> iDIYComponent, Template template) {
        if (template != null && template.getPoints() != null && template.getPoints().size() >= iDIYComponent.getControlPointCount()) {
            for (int i = 0; i < iDIYComponent.getControlPointCount(); ++i) {
                Point point = new Point(iDIYComponent.getControlPoint(0));
                point.translate(template.getPoints().get((int)i).x, template.getPoints().get((int)i).y);
                iDIYComponent.setControlPoint(point, i);
            }
        }
    }

    public void tryToRotateComponentSlot() {
        if (this.componentSlot == null) {
            LOG.debug((Object)"Component slot is empty, cannot rotate");
            return;
        }
        List<PropertyWrapper> list = ComponentProcessor.getInstance().extractProperties(this.componentTypeSlot.getInstanceClass());
        PropertyWrapper propertyWrapper = null;
        for (PropertyWrapper object : list) {
            if (!object.getType().getName().equals(Orientation.class.getName()) && !object.getType().getName().equals(OrientationHV.class.getName())) continue;
            propertyWrapper = object;
            break;
        }
        if (propertyWrapper == null) {
            LOG.debug((Object)"Component in the slot does not have a property of type Orientation, cannot rotate");
            return;
        }
        try {
            for (IDIYComponent iDIYComponent : this.componentSlot) {
                propertyWrapper.readFrom(iDIYComponent);
                Object object = propertyWrapper.getValue();
                if (object instanceof Orientation) {
                    propertyWrapper.setValue((Object)Orientation.values()[(((Orientation)((Object)object)).ordinal() + 1) % Orientation.values().length]);
                } else if (object instanceof OrientationHV) {
                    propertyWrapper.setValue((Object)OrientationHV.values()[(((OrientationHV)((Object)object)).ordinal() + 1) % OrientationHV.values().length]);
                }
                propertyWrapper.writeTo(iDIYComponent);
            }
        }
        catch (Exception exception) {
            LOG.warn((Object)"Error trying to rotate the component", (Throwable)exception);
        }
    }
}

