/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.FlowLayout;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.LoadingSavegameInfo;
import net.sf.freecol.client.gui.panel.FreeColConfirmDialog;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;

public final class LoadingSavegameDialog
extends FreeColConfirmDialog {
    private static final Logger logger = Logger.getLogger(LoadingSavegameDialog.class.getName());
    private final JRadioButton singlePlayer;
    private final JRadioButton privateMultiplayer;
    private final JRadioButton publicMultiplayer;
    private final JTextField serverNameField;
    private final JSpinner portField;

    public LoadingSavegameDialog(FreeColClient freeColClient, JFrame frame) {
        super(freeColClient, frame);
        JPanel panel = new JPanel();
        panel.setBorder(Utility.blankBorder(10, 10, 10, 10));
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setOpaque(false);
        JLabel header = Utility.localizedHeaderLabel(Messages.nameKey("loadingSavegameDialog"), 0, FontLibrary.FontSize.MEDIUM);
        header.setBorder(Utility.blankBorder(20, 0, 0, 0));
        JPanel p1 = new JPanel(new FlowLayout(0));
        p1.add(Utility.localizedLabel("loadingSavegameDialog.serverName"));
        this.serverNameField = new JTextField();
        JPanel p2 = new JPanel(new FlowLayout(0));
        p2.add(Utility.localizedLabel("loadingSavegameDialog.port"));
        this.portField = new JSpinner(new SpinnerNumberModel(FreeCol.getServerPort(), 1, 65536, 1));
        ButtonGroup bg = new ButtonGroup();
        String str = Messages.message("loadingSavegameDialog.singlePlayer");
        this.singlePlayer = new JRadioButton(str);
        bg.add(this.singlePlayer);
        str = Messages.message("loadingSavegameDialog.privateMultiplayer");
        this.privateMultiplayer = new JRadioButton(str);
        bg.add(this.privateMultiplayer);
        str = Messages.message("loadingSavegameDialog.publicMultiplayer");
        this.publicMultiplayer = new JRadioButton(str);
        bg.add(this.publicMultiplayer);
        panel.add(header);
        panel.add(p1);
        panel.add(this.serverNameField);
        panel.add(p2);
        panel.add(this.portField);
        panel.add(this.singlePlayer);
        panel.add(this.privateMultiplayer);
        panel.add(this.publicMultiplayer);
        panel.setSize(panel.getPreferredSize());
        this.initializeConfirmDialog(frame, true, panel, null, "ok", "cancel");
    }

    public boolean isSinglePlayer() {
        return this.singlePlayer.isSelected();
    }

    public boolean isPublic() {
        return this.publicMultiplayer.isSelected();
    }

    public int getPort() {
        return (Integer)this.portField.getValue();
    }

    public String getServerName() {
        return this.serverNameField.getName();
    }

    public LoadingSavegameInfo getInfo() {
        return new LoadingSavegameInfo(this.isSinglePlayer(), this.getPort(), this.getServerName());
    }

    public void reset(boolean publicServer, boolean singlePlayer) {
        this.singlePlayer.setSelected(false);
        this.privateMultiplayer.setSelected(false);
        this.publicMultiplayer.setSelected(false);
        if (singlePlayer) {
            this.singlePlayer.setSelected(true);
        } else if (publicServer) {
            this.publicMultiplayer.setSelected(true);
        } else {
            this.privateMultiplayer.setSelected(true);
        }
        this.serverNameField.setText("");
    }
}

