#                                                         -*- Perl -*-
# Copyright (c) 2000  Motoyuki Kasahara
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

#
# ñ쥯饹 (FreePWING::Word)ñ쥯饹
# (FreePWING::EndWord) Ʊ륯饹
#
package FreePWING::FPWUtils::Word2;

require 5.005;
use English;
use FreePWING::Word2;
use FreePWING::FPWUtils::FPWUtils;
use strict;
use integer;

use vars qw(@ISA
	    @EXPORT
	    @EXPORT_OK);

@ISA = qw(FreePWING::Word2);

#
# :
#	new()
# ᥽åɤζʬ:
# 	public 饹᥽åɡ
# :
# 	֥Ȥ롣
# :
# 	֥ȤؤΥե󥹤֤
#
sub new {
    my $type = shift;
    return $type->SUPER::new();
}

#
# :
#	open()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	񤭹ѤθФե򳫤
# :
#	 1 ֤Ԥ 0 ֤
#
sub open {
    my $self = shift;
    
    return $self->SUPER::open($word_file_name, $endword_file_name);
}

#
# :
#	add_entry(word)
#           word
#		ñ
#           heading_position
#               Фΰ
#           text_position
#               ʸΰ
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	ñեñɲä롣
# :
#	 1 ֤Ԥ 0 ֤
# :
#	FreePWING 1.1 ޤǤϡΥ᥽åɤθƤӽФ
#	   add_entry(word, heading_position, heading_file_name,
#	           text_position, text_file_name)
#	äΤǡΤθߴĤƤ롣
#
sub add_entry {
    my $self = shift;
    my ($word, $heading_position, $text_position) = @ARG;

    if (@ARG == 5) {
	$heading_position = $ARG[1];
	$text_position = $ARG[3];
    }

    return $self->SUPER::add_entry($word,
				   $heading_position, $heading_file_name,
				   $text_position, $text_file_name);
}

1;
