/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import net.sf.gogui.game.GameTree;
import net.sf.gogui.game.Node;
import net.sf.gogui.gui.GameTreePanel;
import net.sf.gogui.gui.GuiUtils;

public class GameTreeViewer
extends JDialog {
    private static final long serialVersionUID = 0L;
    private final GameTreePanel m_panel;
    private final JScrollPane m_scrollPane;
    private final Listener m_listener;

    public GameTreeViewer(Frame frame, Listener listener, boolean bl) {
        super(frame, "Tree");
        Container container = this.getContentPane();
        this.m_listener = listener;
        this.m_panel = new GameTreePanel(this, listener, bl, 0, 1);
        this.m_scrollPane = new JScrollPane(this.m_panel, 22, 32);
        GuiUtils.removeKeyBinding(this.m_scrollPane, "control END");
        KeyAdapter keyAdapter = new KeyAdapter(){
            private final int m_shortcut = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

            public void keyReleased(KeyEvent keyEvent) {
                boolean bl;
                int n = keyEvent.getKeyCode();
                int n2 = keyEvent.getModifiers();
                if ((n2 & this.m_shortcut) == 0) {
                    if (n == 36) {
                        GameTreeViewer.this.scrollToCurrent();
                    }
                    return;
                }
                boolean bl2 = bl = (n2 & 1) != 0;
                if (n == 10 && !bl) {
                    GameTreeViewer.this.m_panel.showPopup();
                } else if (n == 37 && !bl) {
                    GameTreeViewer.this.m_listener.cbBackward(1);
                } else if (n == 37 && bl) {
                    GameTreeViewer.this.m_listener.cbBackward(10);
                } else if (n == 39 && !bl) {
                    GameTreeViewer.this.m_listener.cbForward(1);
                } else if (n == 39 && bl) {
                    GameTreeViewer.this.m_listener.cbForward(10);
                } else if (n == 40 && !bl) {
                    GameTreeViewer.this.m_listener.cbNextVariation();
                } else if (n == 40 && bl) {
                    GameTreeViewer.this.m_listener.cbNextEarlierVariation();
                } else if (n == 38 && !bl) {
                    GameTreeViewer.this.m_listener.cbPreviousVariation();
                } else if (n == 38 && bl) {
                    GameTreeViewer.this.m_listener.cbPreviousEarlierVariation();
                } else if (n == 36 && !bl) {
                    GameTreeViewer.this.m_listener.cbBeginning();
                } else if (n == 35 && !bl) {
                    GameTreeViewer.this.m_listener.cbEnd();
                }
            }
        };
        this.m_scrollPane.addKeyListener(keyAdapter);
        this.m_panel.setScrollPane(this.m_scrollPane);
        this.m_scrollPane.setFocusable(true);
        this.m_scrollPane.setFocusTraversalKeysEnabled(false);
        JViewport jViewport = this.m_scrollPane.getViewport();
        jViewport.setBackground(GameTreePanel.BACKGROUND);
        container.add((Component)this.m_scrollPane, "Center");
        jViewport.setFocusTraversalKeysEnabled(false);
        this.setFocusTraversalKeysEnabled(false);
        this.m_scrollPane.requestFocusInWindow();
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                GameTreeViewer.this.m_scrollPane.requestFocusInWindow();
            }

            public void windowClosing(WindowEvent windowEvent) {
                GameTreeViewer.this.m_listener.disposeGameTree();
            }
        });
        this.pack();
    }

    public void addNewSingleChild(Node node) {
        this.m_panel.addNewSingleChild(node);
    }

    public void redrawCurrentNode() {
        this.m_panel.redrawCurrentNode();
    }

    public void scrollToCurrent() {
        this.m_panel.scrollToCurrent();
    }

    public void setLabelMode(int n) {
        this.m_panel.setLabelMode(n);
    }

    public void setSizeMode(int n) {
        this.m_panel.setSizeMode(n);
    }

    public void setShowSubtreeSizes(boolean bl) {
        this.m_panel.setShowSubtreeSizes(bl);
    }

    public void update(GameTree gameTree, Node node) {
        Dimension dimension = this.m_scrollPane.getViewport().getSize();
        this.m_panel.update(gameTree, node, dimension.width, dimension.height);
        this.repaint();
    }

    public void update(Node node) {
        Dimension dimension = this.m_scrollPane.getViewport().getSize();
        this.m_panel.update(node, dimension.width, dimension.height);
    }

    public static interface Listener {
        public void cbBackward(int var1);

        public void cbBeginning();

        public void cbEnd();

        public void cbForward(int var1);

        public void cbGotoNode(Node var1);

        public void cbNextEarlierVariation();

        public void cbNextVariation();

        public void cbPreviousEarlierVariation();

        public void cbPreviousVariation();

        public void disposeGameTree();
    }
}

