; loop writing "a5" to serial port at 9600Bps
LIST   P=PIC18F242
#include <p18f242.inc>

	__CONFIG _CONFIG1L, 0xff;
	__CONFIG _CONFIG1H, _HS_OSC_1H;
	__CONFIG _CONFIG2L, _BOR_ON_2L & _PWRT_ON_2L & _BORV_42_2L;
	__CONFIG _CONFIG2H, _WDT_OFF_2H;
	__CONFIG _CONFIG3L, 0xff;
	__CONFIG _CONFIG3H, _CCP2MX_OFF_3H;
	__CONFIG _CONFIG4L, _STVR_ON_4L & _LVP_OFF_4L;
	__CONFIG _CONFIG4H, 0xff;
	__CONFIG _CONFIG5L, 0xff;
	__CONFIG _CONFIG5H, 0xff;
	__CONFIG _CONFIG6L, 0xff;
	__CONFIG _CONFIG6H, 0xff;
	__CONFIG _CONFIG7L, 0xff;
	__CONFIG _CONFIG7H, 0xff;

	__IDLOCS    _IDLOC0, 0x00;
	__IDLOCS    _IDLOC1, 0x01;
	__IDLOCS    _IDLOC2, 0x02;
	__IDLOCS    _IDLOC3, 0x03;
	__IDLOCS    _IDLOC4, 0x04;
	__IDLOCS    _IDLOC5, 0x05;
	__IDLOCS    _IDLOC6, 0x06;
	__IDLOCS    _IDLOC7, 0x07;

	CBLOCK 0x00C
	misc1 : 1               ; misc var 1
	misc2 : 1               ; misc var 2
	misc3 : 1               ; misc var 3
	misc4 : 1               ; misc var 4
	ENDC

	ORG 0x0000
	bra start
	ORG 0x0008 ; interrupt vector;
	goto 0x208 ;
	ORG 0x0018;
	goto 0x218; low priority interrupt vector

start:
	clrf INTCON;
	; setup UART
	bcf TRISC, 6; USART TX
	movlw 0x0f; 
	movwf SPBRG; 9600bs at 10Mhz 
	movlw 0x20;
	movwf TXSTA; setup transit status and control
	movlw 0x90;
	movwf RCSTA; setup receive status and control

loop:
	movlw 'a';
	rcall dotx;
	movlw '5';
	rcall dotx;
	bra loop;
	
dotx
	btfss PIR1, TXIF;
	bra dotx;
	movwf TXREG;
	return;

END
