/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_WIDGETS_ENUMS_H__
#define __SG_WIDGETS_ENUMS_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define SG_DPI 75.0
#define PTS_PT 1.0000000
#define PTS_MM 2.834640000
#define PTS_CM 28.346400000
#define PTS_IN 72.0000000
#define PTS_PIXEL (SG_DPI/PTS_IN)

typedef enum
{
  SG_TYPE_NONE = -1, /* pre 0.7 value ? */
  SG_TYPE_NUMBER,
  SG_TYPE_TEXT,
  SG_TYPE_DATE,
  SG_TYPE_TIME,
} SGcolumntype;

typedef enum
{
  SG_FORMAT_DECIMAL,
  SG_FORMAT_SCIENTIFIC,
} SGcolumnformat;

typedef enum
{
  SG_INTERNAL_INTEGER,
  SG_INTERNAL_DOUBLE,
} SGcolumninternal;

typedef enum 
{
     SG_UNIT_PT,
     SG_UNIT_MM,
     SG_UNIT_CM,
     SG_UNIT_IN,
     SG_UNIT_PIXEL,
     SG_UNIT_PERCENT_OF_PAGE
} SGpageUnit;

typedef enum 
{
     SG_TOOL_NONE,
     SG_TOOL_ARROW,
     SG_TOOL_ZOOM,
     SG_TOOL_POINTER,
     SG_TOOL_MARKERS,
     SG_TOOL_DND_POINT,
     SG_TOOL_LINE,
     SG_TOOL_LINE_ARROW,
     SG_TOOL_RECTANGLE,
     SG_TOOL_ELLIPSE,
     SG_TOOL_TEXT,
} SGtool;

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_WIDGETS_ENUMS_H__ */

