/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_WORKSHEET_WINDOW_H__
#define __SG_WORKSHEET_WINDOW_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>

#define GTK_TYPE_SG_WORKSHEET_WINDOW                  (sg_worksheet_window_get_type ())
#define SG_WORKSHEET_WINDOW(obj)                  (GTK_CHECK_CAST ((obj), GTK_TYPE_SG_WORKSHEET_WINDOW, SGworksheetWindow))
#define SG_WORKSHEET_WINDOW_CLASS(klass)          (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_SG_WORKSHEET_WINDOW, SGworksheetWindowClass))
#define GTK_IS_SG_WORKSHEET_WINDOW(obj)               (GTK_CHECK_TYPE ((obj), GTK_TYPE_SG_WORKSHEET_WINDOW))
#define GTK_IS_SG_WORKSHEET_WINDOW_CLASS(klass)       (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_SG_WORKSHEET_WINDOW))

typedef struct _SGworksheetWindow SGworksheetWindow;
typedef struct _SGworksheetWindowClass SGworksheetWindowClass;

struct _SGworksheetWindow 
{
  GtkWindow window;

  gint x, y, width, height;

  SGworksheet* worksheet;

  GtkWidget *vbox;
  GtkWidget *label;
  GtkWidget *sw;

  GtkWidget *menu;
};

struct _SGworksheetWindowClass
{
  GtkWindowClass parent_class;
};

GtkType 		sg_worksheet_window_get_type	(void); 
SGworksheetWindow 	*sg_worksheet_window_new	(SGworksheet *worksheet); 

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_WORKSHEET_WINDOW_H__ */

