/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; version 
 * 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#ifndef _SML_MANAGER_H
#define _SML_MANAGER_H

typedef enum {
	SML_MANAGER_CONNECT_DONE,
	SML_MANAGER_DISCONNECT_DONE,
	SML_MANAGER_TRANSPORT_ERROR,
	SML_MANAGER_SESSION_NEW,
	SML_MANAGER_SESSION_FINAL,
	SML_MANAGER_SESSION_END,
	SML_MANAGER_SESSION_FLUSH,
	SML_MANAGER_SESSION_WARNING,
	SML_MANAGER_SESSION_ERROR
} SmlManagerEventType;

typedef void (* SmlManagerEventCb) (SmlManager *manager, SmlManagerEventType type, SmlSession *session, SmlError *error, void *userdata);
typedef void (* SmlCommandCb) (SmlSession *session, SmlCommand *cmd, void *userdata);
typedef void (* SmlHeaderCb) (SmlSession *session, SmlHeader *header, SmlCred *cred, void *userdata);
typedef void (* SmlStatusReplyCb) (SmlSession *session, SmlStatus *status, void *userdata);

SmlManager *smlManagerNew(SmlTransport *tsp, SmlError **error);
void smlManagerFree(SmlManager *manager);
SmlBool smlManagerReceive(SmlManager *manager, SmlError **error);

void smlManagerSetEventCallback(SmlManager *manager, SmlManagerEventCb callback, void *userdata);
SmlSession *smlManagerSessionFind(SmlManager *manager, const char *sessionID);
SmlBool smlManagerSessionAdd(SmlManager *manager, SmlSession *session, SmlLink *link, SmlError **error);
void smlManagerSessionRemove(SmlManager *manager, SmlSession *session);

SmlBool smlManagerObjectRegister(SmlManager *manager, SmlCommandType type, SmlSession *session, SmlLocation *location, SmlLocation *source, const char *contentType, SmlCommandCb callback, SmlCommandCb childCallback, void *userdata, SmlError **error);
void smlManagerRegisterHeaderHandler(SmlManager *manager, SmlHeaderCb callback, SmlStatusReplyCb statuscb, void *userdata);

void smlManagerObjectFree(SmlObject *object);
SmlObject *smlManagerObjectFind(SmlManager *manager, SmlSession *session, SmlCommand *cmd);
SmlBool smlManagerDispatchChildCommand(SmlManager *manager, SmlSession *session, SmlCommand *parent, SmlCommand *cmd, SmlError **error);
SmlBool smlManagerDispatchHeader(SmlManager *manager, SmlSession *session, SmlHeader *header, SmlCred *cred, SmlError **error);
SmlBool smlManagerDispatchCommand(SmlManager *manager, SmlSession *session, SmlCommand *cmd, SmlError **error);

SmlBool smlManagerStart(SmlManager *manager, SmlError **error);
void smlManagerStop(SmlManager *manager);
void smlManagerRun(SmlManager *manager);
void smlManagerQuit(SmlManager *manager);

void smlManagerDispatch(SmlManager *manager);
SmlBool smlManagerCheck(SmlManager *manager);

#endif //_SML_MANAGER_H
