import{Annotation,StateEffect,EditorSelection,codePointAt,codePointSize,fromCodePoint,Facet,combineConfig,StateField,Prec,Text,Transaction,MapMode,RangeValue,RangeSet,CharCategory}from"@codemirror/state";import{Direction,logException,showTooltip,EditorView,ViewPlugin,getTooltip,Decoration,WidgetType,keymap}from"@codemirror/view";import{syntaxTree,indentUnit}from"@codemirror/language";class CompletionContext{constructor(e,t,o,i){this.state=e,this.pos=t,this.explicit=o,this.view=i,this.abortListeners=[],this.abortOnDocChange=!1}tokenBefore(e){let t=syntaxTree(this.state).resolveInner(this.pos,-1);for(;t&&e.indexOf(t.name)<0;)t=t.parent;return t?{from:t.from,to:this.pos,text:this.state.sliceDoc(t.from,this.pos),type:t.type}:null}matchBefore(e){let t=this.state.doc.lineAt(this.pos),o=Math.max(t.from,this.pos-250),i=t.text.slice(o-t.from,this.pos-t.from),n=i.search(ensureAnchor(e,!1));return n<0?null:{from:o+n,to:this.pos,text:i.slice(n)}}get aborted(){return null==this.abortListeners}addEventListener(e,t,o){"abort"==e&&this.abortListeners&&(this.abortListeners.push(t),o&&o.onDocChange&&(this.abortOnDocChange=!0))}}function toSet(e){let t=Object.keys(e).join(""),o=/\w/.test(t);return o&&(t=t.replace(/\w/g,"")),`[${o?"\\w":""}${t.replace(/[^\w\s]/g,"\\$&")}]`}function prefixMatch(e){let t=Object.create(null),o=Object.create(null);for(let{label:i}of e){t[i[0]]=!0;for(let e=1;e<i.length;e++)o[i[e]]=!0}let i=toSet(t)+toSet(o)+"*$";return[new RegExp("^"+i),new RegExp(i)]}function completeFromList(e){let t=e.map((e=>"string"==typeof e?{label:e}:e)),[o,i]=t.every((e=>/^\w+$/.test(e.label)))?[/\w*$/,/\w+$/]:prefixMatch(t);return e=>{let n=e.matchBefore(i);return n||e.explicit?{from:n?n.from:e.pos,options:t,validFor:o}:null}}function ifIn(e,t){return o=>{for(let i=syntaxTree(o.state).resolveInner(o.pos,-1);i;i=i.parent){if(e.indexOf(i.name)>-1)return t(o);if(i.type.isTop)break}return null}}function ifNotIn(e,t){return o=>{for(let t=syntaxTree(o.state).resolveInner(o.pos,-1);t;t=t.parent){if(e.indexOf(t.name)>-1)return null;if(t.type.isTop)break}return t(o)}}class Option{constructor(e,t,o,i){this.completion=e,this.source=t,this.match=o,this.score=i}}function cur(e){return e.selection.main.from}function ensureAnchor(e,t){var o;let{source:i}=e,n=t&&"^"!=i[0],s="$"!=i[i.length-1];return n||s?new RegExp(`${n?"^":""}(?:${i})${s?"$":""}`,null!==(o=e.flags)&&void 0!==o?o:e.ignoreCase?"i":""):e}const pickedCompletion=Annotation.define();function insertCompletionText(e,t,o,i){let{main:n}=e.selection,s=o-n.from,l=i-n.from;return Object.assign(Object.assign({},e.changeByRange((r=>r!=n&&o!=i&&e.sliceDoc(r.from+s,r.from+l)!=e.sliceDoc(o,i)?{range:r}:{changes:{from:r.from+s,to:i==n.from?r.to:r.from+l,insert:t},range:EditorSelection.cursor(r.from+s+t.length)}))),{scrollIntoView:!0,userEvent:"input.complete"})}const SourceCache=new WeakMap;function asSource(e){if(!Array.isArray(e))return e;let t=SourceCache.get(e);return t||SourceCache.set(e,t=completeFromList(e)),t}const startCompletionEffect=StateEffect.define(),closeCompletionEffect=StateEffect.define();class FuzzyMatcher{constructor(e){this.pattern=e,this.chars=[],this.folded=[],this.any=[],this.precise=[],this.byWord=[],this.score=0,this.matched=[];for(let t=0;t<e.length;){let o=codePointAt(e,t),i=codePointSize(o);this.chars.push(o);let n=e.slice(t,t+i),s=n.toUpperCase();this.folded.push(codePointAt(s==n?n.toLowerCase():s,0)),t+=i}this.astral=e.length!=this.chars.length}ret(e,t){return this.score=e,this.matched=t,this}match(e){if(0==this.pattern.length)return this.ret(-100,[]);if(e.length<this.pattern.length)return null;let{chars:t,folded:o,any:i,precise:n,byWord:s}=this;if(1==t.length){let i=codePointAt(e,0),n=codePointSize(i),s=n==e.length?0:-100;if(i==t[0]);else{if(i!=o[0])return null;s+=-200}return this.ret(s,[0,n])}let l=e.indexOf(this.pattern);if(0==l)return this.ret(e.length==this.pattern.length?0:-100,[0,this.pattern.length]);let r=t.length,a=0;if(l<0){for(let n=0,s=Math.min(e.length,200);n<s&&a<r;){let s=codePointAt(e,n);s!=t[a]&&s!=o[a]||(i[a++]=n),n+=codePointSize(s)}if(a<r)return null}let c=0,p=0,d=!1,f=0,h=-1,u=-1,m=/[a-z]/.test(e),g=!0;for(let i=0,a=Math.min(e.length,200),v=0;i<a&&p<r;){let a=codePointAt(e,i);l<0&&(c<r&&a==t[c]&&(n[c++]=i),f<r&&(a==t[f]||a==o[f]?(0==f&&(h=i),u=i+1,f++):f=0));let C,S=a<255?a>=48&&a<=57||a>=97&&a<=122?2:a>=65&&a<=90?1:0:(C=fromCodePoint(a))!=C.toLowerCase()?1:C!=C.toUpperCase()?2:0;(!i||1==S&&m||0==v&&0!=S)&&(t[p]==a||o[p]==a&&(d=!0)?s[p++]=i:s.length&&(g=!1)),v=S,i+=codePointSize(a)}return p==r&&0==s[0]&&g?this.result((d?-200:0)-100,s,e):f==r&&0==h?this.ret(-200-e.length+(u==e.length?0:-100),[0,u]):l>-1?this.ret(-700-e.length,[l,l+this.pattern.length]):f==r?this.ret(-900-e.length,[h,u]):p==r?this.result((d?-200:0)-100-700+(g?0:-1100),s,e):2==t.length?null:this.result((i[0]?-700:0)-200-1100,i,e)}result(e,t,o){let i=[],n=0;for(let e of t){let t=e+(this.astral?codePointSize(codePointAt(o,e)):1);n&&i[n-1]==e?i[n-1]=t:(i[n++]=e,i[n++]=t)}return this.ret(e-o.length,i)}}class StrictMatcher{constructor(e){this.pattern=e,this.matched=[],this.score=0,this.folded=e.toLowerCase()}match(e){if(e.length<this.pattern.length)return null;let t=e.slice(0,this.pattern.length),o=t==this.pattern?0:t.toLowerCase()==this.folded?-200:null;return null==o?null:(this.matched=[0,t.length],this.score=o+(e.length==this.pattern.length?0:-100),this)}}const completionConfig=Facet.define({combine:e=>combineConfig(e,{activateOnTyping:!0,activateOnCompletion:()=>!1,activateOnTypingDelay:100,selectOnOpen:!0,override:null,closeOnBlur:!0,maxRenderedOptions:100,defaultKeymap:!0,tooltipClass:()=>"",optionClass:()=>"",aboveCursor:!1,icons:!0,addToOptions:[],positionInfo:defaultPositionInfo,filterStrict:!1,compareCompletions:(e,t)=>e.label.localeCompare(t.label),interactionDelay:75,updateSyncTime:100},{defaultKeymap:(e,t)=>e&&t,closeOnBlur:(e,t)=>e&&t,icons:(e,t)=>e&&t,tooltipClass:(e,t)=>o=>joinClass(e(o),t(o)),optionClass:(e,t)=>o=>joinClass(e(o),t(o)),addToOptions:(e,t)=>e.concat(t),filterStrict:(e,t)=>e||t})});function joinClass(e,t){return e?t?e+" "+t:e:t}function defaultPositionInfo(e,t,o,i,n,s){let l,r,a=e.textDirection==Direction.RTL,c=a,p=!1,d="top",f=t.left-n.left,h=n.right-t.right,u=i.right-i.left,m=i.bottom-i.top;if(c&&f<Math.min(u,h)?c=!1:!c&&h<Math.min(u,f)&&(c=!0),u<=(c?f:h))l=Math.max(n.top,Math.min(o.top,n.bottom-m))-t.top,r=Math.min(400,c?f:h);else{p=!0,r=Math.min(400,(a?t.right:n.right-t.left)-30);let e=n.bottom-t.bottom;e>=m||e>t.top?l=o.bottom-t.top:(d="bottom",l=t.bottom-o.top)}return{style:`${d}: ${l/((t.bottom-t.top)/s.offsetHeight)}px; max-width: ${r/((t.right-t.left)/s.offsetWidth)}px`,class:"cm-completionInfo-"+(p?a?"left-narrow":"right-narrow":c?"left":"right")}}function optionContent(e){let t=e.addToOptions.slice();return e.icons&&t.push({render(e){let t=document.createElement("div");return t.classList.add("cm-completionIcon"),e.type&&t.classList.add(...e.type.split(/\s+/g).map((e=>"cm-completionIcon-"+e))),t.setAttribute("aria-hidden","true"),t},position:20}),t.push({render(e,t,o,i){let n=document.createElement("span");n.className="cm-completionLabel";let s=e.displayLabel||e.label,l=0;for(let e=0;e<i.length;){let t=i[e++],o=i[e++];t>l&&n.appendChild(document.createTextNode(s.slice(l,t)));let r=n.appendChild(document.createElement("span"));r.appendChild(document.createTextNode(s.slice(t,o))),r.className="cm-completionMatchedText",l=o}return l<s.length&&n.appendChild(document.createTextNode(s.slice(l))),n},position:50},{render(e){if(!e.detail)return null;let t=document.createElement("span");return t.className="cm-completionDetail",t.textContent=e.detail,t},position:80}),t.sort(((e,t)=>e.position-t.position)).map((e=>e.render))}function rangeAroundSelected(e,t,o){if(e<=o)return{from:0,to:e};if(t<0&&(t=0),t<=e>>1){let e=Math.floor(t/o);return{from:e*o,to:(e+1)*o}}let i=Math.floor((e-t)/o);return{from:e-(i+1)*o,to:e-i*o}}class CompletionTooltip{constructor(e,t,o){this.view=e,this.stateField=t,this.applyCompletion=o,this.info=null,this.infoDestroy=null,this.placeInfoReq={read:()=>this.measureInfo(),write:e=>this.placeInfo(e),key:this},this.space=null,this.currentClass="";let i=e.state.field(t),{options:n,selected:s}=i.open,l=e.state.facet(completionConfig);this.optionContent=optionContent(l),this.optionClass=l.optionClass,this.tooltipClass=l.tooltipClass,this.range=rangeAroundSelected(n.length,s,l.maxRenderedOptions),this.dom=document.createElement("div"),this.dom.className="cm-tooltip-autocomplete",this.updateTooltipClass(e.state),this.dom.addEventListener("mousedown",(o=>{let{options:i}=e.state.field(t).open;for(let t,n=o.target;n&&n!=this.dom;n=n.parentNode)if("LI"==n.nodeName&&(t=/-(\d+)$/.exec(n.id))&&+t[1]<i.length)return this.applyCompletion(e,i[+t[1]]),void o.preventDefault()})),this.dom.addEventListener("focusout",(t=>{let o=e.state.field(this.stateField,!1);o&&o.tooltip&&e.state.facet(completionConfig).closeOnBlur&&t.relatedTarget!=e.contentDOM&&e.dispatch({effects:closeCompletionEffect.of(null)})})),this.showOptions(n,i.id)}mount(){this.updateSel()}showOptions(e,t){this.list&&this.list.remove(),this.list=this.dom.appendChild(this.createListBox(e,t,this.range)),this.list.addEventListener("scroll",(()=>{this.info&&this.view.requestMeasure(this.placeInfoReq)}))}update(e){var t;let o=e.state.field(this.stateField),i=e.startState.field(this.stateField);if(this.updateTooltipClass(e.state),o!=i){let{options:n,selected:s,disabled:l}=o.open;i.open&&i.open.options==n||(this.range=rangeAroundSelected(n.length,s,e.state.facet(completionConfig).maxRenderedOptions),this.showOptions(n,o.id)),this.updateSel(),l!=(null===(t=i.open)||void 0===t?void 0:t.disabled)&&this.dom.classList.toggle("cm-tooltip-autocomplete-disabled",!!l)}}updateTooltipClass(e){let t=this.tooltipClass(e);if(t!=this.currentClass){for(let e of this.currentClass.split(" "))e&&this.dom.classList.remove(e);for(let e of t.split(" "))e&&this.dom.classList.add(e);this.currentClass=t}}positioned(e){this.space=e,this.info&&this.view.requestMeasure(this.placeInfoReq)}updateSel(){let e=this.view.state.field(this.stateField),t=e.open;if((t.selected>-1&&t.selected<this.range.from||t.selected>=this.range.to)&&(this.range=rangeAroundSelected(t.options.length,t.selected,this.view.state.facet(completionConfig).maxRenderedOptions),this.showOptions(t.options,e.id)),this.updateSelectedOption(t.selected)){this.destroyInfo();let{completion:o}=t.options[t.selected],{info:i}=o;if(!i)return;let n="string"==typeof i?document.createTextNode(i):i(o);if(!n)return;"then"in n?n.then((t=>{t&&this.view.state.field(this.stateField,!1)==e&&this.addInfoPane(t,o)})).catch((e=>logException(this.view.state,e,"completion info"))):this.addInfoPane(n,o)}}addInfoPane(e,t){this.destroyInfo();let o=this.info=document.createElement("div");if(o.className="cm-tooltip cm-completionInfo",null!=e.nodeType)o.appendChild(e),this.infoDestroy=null;else{let{dom:t,destroy:i}=e;o.appendChild(t),this.infoDestroy=i||null}this.dom.appendChild(o),this.view.requestMeasure(this.placeInfoReq)}updateSelectedOption(e){let t=null;for(let o=this.list.firstChild,i=this.range.from;o;o=o.nextSibling,i++)"LI"==o.nodeName&&o.id?i==e?o.hasAttribute("aria-selected")||(o.setAttribute("aria-selected","true"),t=o):o.hasAttribute("aria-selected")&&o.removeAttribute("aria-selected"):i--;return t&&scrollIntoView(this.list,t),t}measureInfo(){let e=this.dom.querySelector("[aria-selected]");if(!e||!this.info)return null;let t=this.dom.getBoundingClientRect(),o=this.info.getBoundingClientRect(),i=e.getBoundingClientRect(),n=this.space;if(!n){let e=this.dom.ownerDocument.defaultView||window;n={left:0,top:0,right:e.innerWidth,bottom:e.innerHeight}}return i.top>Math.min(n.bottom,t.bottom)-10||i.bottom<Math.max(n.top,t.top)+10?null:this.view.state.facet(completionConfig).positionInfo(this.view,t,i,o,n,this.dom)}placeInfo(e){this.info&&(e?(e.style&&(this.info.style.cssText=e.style),this.info.className="cm-tooltip cm-completionInfo "+(e.class||"")):this.info.style.cssText="top: -1e6px")}createListBox(e,t,o){const i=document.createElement("ul");i.id=t,i.setAttribute("role","listbox"),i.setAttribute("aria-expanded","true"),i.setAttribute("aria-label",this.view.state.phrase("Completions"));let n=null;for(let s=o.from;s<o.to;s++){let{completion:l,match:r}=e[s],{section:a}=l;if(a){let e="string"==typeof a?a:a.name;if(e!=n&&(s>o.from||0==o.from))if(n=e,"string"!=typeof a&&a.header)i.appendChild(a.header(a));else{i.appendChild(document.createElement("completion-section")).textContent=e}}const c=i.appendChild(document.createElement("li"));c.id=t+"-"+s,c.setAttribute("role","option");let p=this.optionClass(l);p&&(c.className=p);for(let e of this.optionContent){let t=e(l,this.view.state,this.view,r);t&&c.appendChild(t)}}return o.from&&i.classList.add("cm-completionListIncompleteTop"),o.to<e.length&&i.classList.add("cm-completionListIncompleteBottom"),i}destroyInfo(){this.info&&(this.infoDestroy&&this.infoDestroy(),this.info.remove(),this.info=null)}destroy(){this.destroyInfo()}}function completionTooltip(e,t){return o=>new CompletionTooltip(o,e,t)}function scrollIntoView(e,t){let o=e.getBoundingClientRect(),i=t.getBoundingClientRect(),n=o.height/e.offsetHeight;i.top<o.top?e.scrollTop-=(o.top-i.top)/n:i.bottom>o.bottom&&(e.scrollTop+=(i.bottom-o.bottom)/n)}function score(e){return 100*(e.boost||0)+(e.apply?10:0)+(e.info?5:0)+(e.type?1:0)}function sortOptions(e,t){let o=[],i=null,n=e=>{o.push(e);let{section:t}=e.completion;if(t){i||(i=[]);let e="string"==typeof t?t:t.name;i.some((t=>t.name==e))||i.push("string"==typeof t?{name:e}:t)}},s=t.facet(completionConfig);for(let i of e)if(i.hasResult()){let e=i.result.getMatch;if(!1===i.result.filter)for(let t of i.result.options)n(new Option(t,i.source,e?e(t):[],1e9-o.length));else{let o,l=t.sliceDoc(i.from,i.to),r=s.filterStrict?new StrictMatcher(l):new FuzzyMatcher(l);for(let t of i.result.options)if(o=r.match(t.label)){let s=t.displayLabel?e?e(t,o.matched):[]:o.matched;n(new Option(t,i.source,s,o.score+(t.boost||0)))}}}if(i){let e=Object.create(null),t=0,n=(e,t)=>{var o,i;return(null!==(o=e.rank)&&void 0!==o?o:1e9)-(null!==(i=t.rank)&&void 0!==i?i:1e9)||(e.name<t.name?-1:1)};for(let o of i.sort(n))t-=1e5,e[o.name]=t;for(let t of o){let{section:o}=t.completion;o&&(t.score+=e["string"==typeof o?o:o.name])}}let l=[],r=null,a=s.compareCompletions;for(let e of o.sort(((e,t)=>t.score-e.score||a(e.completion,t.completion)))){let t=e.completion;!r||r.label!=t.label||r.detail!=t.detail||null!=r.type&&null!=t.type&&r.type!=t.type||r.apply!=t.apply||r.boost!=t.boost?l.push(e):score(e.completion)>score(r)&&(l[l.length-1]=e),r=e.completion}return l}class CompletionDialog{constructor(e,t,o,i,n,s){this.options=e,this.attrs=t,this.tooltip=o,this.timestamp=i,this.selected=n,this.disabled=s}setSelected(e,t){return e==this.selected||e>=this.options.length?this:new CompletionDialog(this.options,makeAttrs(t,e),this.tooltip,this.timestamp,e,this.disabled)}static build(e,t,o,i,n){let s=sortOptions(e,t);if(!s.length)return i&&e.some((e=>1==e.state))?new CompletionDialog(i.options,i.attrs,i.tooltip,i.timestamp,i.selected,!0):null;let l=t.facet(completionConfig).selectOnOpen?0:-1;if(i&&i.selected!=l&&-1!=i.selected){let e=i.options[i.selected].completion;for(let t=0;t<s.length;t++)if(s[t].completion==e){l=t;break}}return new CompletionDialog(s,makeAttrs(o,l),{pos:e.reduce(((e,t)=>t.hasResult()?Math.min(e,t.from):e),1e8),create:createTooltip,above:n.aboveCursor},i?i.timestamp:Date.now(),l,!1)}map(e){return new CompletionDialog(this.options,this.attrs,Object.assign(Object.assign({},this.tooltip),{pos:e.mapPos(this.tooltip.pos)}),this.timestamp,this.selected,this.disabled)}}class CompletionState{constructor(e,t,o){this.active=e,this.id=t,this.open=o}static start(){return new CompletionState(none,"cm-ac-"+Math.floor(2e6*Math.random()).toString(36),null)}update(e){let{state:t}=e,o=t.facet(completionConfig),i=(o.override||t.languageDataAt("autocomplete",cur(t)).map(asSource)).map((t=>(this.active.find((e=>e.source==t))||new ActiveSource(t,this.active.some((e=>0!=e.state))?1:0)).update(e,o)));i.length==this.active.length&&i.every(((e,t)=>e==this.active[t]))&&(i=this.active);let n=this.open;n&&e.docChanged&&(n=n.map(e.changes)),e.selection||i.some((t=>t.hasResult()&&e.changes.touchesRange(t.from,t.to)))||!sameResults(i,this.active)?n=CompletionDialog.build(i,t,this.id,n,o):n&&n.disabled&&!i.some((e=>1==e.state))&&(n=null),!n&&i.every((e=>1!=e.state))&&i.some((e=>e.hasResult()))&&(i=i.map((e=>e.hasResult()?new ActiveSource(e.source,0):e)));for(let t of e.effects)t.is(setSelectedEffect)&&(n=n&&n.setSelected(t.value,this.id));return i==this.active&&n==this.open?this:new CompletionState(i,this.id,n)}get tooltip(){return this.open?this.open.tooltip:null}get attrs(){return this.open?this.open.attrs:this.active.length?baseAttrs:noAttrs}}function sameResults(e,t){if(e==t)return!0;for(let o=0,i=0;;){for(;o<e.length&&!e[o].hasResult;)o++;for(;i<t.length&&!t[i].hasResult;)i++;let n=o==e.length,s=i==t.length;if(n||s)return n==s;if(e[o++].result!=t[i++].result)return!1}}const baseAttrs={"aria-autocomplete":"list"},noAttrs={};function makeAttrs(e,t){let o={"aria-autocomplete":"list","aria-haspopup":"listbox","aria-controls":e};return t>-1&&(o["aria-activedescendant"]=e+"-"+t),o}const none=[];function getUpdateType(e,t){if(e.isUserEvent("input.complete")){let o=e.annotation(pickedCompletion);if(o&&t.activateOnCompletion(o))return 12}let o=e.isUserEvent("input.type");return o&&t.activateOnTyping?5:o?1:e.isUserEvent("delete.backward")?2:e.selection?8:e.docChanged?16:0}class ActiveSource{constructor(e,t,o=-1){this.source=e,this.state=t,this.explicitPos=o}hasResult(){return!1}update(e,t){let o=getUpdateType(e,t),i=this;(8&o||16&o&&this.touches(e))&&(i=new ActiveSource(i.source,0)),4&o&&0==i.state&&(i=new ActiveSource(this.source,1)),i=i.updateFor(e,o);for(let t of e.effects)if(t.is(startCompletionEffect))i=new ActiveSource(i.source,1,t.value?cur(e.state):-1);else if(t.is(closeCompletionEffect))i=new ActiveSource(i.source,0);else if(t.is(setActiveEffect))for(let e of t.value)e.source==i.source&&(i=e);return i}updateFor(e,t){return this.map(e.changes)}map(e){return e.empty||this.explicitPos<0?this:new ActiveSource(this.source,this.state,e.mapPos(this.explicitPos))}touches(e){return e.changes.touchesRange(cur(e.state))}}class ActiveResult extends ActiveSource{constructor(e,t,o,i,n){super(e,2,t),this.result=o,this.from=i,this.to=n}hasResult(){return!0}updateFor(e,t){var o;if(!(3&t))return this.map(e.changes);let i=this.result;i.map&&!e.changes.empty&&(i=i.map(i,e.changes));let n=e.changes.mapPos(this.from),s=e.changes.mapPos(this.to,1),l=cur(e.state);if((this.explicitPos<0?l<=n:l<this.from)||l>s||!i||2&t&&cur(e.startState)==this.from)return new ActiveSource(this.source,4&t?1:0);let r=this.explicitPos<0?-1:e.changes.mapPos(this.explicitPos);return checkValid(i.validFor,e.state,n,s)?new ActiveResult(this.source,r,i,n,s):i.update&&(i=i.update(i,n,s,new CompletionContext(e.state,l,r>=0)))?new ActiveResult(this.source,r,i,i.from,null!==(o=i.to)&&void 0!==o?o:cur(e.state)):new ActiveSource(this.source,1,r)}map(e){if(e.empty)return this;return(this.result.map?this.result.map(this.result,e):this.result)?new ActiveResult(this.source,this.explicitPos<0?-1:e.mapPos(this.explicitPos),this.result,e.mapPos(this.from),e.mapPos(this.to,1)):new ActiveSource(this.source,0)}touches(e){return e.changes.touchesRange(this.from,this.to)}}function checkValid(e,t,o,i){if(!e)return!1;let n=t.sliceDoc(o,i);return"function"==typeof e?e(n,o,i,t):ensureAnchor(e,!0).test(n)}const setActiveEffect=StateEffect.define({map:(e,t)=>e.map((e=>e.map(t)))}),setSelectedEffect=StateEffect.define(),completionState=StateField.define({create:()=>CompletionState.start(),update:(e,t)=>e.update(t),provide:e=>[showTooltip.from(e,(e=>e.tooltip)),EditorView.contentAttributes.from(e,(e=>e.attrs))]});function applyCompletion(e,t){const o=t.completion.apply||t.completion.label;let i=e.state.field(completionState).active.find((e=>e.source==t.source));return i instanceof ActiveResult&&("string"==typeof o?e.dispatch(Object.assign(Object.assign({},insertCompletionText(e.state,o,i.from,i.to)),{annotations:pickedCompletion.of(t.completion)})):o(e,t.completion,i.from,i.to),!0)}const createTooltip=completionTooltip(completionState,applyCompletion);function moveCompletionSelection(e,t="option"){return o=>{let i=o.state.field(completionState,!1);if(!i||!i.open||i.open.disabled||Date.now()-i.open.timestamp<o.state.facet(completionConfig).interactionDelay)return!1;let n,s=1;"page"==t&&(n=getTooltip(o,i.open.tooltip))&&(s=Math.max(2,Math.floor(n.dom.offsetHeight/n.dom.querySelector("li").offsetHeight)-1));let{length:l}=i.open.options,r=i.open.selected>-1?i.open.selected+s*(e?1:-1):e?0:l-1;return r<0?r="page"==t?0:l-1:r>=l&&(r="page"==t?l-1:0),o.dispatch({effects:setSelectedEffect.of(r)}),!0}}const acceptCompletion=e=>{let t=e.state.field(completionState,!1);return!(e.state.readOnly||!t||!t.open||t.open.selected<0||t.open.disabled||Date.now()-t.open.timestamp<e.state.facet(completionConfig).interactionDelay)&&applyCompletion(e,t.open.options[t.open.selected])},startCompletion=e=>!!e.state.field(completionState,!1)&&(e.dispatch({effects:startCompletionEffect.of(!0)}),!0),closeCompletion=e=>{let t=e.state.field(completionState,!1);return!(!t||!t.active.some((e=>0!=e.state)))&&(e.dispatch({effects:closeCompletionEffect.of(null)}),!0)};class RunningQuery{constructor(e,t){this.active=e,this.context=t,this.time=Date.now(),this.updates=[],this.done=void 0}}const MaxUpdateCount=50,MinAbortTime=1e3,completionPlugin=ViewPlugin.fromClass(class{constructor(e){this.view=e,this.debounceUpdate=-1,this.running=[],this.debounceAccept=-1,this.pendingStart=!1,this.composing=0;for(let t of e.state.field(completionState).active)1==t.state&&this.startQuery(t)}update(e){let t=e.state.field(completionState),o=e.state.facet(completionConfig);if(!e.selectionSet&&!e.docChanged&&e.startState.field(completionState)==t)return;let i=e.transactions.some((e=>{let t=getUpdateType(e,o);return 8&t||(e.selection||e.docChanged)&&!(3&t)}));for(let t=0;t<this.running.length;t++){let o=this.running[t];if(i||o.context.abortOnDocChange&&e.docChanged||o.updates.length+e.transactions.length>50&&Date.now()-o.time>1e3){for(let e of o.context.abortListeners)try{e()}catch(e){logException(this.view.state,e)}o.context.abortListeners=null,this.running.splice(t--,1)}else o.updates.push(...e.transactions)}this.debounceUpdate>-1&&clearTimeout(this.debounceUpdate),e.transactions.some((e=>e.effects.some((e=>e.is(startCompletionEffect)))))&&(this.pendingStart=!0);let n=this.pendingStart?50:o.activateOnTypingDelay;if(this.debounceUpdate=t.active.some((e=>1==e.state&&!this.running.some((t=>t.active.source==e.source))))?setTimeout((()=>this.startUpdate()),n):-1,0!=this.composing)for(let t of e.transactions)t.isUserEvent("input.type")?this.composing=2:2==this.composing&&t.selection&&(this.composing=3)}startUpdate(){this.debounceUpdate=-1,this.pendingStart=!1;let{state:e}=this.view,t=e.field(completionState);for(let e of t.active)1!=e.state||this.running.some((t=>t.active.source==e.source))||this.startQuery(e)}startQuery(e){let{state:t}=this.view,o=cur(t),i=new CompletionContext(t,o,e.explicitPos==o,this.view),n=new RunningQuery(e,i);this.running.push(n),Promise.resolve(e.source(i)).then((e=>{n.context.aborted||(n.done=e||null,this.scheduleAccept())}),(e=>{this.view.dispatch({effects:closeCompletionEffect.of(null)}),logException(this.view.state,e)}))}scheduleAccept(){this.running.every((e=>void 0!==e.done))?this.accept():this.debounceAccept<0&&(this.debounceAccept=setTimeout((()=>this.accept()),this.view.state.facet(completionConfig).updateSyncTime))}accept(){var e;this.debounceAccept>-1&&clearTimeout(this.debounceAccept),this.debounceAccept=-1;let t=[],o=this.view.state.facet(completionConfig);for(let i=0;i<this.running.length;i++){let n=this.running[i];if(void 0===n.done)continue;if(this.running.splice(i--,1),n.done){let i=new ActiveResult(n.active.source,n.active.explicitPos,n.done,n.done.from,null!==(e=n.done.to)&&void 0!==e?e:cur(n.updates.length?n.updates[0].startState:this.view.state));for(let e of n.updates)i=i.update(e,o);if(i.hasResult()){t.push(i);continue}}let s=this.view.state.field(completionState).active.find((e=>e.source==n.active.source));if(s&&1==s.state)if(null==n.done){let e=new ActiveSource(n.active.source,0);for(let t of n.updates)e=e.update(t,o);1!=e.state&&t.push(e)}else this.startQuery(s)}t.length&&this.view.dispatch({effects:setActiveEffect.of(t)})}},{eventHandlers:{blur(e){let t=this.view.state.field(completionState,!1);if(t&&t.tooltip&&this.view.state.facet(completionConfig).closeOnBlur){let o=t.open&&getTooltip(this.view,t.open.tooltip);o&&o.dom.contains(e.relatedTarget)||setTimeout((()=>this.view.dispatch({effects:closeCompletionEffect.of(null)})),10)}},compositionstart(){this.composing=1},compositionend(){3==this.composing&&setTimeout((()=>this.view.dispatch({effects:startCompletionEffect.of(!1)})),20),this.composing=0}}}),windows="object"==typeof navigator&&/Win/.test(navigator.platform),commitCharacters=Prec.highest(EditorView.domEventHandlers({keydown(e,t){let o=t.state.field(completionState,!1);if(!o||!o.open||o.open.disabled||o.open.selected<0||e.key.length>1||e.ctrlKey&&(!windows||!e.altKey)||e.metaKey)return!1;let i=o.open.options[o.open.selected],n=o.active.find((e=>e.source==i.source)),s=i.completion.commitCharacters||n.result.commitCharacters;return s&&s.indexOf(e.key)>-1&&applyCompletion(t,i),!1}})),baseTheme=EditorView.baseTheme({".cm-tooltip.cm-tooltip-autocomplete":{"& > ul":{fontFamily:"monospace",whiteSpace:"nowrap",overflow:"hidden auto",maxWidth_fallback:"700px",maxWidth:"min(700px, 95vw)",minWidth:"250px",maxHeight:"10em",height:"100%",listStyle:"none",margin:0,padding:0,"& > li, & > completion-section":{padding:"1px 3px",lineHeight:1.2},"& > li":{overflowX:"hidden",textOverflow:"ellipsis",cursor:"pointer"},"& > completion-section":{display:"list-item",borderBottom:"1px solid silver",paddingLeft:"0.5em",opacity:.7}}},"&light .cm-tooltip-autocomplete ul li[aria-selected]":{background:"#17c",color:"white"},"&light .cm-tooltip-autocomplete-disabled ul li[aria-selected]":{background:"#777"},"&dark .cm-tooltip-autocomplete ul li[aria-selected]":{background:"#347",color:"white"},"&dark .cm-tooltip-autocomplete-disabled ul li[aria-selected]":{background:"#444"},".cm-completionListIncompleteTop:before, .cm-completionListIncompleteBottom:after":{content:'"···"',opacity:.5,display:"block",textAlign:"center"},".cm-tooltip.cm-completionInfo":{position:"absolute",padding:"3px 9px",width:"max-content",maxWidth:"400px",boxSizing:"border-box",whiteSpace:"pre-line"},".cm-completionInfo.cm-completionInfo-left":{right:"100%"},".cm-completionInfo.cm-completionInfo-right":{left:"100%"},".cm-completionInfo.cm-completionInfo-left-narrow":{right:"30px"},".cm-completionInfo.cm-completionInfo-right-narrow":{left:"30px"},"&light .cm-snippetField":{backgroundColor:"#00000022"},"&dark .cm-snippetField":{backgroundColor:"#ffffff22"},".cm-snippetFieldPosition":{verticalAlign:"text-top",width:0,height:"1.15em",display:"inline-block",margin:"0 -0.7px -.7em",borderLeft:"1.4px dotted #888"},".cm-completionMatchedText":{textDecoration:"underline"},".cm-completionDetail":{marginLeft:"0.5em",fontStyle:"italic"},".cm-completionIcon":{fontSize:"90%",width:".8em",display:"inline-block",textAlign:"center",paddingRight:".6em",opacity:"0.6",boxSizing:"content-box"},".cm-completionIcon-function, .cm-completionIcon-method":{"&:after":{content:"'ƒ'"}},".cm-completionIcon-class":{"&:after":{content:"'○'"}},".cm-completionIcon-interface":{"&:after":{content:"'◌'"}},".cm-completionIcon-variable":{"&:after":{content:"'𝑥'"}},".cm-completionIcon-constant":{"&:after":{content:"'𝐶'"}},".cm-completionIcon-type":{"&:after":{content:"'𝑡'"}},".cm-completionIcon-enum":{"&:after":{content:"'∪'"}},".cm-completionIcon-property":{"&:after":{content:"'□'"}},".cm-completionIcon-keyword":{"&:after":{content:"'🔑︎'"}},".cm-completionIcon-namespace":{"&:after":{content:"'▢'"}},".cm-completionIcon-text":{"&:after":{content:"'abc'",fontSize:"50%",verticalAlign:"middle"}}});class FieldPos{constructor(e,t,o,i){this.field=e,this.line=t,this.from=o,this.to=i}}class FieldRange{constructor(e,t,o){this.field=e,this.from=t,this.to=o}map(e){let t=e.mapPos(this.from,-1,MapMode.TrackDel),o=e.mapPos(this.to,1,MapMode.TrackDel);return null==t||null==o?null:new FieldRange(this.field,t,o)}}class Snippet{constructor(e,t){this.lines=e,this.fieldPositions=t}instantiate(e,t){let o=[],i=[t],n=e.doc.lineAt(t),s=/^\s*/.exec(n.text)[0];for(let n of this.lines){if(o.length){let o=s,l=/^\t*/.exec(n)[0].length;for(let t=0;t<l;t++)o+=e.facet(indentUnit);i.push(t+o.length-l),n=o+n.slice(l)}o.push(n),t+=n.length+1}let l=this.fieldPositions.map((e=>new FieldRange(e.field,i[e.line]+e.from,i[e.line]+e.to)));return{text:o,ranges:l}}static parse(e){let t,o=[],i=[],n=[];for(let s of e.split(/\r\n?|\n/)){for(;t=/[#$]\{(?:(\d+)(?::([^}]*))?|((?:\\[{}]|[^}])*))\}/.exec(s);){let e=t[1]?+t[1]:null,l=t[2]||t[3]||"",r=-1,a=l.replace(/\\[{}]/g,(e=>e[1]));for(let t=0;t<o.length;t++)(null!=e?o[t].seq==e:a&&o[t].name==a)&&(r=t);if(r<0){let t=0;for(;t<o.length&&(null==e||null!=o[t].seq&&o[t].seq<e);)t++;o.splice(t,0,{seq:e,name:a}),r=t;for(let e of n)e.field>=r&&e.field++}n.push(new FieldPos(r,i.length,t.index,t.index+a.length)),s=s.slice(0,t.index)+l+s.slice(t.index+t[0].length)}s=s.replace(/\\([{}])/g,((e,t,o)=>{for(let e of n)e.line==i.length&&e.from>o&&(e.from--,e.to--);return t})),i.push(s)}return new Snippet(i,n)}}let fieldMarker=Decoration.widget({widget:new class extends WidgetType{toDOM(){let e=document.createElement("span");return e.className="cm-snippetFieldPosition",e}ignoreEvent(){return!1}}}),fieldRange=Decoration.mark({class:"cm-snippetField"});class ActiveSnippet{constructor(e,t){this.ranges=e,this.active=t,this.deco=Decoration.set(e.map((e=>(e.from==e.to?fieldMarker:fieldRange).range(e.from,e.to))))}map(e){let t=[];for(let o of this.ranges){let i=o.map(e);if(!i)return null;t.push(i)}return new ActiveSnippet(t,this.active)}selectionInsideField(e){return e.ranges.every((e=>this.ranges.some((t=>t.field==this.active&&t.from<=e.from&&t.to>=e.to))))}}const setActive=StateEffect.define({map:(e,t)=>e&&e.map(t)}),moveToField=StateEffect.define(),snippetState=StateField.define({create:()=>null,update(e,t){for(let o of t.effects){if(o.is(setActive))return o.value;if(o.is(moveToField)&&e)return new ActiveSnippet(e.ranges,o.value)}return e&&t.docChanged&&(e=e.map(t.changes)),e&&t.selection&&!e.selectionInsideField(t.selection)&&(e=null),e},provide:e=>EditorView.decorations.from(e,(e=>e?e.deco:Decoration.none))});function fieldSelection(e,t){return EditorSelection.create(e.filter((e=>e.field==t)).map((e=>EditorSelection.range(e.from,e.to))))}function snippet(e){let t=Snippet.parse(e);return(e,o,i,n)=>{let{text:s,ranges:l}=t.instantiate(e.state,i),r={changes:{from:i,to:n,insert:Text.of(s)},scrollIntoView:!0,annotations:o?[pickedCompletion.of(o),Transaction.userEvent.of("input.complete")]:void 0};if(l.length&&(r.selection=fieldSelection(l,0)),l.some((e=>e.field>0))){let t=new ActiveSnippet(l,0),o=r.effects=[setActive.of(t)];void 0===e.state.field(snippetState,!1)&&o.push(StateEffect.appendConfig.of([snippetState,addSnippetKeymap,snippetPointerHandler,baseTheme]))}e.dispatch(e.state.update(r))}}function moveField(e){return({state:t,dispatch:o})=>{let i=t.field(snippetState,!1);if(!i||e<0&&0==i.active)return!1;let n=i.active+e,s=e>0&&!i.ranges.some((t=>t.field==n+e));return o(t.update({selection:fieldSelection(i.ranges,n),effects:setActive.of(s?null:new ActiveSnippet(i.ranges,n)),scrollIntoView:!0})),!0}}const clearSnippet=({state:e,dispatch:t})=>!!e.field(snippetState,!1)&&(t(e.update({effects:setActive.of(null)})),!0),nextSnippetField=moveField(1),prevSnippetField=moveField(-1);function hasNextSnippetField(e){let t=e.field(snippetState,!1);return!(!t||!t.ranges.some((e=>e.field==t.active+1)))}function hasPrevSnippetField(e){let t=e.field(snippetState,!1);return!!(t&&t.active>0)}const defaultSnippetKeymap=[{key:"Tab",run:nextSnippetField,shift:prevSnippetField},{key:"Escape",run:clearSnippet}],snippetKeymap=Facet.define({combine:e=>e.length?e[0]:defaultSnippetKeymap}),addSnippetKeymap=Prec.highest(keymap.compute([snippetKeymap],(e=>e.facet(snippetKeymap))));function snippetCompletion(e,t){return Object.assign(Object.assign({},t),{apply:snippet(e)})}const snippetPointerHandler=EditorView.domEventHandlers({mousedown(e,t){let o,i=t.state.field(snippetState,!1);if(!i||null==(o=t.posAtCoords({x:e.clientX,y:e.clientY})))return!1;let n=i.ranges.find((e=>e.from<=o&&e.to>=o));return!(!n||n.field==i.active)&&(t.dispatch({selection:fieldSelection(i.ranges,n.field),effects:setActive.of(i.ranges.some((e=>e.field>n.field))?new ActiveSnippet(i.ranges,n.field):null),scrollIntoView:!0}),!0)}});function wordRE(e){let t=e.replace(/[\]\-\\]/g,"\\$&");try{return new RegExp(`[\\p{Alphabetic}\\p{Number}_${t}]+`,"ug")}catch(e){return new RegExp(`[w${t}]`,"g")}}function mapRE(e,t){return new RegExp(t(e.source),e.unicode?"u":"")}const wordCaches=Object.create(null);function wordCache(e){return wordCaches[e]||(wordCaches[e]=new WeakMap)}function storeWords(e,t,o,i,n){for(let s=e.iterLines(),l=0;!s.next().done;){let e,{value:r}=s;for(t.lastIndex=0;e=t.exec(r);)if(!i[e[0]]&&l+e.index!=n&&(o.push({type:"text",label:e[0]}),i[e[0]]=!0,o.length>=2e3))return;l+=r.length+1}}function collectWords(e,t,o,i,n){let s=e.length>=1e3,l=s&&t.get(e);if(l)return l;let r=[],a=Object.create(null);if(e.children){let s=0;for(let l of e.children){if(l.length>=1e3)for(let e of collectWords(l,t,o,i-s,n-s))a[e.label]||(a[e.label]=!0,r.push(e));else storeWords(l,o,r,a,n-s);s+=l.length+1}}else storeWords(e,o,r,a,n);return s&&r.length<2e3&&t.set(e,r),r}const completeAnyWord=e=>{let t=e.state.languageDataAt("wordChars",e.pos).join(""),o=wordRE(t),i=e.matchBefore(mapRE(o,(e=>e+"$")));if(!i&&!e.explicit)return null;let n=i?i.from:e.pos;return{from:n,options:collectWords(e.state.doc,wordCache(t),o,5e4,n),validFor:mapRE(o,(e=>"^"+e))}},defaults={brackets:["(","[","{","'",'"'],before:")]}:;>",stringPrefixes:[]},closeBracketEffect=StateEffect.define({map(e,t){let o=t.mapPos(e,-1,MapMode.TrackAfter);return null==o?void 0:o}}),closedBracket=new class extends RangeValue{};closedBracket.startSide=1,closedBracket.endSide=-1;const bracketState=StateField.define({create:()=>RangeSet.empty,update(e,t){if(e=e.map(t.changes),t.selection){let o=t.state.doc.lineAt(t.selection.main.head);e=e.update({filter:e=>e>=o.from&&e<=o.to})}for(let o of t.effects)o.is(closeBracketEffect)&&(e=e.update({add:[closedBracket.range(o.value,o.value+1)]}));return e}});function closeBrackets(){return[inputHandler,bracketState]}const definedClosing="()[]{}<>";function closing(e){for(let t=0;t<definedClosing.length;t+=2)if(definedClosing.charCodeAt(t)==e)return definedClosing.charAt(t+1);return fromCodePoint(e<128?e:e+1)}function config(e,t){return e.languageDataAt("closeBrackets",t)[0]||defaults}const android="object"==typeof navigator&&/Android\b/.test(navigator.userAgent),inputHandler=EditorView.inputHandler.of(((e,t,o,i)=>{if((android?e.composing:e.compositionStarted)||e.state.readOnly)return!1;let n=e.state.selection.main;if(i.length>2||2==i.length&&1==codePointSize(codePointAt(i,0))||t!=n.from||o!=n.to)return!1;let s=insertBracket(e.state,i);return!!s&&(e.dispatch(s),!0)})),deleteBracketPair=({state:e,dispatch:t})=>{if(e.readOnly)return!1;let o=config(e,e.selection.main.head).brackets||defaults.brackets,i=null,n=e.changeByRange((t=>{if(t.empty){let i=prevChar(e.doc,t.head);for(let n of o)if(n==i&&nextChar(e.doc,t.head)==closing(codePointAt(n,0)))return{changes:{from:t.head-n.length,to:t.head+n.length},range:EditorSelection.cursor(t.head-n.length)}}return{range:i=t}}));return i||t(e.update(n,{scrollIntoView:!0,userEvent:"delete.backward"})),!i},closeBracketsKeymap=[{key:"Backspace",run:deleteBracketPair}];function insertBracket(e,t){let o=config(e,e.selection.main.head),i=o.brackets||defaults.brackets;for(let n of i){let s=closing(codePointAt(n,0));if(t==n)return s==n?handleSame(e,n,i.indexOf(n+n+n)>-1,o):handleOpen(e,n,s,o.before||defaults.before);if(t==s&&closedBracketAt(e,e.selection.main.from))return handleClose(e,n,s)}return null}function closedBracketAt(e,t){let o=!1;return e.field(bracketState).between(0,e.doc.length,(e=>{e==t&&(o=!0)})),o}function nextChar(e,t){let o=e.sliceString(t,t+2);return o.slice(0,codePointSize(codePointAt(o,0)))}function prevChar(e,t){let o=e.sliceString(t-2,t);return codePointSize(codePointAt(o,0))==o.length?o:o.slice(1)}function handleOpen(e,t,o,i){let n=null,s=e.changeByRange((s=>{if(!s.empty)return{changes:[{insert:t,from:s.from},{insert:o,from:s.to}],effects:closeBracketEffect.of(s.to+t.length),range:EditorSelection.range(s.anchor+t.length,s.head+t.length)};let l=nextChar(e.doc,s.head);return!l||/\s/.test(l)||i.indexOf(l)>-1?{changes:{insert:t+o,from:s.head},effects:closeBracketEffect.of(s.head+t.length),range:EditorSelection.cursor(s.head+t.length)}:{range:n=s}}));return n?null:e.update(s,{scrollIntoView:!0,userEvent:"input.type"})}function handleClose(e,t,o){let i=null,n=e.changeByRange((t=>t.empty&&nextChar(e.doc,t.head)==o?{changes:{from:t.head,to:t.head+o.length,insert:o},range:EditorSelection.cursor(t.head+o.length)}:i={range:t}));return i?null:e.update(n,{scrollIntoView:!0,userEvent:"input.type"})}function handleSame(e,t,o,i){let n=i.stringPrefixes||defaults.stringPrefixes,s=null,l=e.changeByRange((i=>{if(!i.empty)return{changes:[{insert:t,from:i.from},{insert:t,from:i.to}],effects:closeBracketEffect.of(i.to+t.length),range:EditorSelection.range(i.anchor+t.length,i.head+t.length)};let l,r=i.head,a=nextChar(e.doc,r);if(a==t){if(nodeStart(e,r))return{changes:{insert:t+t,from:r},effects:closeBracketEffect.of(r+t.length),range:EditorSelection.cursor(r+t.length)};if(closedBracketAt(e,r)){let i=o&&e.sliceDoc(r,r+3*t.length)==t+t+t?t+t+t:t;return{changes:{from:r,to:r+i.length,insert:i},range:EditorSelection.cursor(r+i.length)}}}else{if(o&&e.sliceDoc(r-2*t.length,r)==t+t&&(l=canStartStringAt(e,r-2*t.length,n))>-1&&nodeStart(e,l))return{changes:{insert:t+t+t+t,from:r},effects:closeBracketEffect.of(r+t.length),range:EditorSelection.cursor(r+t.length)};if(e.charCategorizer(r)(a)!=CharCategory.Word&&canStartStringAt(e,r,n)>-1&&!probablyInString(e,r,t,n))return{changes:{insert:t+t,from:r},effects:closeBracketEffect.of(r+t.length),range:EditorSelection.cursor(r+t.length)}}return{range:s=i}}));return s?null:e.update(l,{scrollIntoView:!0,userEvent:"input.type"})}function nodeStart(e,t){let o=syntaxTree(e).resolveInner(t+1);return o.parent&&o.from==t}function probablyInString(e,t,o,i){let n=syntaxTree(e).resolveInner(t,-1),s=i.reduce(((e,t)=>Math.max(e,t.length)),0);for(let l=0;l<5;l++){let l=e.sliceDoc(n.from,Math.min(n.to,n.from+o.length+s)),r=l.indexOf(o);if(!r||r>-1&&i.indexOf(l.slice(0,r))>-1){let t=n.firstChild;for(;t&&t.from==n.from&&t.to-t.from>o.length+r;){if(e.sliceDoc(t.to-o.length,t.to)==o)return!1;t=t.firstChild}return!0}let a=n.to==t&&n.parent;if(!a)break;n=a}return!1}function canStartStringAt(e,t,o){let i=e.charCategorizer(t);if(i(e.sliceDoc(t-1,t))!=CharCategory.Word)return t;for(let n of o){let o=t-n.length;if(e.sliceDoc(o,t)==n&&i(e.sliceDoc(o-1,o))!=CharCategory.Word)return o}return-1}function autocompletion(e={}){return[commitCharacters,completionState,completionConfig.of(e),completionPlugin,completionKeymapExt,baseTheme]}const completionKeymap=[{key:"Ctrl-Space",run:startCompletion},{key:"Escape",run:closeCompletion},{key:"ArrowDown",run:moveCompletionSelection(!0)},{key:"ArrowUp",run:moveCompletionSelection(!1)},{key:"PageDown",run:moveCompletionSelection(!0,"page")},{key:"PageUp",run:moveCompletionSelection(!1,"page")},{key:"Enter",run:acceptCompletion}],completionKeymapExt=Prec.highest(keymap.computeN([completionConfig],(e=>e.facet(completionConfig).defaultKeymap?[completionKeymap]:[])));function completionStatus(e){let t=e.field(completionState,!1);return t&&t.active.some((e=>1==e.state))?"pending":t&&t.active.some((e=>0!=e.state))?"active":null}const completionArrayCache=new WeakMap;function currentCompletions(e){var t;let o=null===(t=e.field(completionState,!1))||void 0===t?void 0:t.open;if(!o||o.disabled)return[];let i=completionArrayCache.get(o.options);return i||completionArrayCache.set(o.options,i=o.options.map((e=>e.completion))),i}function selectedCompletion(e){var t;let o=null===(t=e.field(completionState,!1))||void 0===t?void 0:t.open;return o&&!o.disabled&&o.selected>=0?o.options[o.selected].completion:null}function selectedCompletionIndex(e){var t;let o=null===(t=e.field(completionState,!1))||void 0===t?void 0:t.open;return o&&!o.disabled&&o.selected>=0?o.selected:null}function setSelectedCompletion(e){return setSelectedEffect.of(e)}export{CompletionContext,acceptCompletion,autocompletion,clearSnippet,closeBrackets,closeBracketsKeymap,closeCompletion,completeAnyWord,completeFromList,completionKeymap,completionStatus,currentCompletions,deleteBracketPair,hasNextSnippetField,hasPrevSnippetField,ifIn,ifNotIn,insertBracket,insertCompletionText,moveCompletionSelection,nextSnippetField,pickedCompletion,prevSnippetField,selectedCompletion,selectedCompletionIndex,setSelectedCompletion,snippet,snippetCompletion,snippetKeymap,startCompletion};