/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import DocumentService from"@typo3/core/document-service.js";import RegularEvent from"@typo3/core/event/regular-event.js";import AjaxRequest from"@typo3/core/ajax/ajax-request.js";import PasswordStrength from"@typo3/install/module/password-strength.js";import{InfoBox}from"@typo3/install/renderable/info-box.js";import"@typo3/backend/element/icon-element.js";import{selector}from"@typo3/core/literals.js";import"@typo3/backend/element/progress-bar-element.js";var Identifiers;!function(e){e.body=".t3js-body",e.moduleContent=".t3js-module-content",e.mainContent=".t3js-installer-content",e.progressBar=".t3js-installer-progress",e.databaseConnectOutput=".t3js-installer-databaseConnect-output",e.databaseSelectOutput=".t3js-installer-databaseSelect-output",e.databaseDataOutput=".t3js-installer-databaseData-output"}(Identifiers||(Identifiers={}));class Installer{constructor(){this.initializeEvents(),DocumentService.ready().then((()=>{this.initialize()}))}initializeEvents(){new RegularEvent("click",(e=>{e.preventDefault(),this.showEnvironmentAndFolders()})).delegateTo(document,".t3js-installer-environmentFolders-retry"),new RegularEvent("click",(e=>{e.preventDefault(),this.executeEnvironmentAndFolders()})).delegateTo(document,".t3js-installer-environmentFolders-execute"),new RegularEvent("click",(e=>{e.preventDefault(),this.executeDatabaseConnect()})).delegateTo(document,".t3js-installer-databaseConnect-execute"),new RegularEvent("click",(e=>{e.preventDefault(),this.executeDatabaseSelect()})).delegateTo(document,".t3js-installer-databaseSelect-execute"),new RegularEvent("click",(e=>{e.preventDefault(),this.executeDatabaseData()})).delegateTo(document,".t3js-installer-databaseData-execute"),new RegularEvent("click",(e=>{e.preventDefault(),this.executeDefaultConfiguration()})).delegateTo(document,".t3js-installer-defaultConfiguration-execute"),new RegularEvent("click",((e,t)=>{e.preventDefault();const a=document.querySelector(t.dataset.toggleTarget);"invisible"===t.dataset.toggleState?(t.dataset.toggleState="visible",a.setAttribute("type","text")):(t.dataset.toggleState="invisible",a.setAttribute("type","password"))})).delegateTo(document,".t3-install-form-password-toggle"),new RegularEvent("change",((e,t)=>{const a=t.value;document.querySelectorAll(".t3-install-driver-data").forEach((e=>e.setAttribute("hidden",""))),document.querySelectorAll(".t3-install-driver-data input").forEach((e=>e.setAttribute("disabled","disabled"))),document.querySelectorAll(selector`#${a} input`).forEach((e=>e.removeAttribute("disabled"))),document.querySelector("#"+a)?.removeAttribute("hidden")})).delegateTo(document,"#t3js-connect-database-driver")}initialize(){this.setProgress(0),this.getMainLayout()}getUrl(e){let t=location.href;return t=t.replace(location.search,""),void 0!==e&&(t=t+"?install[action]="+e),t}setProgress(e){const t=document.querySelector(Identifiers.progressBar);null!==t&&0!==e&&(t.value=e,t.label=`Step ${e} of 5 completed`)}getMainLayout(){new AjaxRequest(this.getUrl("mainLayout")).get({cache:"no-cache"}).then((async e=>{const t=await e.resolve();document.querySelector(Identifiers.body).innerHTML=t.html,this.checkInstallerAvailable()}))}checkInstallerAvailable(){new AjaxRequest(this.getUrl("checkInstallerAvailable")).get({cache:"no-cache"}).then((async e=>{(await e.resolve()).success?this.checkEnvironmentAndFolders():this.showInstallerNotAvailable()}))}showInstallerNotAvailable(){const e=document.querySelector(Identifiers.mainContent);new AjaxRequest(this.getUrl("showInstallerNotAvailable")).get({cache:"no-cache"}).then((async t=>{const a=await t.resolve();!0===a.success&&(e.innerHTML=a.html)}))}checkEnvironmentAndFolders(){this.setProgress(1),new AjaxRequest(this.getUrl("checkEnvironmentAndFolders")).get({cache:"no-cache"}).then((async e=>{!0===(await e.resolve()).success?this.checkTrustedHostsPattern():this.showEnvironmentAndFolders()}))}showEnvironmentAndFolders(){const e=document.querySelector(Identifiers.mainContent);new AjaxRequest(this.getUrl("showEnvironmentAndFolders")).get({cache:"no-cache"}).then((async t=>{const a=await t.resolve();if(!0===a.success){e.innerHTML=a.html;const t=document.querySelector(".t3js-installer-environment-details");let s=!1;Array.isArray(a.environmentStatusErrors)&&a.environmentStatusErrors.forEach((e=>{s=!0,t.append(InfoBox.create(e.severity,e.title,e.message))})),Array.isArray(a.environmentStatusWarnings)&&a.environmentStatusWarnings.forEach((e=>{s=!0,t.append(InfoBox.create(e.severity,e.title,e.message))})),Array.isArray(a.structureErrors)&&a.structureErrors.forEach((e=>{s=!0,t.append(InfoBox.create(e.severity,e.title,e.message))})),s?(t.removeAttribute("hidden"),document.querySelectorAll(".t3js-installer-environmentFolders-bad").forEach((e=>e.removeAttribute("hidden")))):document.querySelectorAll(".t3js-installer-environmentFolders-good").forEach((e=>e.removeAttribute("hidden")))}}))}executeEnvironmentAndFolders(){new AjaxRequest(this.getUrl("executeEnvironmentAndFolders")).get({cache:"no-cache"}).then((async e=>{!0===(await e.resolve()).success&&this.checkTrustedHostsPattern()}))}checkTrustedHostsPattern(){new AjaxRequest(this.getUrl("checkTrustedHostsPattern")).get({cache:"no-cache"}).then((async e=>{!0===(await e.resolve()).success?this.checkDatabaseConnect():this.executeAdjustTrustedHostsPattern()}))}executeAdjustTrustedHostsPattern(){new AjaxRequest(this.getUrl("executeAdjustTrustedHostsPattern")).get({cache:"no-cache"}).then((()=>{this.checkDatabaseConnect()}))}checkDatabaseConnect(){this.setProgress(2),new AjaxRequest(this.getUrl("checkDatabaseConnect")).get({cache:"no-cache"}).then((async e=>{!0===(await e.resolve()).success?this.checkDatabaseSelect():this.showDatabaseConnect()}))}showDatabaseConnect(){const e=document.querySelector(Identifiers.mainContent);new AjaxRequest(this.getUrl("showDatabaseConnect")).get({cache:"no-cache"}).then((async t=>{const a=await t.resolve();!0===a.success&&(e.innerHTML=a.html,document.querySelector("#t3js-connect-database-driver").dispatchEvent(new Event("change",{bubbles:!0})),PasswordStrength.initialize(document.querySelector(".t3-install-form-password-strength")))}))}executeDatabaseConnect(){const e=document.querySelector(Identifiers.databaseConnectOutput),t={"install[action]":"executeDatabaseConnect","install[token]":document.querySelector(Identifiers.moduleContent).dataset.installerDatabaseConnectExecuteToken};for(const[e,a]of new FormData(document.querySelector(Identifiers.body+" form")))t[e]=a.toString();new AjaxRequest(this.getUrl()).post(t).then((async t=>{const a=await t.resolve();!0===a.success?this.checkDatabaseSelect():Array.isArray(a.status)&&(e.replaceChildren(),a.status.forEach((t=>{e.append(InfoBox.create(t.severity,t.title,t.message))})))}))}checkDatabaseSelect(){this.setProgress(3),new AjaxRequest(this.getUrl("checkDatabaseSelect")).get({cache:"no-cache"}).then((async e=>{!0===(await e.resolve()).success?this.checkDatabaseData():this.showDatabaseSelect()}))}showDatabaseSelect(){const e=document.querySelector(Identifiers.mainContent);new AjaxRequest(this.getUrl("showDatabaseSelect")).get({cache:"no-cache"}).then((async t=>{const a=await t.resolve();!0===a.success&&(e.innerHTML=a.html)}))}executeDatabaseSelect(){const e=document.querySelector(Identifiers.databaseSelectOutput),t={"install[action]":"executeDatabaseSelect","install[token]":document.querySelector(Identifiers.moduleContent).dataset.installerDatabaseSelectExecuteToken};for(const[e,a]of new FormData(document.querySelector(Identifiers.body+" form")))t[e]=a.toString();new AjaxRequest(this.getUrl()).post(t).then((async t=>{const a=await t.resolve();!0===a.success?this.checkDatabaseRequirements():Array.isArray(a.status)&&a.status.forEach((t=>{e.replaceChildren(InfoBox.create(t.severity,t.title,t.message))}))}))}checkDatabaseRequirements(){const e=document.querySelector(Identifiers.databaseSelectOutput),t={"install[action]":"checkDatabaseRequirements","install[token]":document.querySelector(Identifiers.moduleContent).dataset.installerDatabaseCheckRequirementsExecuteToken};for(const[e,a]of new FormData(document.querySelector(Identifiers.body+" form")))t[e]=a.toString();new AjaxRequest(this.getUrl()).post(t).then((async t=>{const a=await t.resolve();!0===a.success?this.checkDatabaseData():Array.isArray(a.status)&&(e.replaceChildren(),a.status.forEach((t=>{e.append(InfoBox.create(t.severity,t.title,t.message))})))}))}checkDatabaseData(){this.setProgress(4),new AjaxRequest(this.getUrl("checkDatabaseData")).get({cache:"no-cache"}).then((async e=>{!0===(await e.resolve()).success?this.showDefaultConfiguration():this.showDatabaseData()}))}showDatabaseData(){const e=document.querySelector(Identifiers.mainContent);new AjaxRequest(this.getUrl("showDatabaseData")).get({cache:"no-cache"}).then((async t=>{const a=await t.resolve();!0===a.success&&(e.innerHTML=a.html,PasswordStrength.initialize(document.querySelector(".t3-install-form-password-strength")))}))}executeDatabaseData(){const e=document.querySelector(Identifiers.databaseDataOutput),t={"install[action]":"executeDatabaseData","install[token]":document.querySelector(Identifiers.moduleContent).dataset.installerDatabaseDataExecuteToken};for(const[e,a]of new FormData(document.querySelector(Identifiers.body+" form")))t[e]=a.toString();const a=document.createElement("typo3-backend-progress-bar");e.replaceChildren(a),new AjaxRequest(this.getUrl()).post(t).then((async t=>{const a=await t.resolve();!0===a.success?this.showDefaultConfiguration():Array.isArray(a.status)&&(e.replaceChildren(),a.status.forEach((t=>{e.append(InfoBox.create(t.severity,t.title,t.message))})))}))}showDefaultConfiguration(){const e=document.querySelector(Identifiers.mainContent);this.setProgress(5),new AjaxRequest(this.getUrl("showDefaultConfiguration")).get({cache:"no-cache"}).then((async t=>{const a=await t.resolve();!0===a.success&&(e.innerHTML=a.html)}))}executeDefaultConfiguration(){const e={"install[action]":"executeDefaultConfiguration","install[token]":document.querySelector(Identifiers.moduleContent).dataset.installerDefaultConfigurationExecuteToken};for(const[t,a]of new FormData(document.querySelector(Identifiers.body+" form")))e[t]=a.toString();new AjaxRequest(this.getUrl()).post(e).then((async e=>{const t=await e.resolve();top.location.href=t.redirect}))}}export default new Installer;