/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import"bootstrap";import{AbstractInteractableModule}from"@typo3/install/module/abstract-interactable-module.js";import Modal from"@typo3/backend/modal.js";import Notification from"@typo3/backend/notification.js";import AjaxRequest from"@typo3/core/ajax/ajax-request.js";import{InfoBox}from"@typo3/install/renderable/info-box.js";import Severity from"@typo3/install/renderable/severity.js";import Router from"@typo3/install/router.js";import RegularEvent from"@typo3/core/event/regular-event.js";var Identifiers;!function(e){e.executeTrigger=".t3js-imageProcessing-execute",e.testContainer=".t3js-imageProcessing-twinContainer",e.twinImageTemplate="#t3js-imageProcessing-twinImage-template",e.commandContainer=".t3js-imageProcessing-command",e.commandText=".t3js-imageProcessing-command-text",e.twinImages=".t3js-imageProcessing-images"}(Identifiers||(Identifiers={}));class ImageProcessing extends AbstractInteractableModule{initialize(e){super.initialize(e),this.loadModuleFrameAgnostic("@typo3/install/renderable/info-box.js").then((()=>{this.getData()})),new RegularEvent("click",(e=>{e.preventDefault(),this.runTests()})).delegateTo(e,Identifiers.executeTrigger)}getData(){const e=this.getModalBody();new AjaxRequest(Router.getUrl("imageProcessingGetData")).get({cache:"no-cache"}).then((async t=>{const r=await t.resolve();!0===r.success?(e.innerHTML=r.html,Modal.setButtons(r.buttons),this.runTests()):Notification.error("Something went wrong","The request was not processed successfully. Please check the browser's console and TYPO3's log.")}),(t=>{Router.handleAjaxError(t,e)}))}runTests(){const e=this.getModalBody();this.setModalButtonsState(!1);const t=this.findInModal(Identifiers.twinImageTemplate),r=[];e.querySelectorAll(Identifiers.testContainer).forEach((n=>{n.replaceChildren(InfoBox.create(Severity.loading,"Loading..."));const o=new AjaxRequest(Router.getUrl(n.dataset.test)).get({cache:"no-cache"}).then((async e=>{const r=await e.resolve();if(!0===r.success){n.innerHTML="",Array.isArray(r.status)&&r.status.forEach((e=>{n.append(InfoBox.create(e.severity,e.title,e.message))}));const e=t.content.cloneNode(!0);if(!0===r.fileExists&&(e.querySelector("img.reference")?.setAttribute("src",r.referenceFile),e.querySelector("img.result")?.setAttribute("src",r.outputFile),e.querySelectorAll(Identifiers.twinImages).forEach((e=>e.hidden=!1))),Array.isArray(r.command)&&r.command.length>0){const t=e.querySelector(Identifiers.commandContainer);null!==t&&(t.hidden=!1);const n=[];r.command.forEach((e=>{n.push("<strong>Command:</strong>\n"+e[1]),3===e.length&&n.push("<strong>Result:</strong>\n"+e[2])}));const o=e.querySelector(Identifiers.commandText);null!==o&&(o.innerHTML=n.join("\n"))}n.append(e)}}),(t=>{Router.handleAjaxError(t,e)}));r.push(o)})),Promise.all(r).then((()=>{this.setModalButtonsState(!0)}))}}export default new ImageProcessing;