/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import Modal from"@typo3/backend/modal.js";import Notification from"@typo3/backend/notification.js";import AjaxRequest from"@typo3/core/ajax/ajax-request.js";import Router from"@typo3/install/router.js";import PasswordStrength from"@typo3/install/module/password-strength.js";import{AbstractInteractableModule}from"@typo3/install/module/abstract-interactable-module.js";import RegularEvent from"@typo3/core/event/regular-event.js";var Identifiers;!function(e){e.adminCreateButton=".t3js-createAdmin-create",e.adminUserInput=".t3js-createAdmin-user",e.adminRealNameInput=".t3js-createAdmin-realname",e.adminPasswordInput=".t3js-createAdmin-password",e.adminPasswordCheckInput=".t3js-createAdmin-password-check",e.adminEmailInput=".t3js-createAdmin-email",e.adminSysMaintainterInput=".t3js-createAdmin-system-maintainer"}(Identifiers||(Identifiers={}));class CreateAdmin extends AbstractInteractableModule{initialize(e){super.initialize(e),this.getData(),new RegularEvent("click",(e=>{e.preventDefault(),this.create()})).delegateTo(e,Identifiers.adminCreateButton)}getData(){const e=this.getModalBody();new AjaxRequest(Router.getUrl("createAdminGetData")).get({cache:"no-cache"}).then((async t=>{const a=await t.resolve();!0===a.success?(e.innerHTML=a.html,PasswordStrength.initialize(e.querySelector(".t3-install-form-password-strength")),Modal.setButtons(a.buttons)):Notification.error("Something went wrong","The request was not processed successfully. Please check the browser's console and TYPO3's log.")}),(t=>{Router.handleAjaxError(t,e)}))}create(){this.setModalButtonsState(!1);const e=this.getModalBody(),t={install:{action:"createAdmin",token:this.getModuleContent().dataset.createAdminToken,userName:this.findInModal(Identifiers.adminUserInput).value,userPassword:this.findInModal(Identifiers.adminPasswordInput).value,userPasswordCheck:this.findInModal(Identifiers.adminPasswordCheckInput).value,userEmail:this.findInModal(Identifiers.adminEmailInput).value,realName:this.findInModal(Identifiers.adminRealNameInput).value,userSystemMaintainer:this.findInModal(Identifiers.adminSysMaintainterInput).checked?1:0}};this.getModuleContent().querySelectorAll("input").forEach((e=>{e.disabled=!0})),new AjaxRequest(Router.getUrl()).post(t).then((async e=>{const t=await e.resolve();!0===t.success&&Array.isArray(t.status)?(t.status.forEach((e=>{Notification.showMessage(e.title,e.message,e.severity)})),t.userCreated&&(this.findInModal(Identifiers.adminUserInput).value="",this.findInModal(Identifiers.adminPasswordInput).value="",this.findInModal(Identifiers.adminPasswordCheckInput).value="",this.findInModal(Identifiers.adminEmailInput).value="",this.findInModal(Identifiers.adminSysMaintainterInput).checked=!1)):Notification.error("Something went wrong","The request was not processed successfully. Please check the browser's console and TYPO3's log.")}),(t=>{Router.handleAjaxError(t,e)})).finally((()=>{this.setModalButtonsState(!0),this.getModuleContent().querySelectorAll("input").forEach((e=>{e.disabled=!1}))}))}}export default new CreateAdmin;