/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.VMFrame;
import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.util.Value;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class StackFrameCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer bb, DataOutputStream os, byte command) throws JdwpException {
        boolean keepRunning = true;
        try {
            switch (command) {
                case 1: {
                    this.executeGetValues(bb, os);
                    break;
                }
                case 2: {
                    this.executeSetValues(bb, os);
                    break;
                }
                case 3: {
                    this.executeThisObject(bb, os);
                    break;
                }
                case 4: {
                    this.executePopFrames(bb, os);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + command + " not found in Stack Frame Command Set.");
                }
            }
        }
        catch (IOException ex) {
            throw new JdwpInternalErrorException(ex);
        }
        return false;
    }

    private final void executeGetValues(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ObjectId tId = this.idMan.readObjectId(bb);
        Thread thread = (Thread)tId.getObject();
        VMFrame frame = VMVirtualMachine.getFrame(thread, bb);
        int slots = bb.getInt();
        os.writeInt(slots);
        int i = 0;
        while (i < slots) {
            int slot = bb.getInt();
            byte sig = bb.get();
            Object val = frame.getValue(slot);
            Value.writeTaggedValue(os, val);
            ++i;
        }
    }

    private final void executeSetValues(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ObjectId tId = this.idMan.readObjectId(bb);
        Thread thread = (Thread)tId.getObject();
        VMFrame frame = VMVirtualMachine.getFrame(thread, bb);
        int slots = bb.getInt();
        int i = 0;
        while (i < slots) {
            int slot = bb.getInt();
            Object value = Value.getObj(bb);
            frame.setValue(slot, value);
            ++i;
        }
    }

    private final void executeThisObject(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ObjectId tId = this.idMan.readObjectId(bb);
        Thread thread = (Thread)tId.getObject();
        VMFrame frame = VMVirtualMachine.getFrame(thread, bb);
        Object thisObject = frame.getObject();
        Value.writeTaggedValue(os, thisObject);
    }

    private final void executePopFrames(ByteBuffer bb, DataOutputStream os) throws JdwpException {
        throw new NotImplementedException("Command PopFrames not implemented.");
    }
}

