/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.libxmlj.util;

import gnu.xml.dom.ls.ReaderInputStream;
import gnu.xml.dom.ls.WriterOutputStream;
import gnu.xml.libxmlj.transform.GnomeTransformerFactory;
import gnu.xml.libxmlj.util.NamedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;

public final class XMLJ {
    private static boolean initialised = false;
    private static final int LOOKAHEAD = 50;

    public static final void init() {
        if (!initialised) {
            System.loadLibrary("xmlj");
            XMLJShutdownHook hook = new XMLJShutdownHook();
            Runtime.getRuntime().addShutdownHook(new Thread(hook));
        }
        initialised = true;
    }

    public static final NamedInputStream getInputStream(InputSource input) throws IOException {
        Reader r;
        InputStream in = input.getByteStream();
        String systemId = input.getSystemId();
        if (in == null && (r = input.getCharacterStream()) != null) {
            in = new ReaderInputStream(r);
        }
        if (in == null) {
            in = XMLJ.getInputStream(systemId);
        }
        return new NamedInputStream(systemId, in, 50);
    }

    public static final NamedInputStream getInputStream(Source source) throws IOException {
        if (source instanceof SAXSource) {
            return XMLJ.getInputStream(((SAXSource)source).getInputSource());
        }
        InputStream in = null;
        String systemId = source.getSystemId();
        if (source instanceof StreamSource) {
            in = ((StreamSource)source).getInputStream();
        }
        if (in == null) {
            in = XMLJ.getInputStream(systemId);
        }
        return new NamedInputStream(systemId, in, 50);
    }

    private static final InputStream getInputStream(String systemId) throws IOException {
        if (systemId == null) {
            throw new IOException("no system ID");
        }
        try {
            return new URL(systemId).openStream();
        }
        catch (MalformedURLException e) {
            return new FileInputStream(systemId);
        }
    }

    public static final NamedInputStream getInputStream(URL url) throws IOException {
        return new NamedInputStream(url.toString(), url.openStream(), 50);
    }

    static final NamedInputStream xmljGetInputStream(String base, String url) throws IOException {
        try {
            if (base != null) {
                url = new URL(new URL(base), url).toString();
            }
        }
        catch (MalformedURLException in) {
            // empty catch block
        }
        InputStream in = XMLJ.getInputStream(url);
        return new NamedInputStream(url, in, 50);
    }

    public static final OutputStream getOutputStream(Result result) throws IOException {
        Writer w;
        OutputStream out = null;
        if (result instanceof StreamResult) {
            out = ((StreamResult)result).getOutputStream();
        }
        if (out == null && (w = ((StreamResult)result).getWriter()) != null) {
            out = new WriterOutputStream(w);
        }
        if (out == null) {
            String systemId = result.getSystemId();
            if (systemId == null) {
                throw new IOException("no system ID");
            }
            try {
                URL url = new URL(systemId);
                URLConnection connection = url.openConnection();
                connection.setDoOutput(true);
                out = connection.getOutputStream();
            }
            catch (MalformedURLException e) {
                out = new FileOutputStream(systemId);
            }
        }
        return out;
    }

    public static final String getAbsoluteURI(String base, String uri) {
        if (uri != null && base != null && uri.length() > 0 && uri.indexOf(58) == -1 && uri.charAt(0) != '/') {
            if (base.charAt(base.length() - 1) != '/') {
                int i = base.lastIndexOf(47);
                base = base.substring(0, i + 1);
            }
            return base + uri;
        }
        return uri;
    }

    public static final String getBaseURI(String uri) {
        int si;
        if (uri != null && (si = uri.lastIndexOf(47)) != -1) {
            uri = uri.substring(0, si + 1);
        }
        return uri;
    }

    static class XMLJShutdownHook
    implements Runnable {
        public void run() {
            System.gc();
            Runtime.getRuntime().runFinalization();
            GnomeTransformerFactory.freeLibxsltGlobal();
        }

        XMLJShutdownHook() {
        }
    }
}

