package TDS::Di;
#$Id: Di.pm,v 1.21 2001/01/03 08:20:39 tom Exp $
################################################################

=head1 NAME

 TDS::DI - Document Information

=cut

################################################################
use strict;

use Di;
use DateTime::Date;
use DateTime::Format;

use TDS;
use TDS::System;
use TDS::IdentInfo;
use TDS::Mode;

use vars qw(@ISA);

@ISA = qw(Di);

attributes qw();

################################################################
sub SetGeneralItems ($)
{
    my $self = shift;

    $self->url(TDS::IdentInfo->Get('url'));
    $self->title(TDS::IdentInfo->Get('title'));
    $self->author_name(TDS::IdentInfo->Get('author'));
    $self->authorized("TDS/$TDS::Version (Tomsoft Diary System)");
    $self->authorized_url($self->url);
    $self->method("GET/200");
    $self->Add_X("TDS-Mode", TDS::Mode::GetMode());
    $self->Add_X("TDS-CGI", ($TDS::System::CanUseCGI) ? 'on' : 'off');
    $self->Add_X("TDS-SSI", ($TDS::System::CanUseSSI) ? 'on' : 'off');
    # security problem??
#    $self->Add_X("TDS-SuExec", ($TDS::Status->is_ownerUID) ? 'on' : 'off');
    $self->Add_X("TDS-Version", $TDS::Version);
    $self->Add_X("TDS-Install-Type", ($TDS::System::TDS_Root) ? 'site-install' : 'standalone');
    $self->Add_X("MailAddress", TDS::IdentInfo->Get('address'));
    $self->Add_X("Diary-System", "TDS/$TDS::Version");
    $self->Add_X("HTML-Author",
		 qq(<meta name="author" content="$TDS::IdentInfo::AuthorName">));
    $self->Add_X("HTML-Title",
		 qq(<meta name="title" content="$TDS::IdentInfo::Title">));

}

sub Write($$)
{
    my ($self, $lm) = @_;
    my $lmd;                            # Last-Modified-Detect;
    my $update_di = 1;

    $self->Read;
    $self->SetGeneralItems;
#    my $old_lm = (stat($self->filename))[9];     # previous Last-Modified
    my $old_lm = str2time($self->last_modified);     # previous Last-Modified
    
    my $tm = time();                    # now time

#    print time2str_gen($lm, "GMT"), "<br>", $self->last_modified, "<br>";
#    print "$lm, $old_lm, $tm<br>";
#    print str2time(time2str_gen($lm, "GMT"));
    
    if ($lm > $old_lm){    # if diary is updated
	# touch last-modified file
	$lmd = $tm;                     # L-M-D is now time
    } else {               # if not updated
#	if ($tm > time2str_gen($self->expire)){
	if ($tm > str2time($self->expire)){
	    $lmd = $tm;
	} else {
	    $update_di = 0;
	}
    }

    if ($update_di){
	$self->SetLastModified($lm, $lmd);
	$self->SUPER::Write;
    }
}
1;

