require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MIPS_ASM_H)) {
    eval 'sub _MIPS_ASM_H () {1;}' unless defined(&_MIPS_ASM_H);
    require 'sys/cdefs.ph';
    require 'mips/regdef.ph';
    if(defined(&_KERNEL_OPT)) {
	require './mips/opt_gprof.ph';
    }
    if(defined(&__ASSEMBLER__)) {
	eval 'sub __BIT {
	    my($n) = @_;
    	    eval q((1<< ($n)));
	}' unless defined(&__BIT);
	eval 'sub __BITS {
	    my($hi,$lo) = @_;
    	    eval q(((~((~0)<<(($hi)+1)))((~0)<<($lo))));
	}' unless defined(&__BITS);
	eval 'sub __LOWEST_SET_BIT {
	    my($__mask) = @_;
    	    eval q((((($__mask) - 1) & ($__mask)) ^ ($__mask)));
	}' unless defined(&__LOWEST_SET_BIT);
	eval 'sub __SHIFTOUT {
	    my($__x, $__mask) = @_;
    	    eval q(((($__x) & ($__mask)) /  &__LOWEST_SET_BIT($__mask)));
	}' unless defined(&__SHIFTOUT);
	eval 'sub __SHIFTIN {
	    my($__x, $__mask) = @_;
    	    eval q((($__x) *  &__LOWEST_SET_BIT($__mask)));
	}' unless defined(&__SHIFTIN);
    }
    if(defined(&__mips_o32) ) {
	eval 'sub _MIPS_ASM_MCOUNT () {. &set  &push; . &set  &noreorder; . &set  &noat;  &subu  &sp,16;  &sw  &t9,12( &sp);  &move  &AT, &ra;  &lui  &t9,% &hi( &_mcount);  &addiu  &t9, &t9,% &lo( &_mcount);  &jalr  &t9;  &nop;  &lw  &t9,4( &sp);  &addiu  &sp,8;  &addiu  &t9,40; . &set  &pop;;}' unless defined(&_MIPS_ASM_MCOUNT);
    }
 elsif(defined(&__mips_o64) ) {
	die("yeahnah");
    } else {
	if(defined(&__mips_abicalls)) {
	    eval 'sub _MIPS_ASM_MCOUNT () {. &set  &push; . &set  &noreorder; . &set  &noat;  &subu  &sp,16;  &sw  &t9,8( &sp);  &move  &AT, &ra;  &lui  &t9,% &hi( &_mcount);  &addiu  &t9, &t9,% &lo( &_mcount);  &jalr  &t9;  &nop;  &lw  &t9,8( &sp);  &addiu  &sp,16; . &set  &pop;;}' unless defined(&_MIPS_ASM_MCOUNT);
	} else {
	    eval 'sub _MIPS_ASM_MCOUNT () {. &set  &push; . &set  &noreorder; . &set  &noat;  &move  &AT, &ra;  &jal  &_mcount;  &nop; . &set  &pop;;}' unless defined(&_MIPS_ASM_MCOUNT);
	}
    }
    if(defined(&GPROF)) {
	eval 'sub MCOUNT () { &_MIPS_ASM_MCOUNT;}' unless defined(&MCOUNT);
    } else {
	eval 'sub MCOUNT () {1;}' unless defined(&MCOUNT);
    }
    if(defined(&USE_AENT)) {
	eval 'sub AENT {
	    my($x) = @_;
    	    eval q(. &aent $x, 0);
	}' unless defined(&AENT);
    } else {
	eval 'sub AENT {
	    my($x) = @_;
    	    eval q();
	}' unless defined(&AENT);
    }
    eval 'sub WEAK_ALIAS {
        my($alias,$sym) = @_;
	    eval q(. &weak $alias; $alias = $sym);
    }' unless defined(&WEAK_ALIAS);
    eval 'sub STRONG_ALIAS {
        my($alias,$sym) = @_;
	    eval q(. &globl $alias; $alias = $sym);
    }' unless defined(&STRONG_ALIAS);
    eval 'sub WARN_REFERENCES {
        my($sym,$msg) = @_;
	    eval q(. &pushsection  &__CONCAT(. ($gnu->{warning}).,$sym); . &ascii $msg; . &popsection);
    }' unless defined(&WARN_REFERENCES);
    eval 'sub STATIC_LEAF_NOPROFILE {
        my($x) = @_;
	    eval q(. &ent  &_C_LABEL($x);  &_C_LABEL($x): ; . &frame  &sp, 0,  &ra);
    }' unless defined(&STATIC_LEAF_NOPROFILE);
    eval 'sub LEAF_NOPROFILE {
        my($x) = @_;
	    eval q(. &globl  &_C_LABEL($x);  &STATIC_LEAF_NOPROFILE($x));
    }' unless defined(&LEAF_NOPROFILE);
    eval 'sub STATIC_LEAF {
        my($x) = @_;
	    eval q( &STATIC_LEAF_NOPROFILE($x);  &MCOUNT);
    }' unless defined(&STATIC_LEAF);
    eval 'sub LEAF {
        my($x) = @_;
	    eval q( &LEAF_NOPROFILE($x);  &MCOUNT);
    }' unless defined(&LEAF);
    eval 'sub STATIC_XLEAF {
        my($x) = @_;
	    eval q( &AENT ( &_C_LABEL($x));  &_C_LABEL($x):);
    }' unless defined(&STATIC_XLEAF);
    eval 'sub XLEAF {
        my($x) = @_;
	    eval q(. &globl  &_C_LABEL($x);  &STATIC_XLEAF($x));
    }' unless defined(&XLEAF);
    eval 'sub STATIC_NESTED_NOPROFILE {
        my($x, $fsize, $retpc) = @_;
	    eval q(. &ent  &_C_LABEL($x); . &type  &_C_LABEL($x), @ &function;  &_C_LABEL($x): ; . &frame  &sp, $fsize, $retpc);
    }' unless defined(&STATIC_NESTED_NOPROFILE);
    eval 'sub NESTED_NOPROFILE {
        my($x, $fsize, $retpc) = @_;
	    eval q(. &globl  &_C_LABEL($x);  &STATIC_NESTED_NOPROFILE($x, $fsize, $retpc));
    }' unless defined(&NESTED_NOPROFILE);
    eval 'sub NESTED {
        my($x, $fsize, $retpc) = @_;
	    eval q( &NESTED_NOPROFILE($x, $fsize, $retpc);  &MCOUNT);
    }' unless defined(&NESTED);
    eval 'sub STATIC_NESTED {
        my($x, $fsize, $retpc) = @_;
	    eval q( &STATIC_NESTED_NOPROFILE($x, $fsize, $retpc);  &MCOUNT);
    }' unless defined(&STATIC_NESTED);
    eval 'sub XNESTED {
        my($x) = @_;
	    eval q(. &globl  &_C_LABEL($x);  &AENT ( &_C_LABEL($x));  &_C_LABEL($x):);
    }' unless defined(&XNESTED);
    eval 'sub END {
        my($x) = @_;
	    eval q(. &end  &_C_LABEL($x); . &size  &_C_LABEL($x), . -  &_C_LABEL($x));
    }' unless defined(&END);
    eval 'sub IMPORT {
        my($sym, $size) = @_;
	    eval q(. &extern  &_C_LABEL($sym),$size);
    }' unless defined(&IMPORT);
    eval 'sub EXPORT {
        my($x) = @_;
	    eval q(. &globl  &_C_LABEL($x);  &_C_LABEL($x):);
    }' unless defined(&EXPORT);
    eval 'sub EXPORT_OBJECT {
        my($x) = @_;
	    eval q( &EXPORT($x); . &type  &_C_LABEL($x), @ &object;);
    }' unless defined(&EXPORT_OBJECT);
    eval 'sub VECTOR {
        my($x, $regmask) = @_;
	    eval q(. &ent  &_C_LABEL($x);  &EXPORT($x););
    }' unless defined(&VECTOR);
    eval 'sub VECTOR_END {
        my($x) = @_;
	    eval q( &EXPORT( &__CONCAT($x, &_end));  &END($x); . &org  &_C_LABEL($x) + 0x80);
    }' unless defined(&VECTOR_END);
    eval 'sub PANIC {
        my($msg) = @_;
	    eval q( &PTR_LA  &a0, 9 &f;  &jal  &_C_LABEL( &panic);  &nop;  &MSG($msg));
    }' unless defined(&PANIC);
    eval 'sub PRINTF {
        my($msg) = @_;
	    eval q( &PTR_LA  &a0, 9 &f;  &jal  &_C_LABEL( &printf);  &nop;  &MSG($msg));
    }' unless defined(&PRINTF);
    eval 'sub MSG {
        my($msg) = @_;
	    eval q(. &rdata; 9: . &asciz $msg; . &text);
    }' unless defined(&MSG);
    eval 'sub ASMSTR {
        my($str) = @_;
	    eval q(. &asciz $str; . &align 3);
    }' unless defined(&ASMSTR);
    eval 'sub RCSID {
        my($x) = @_;
	    eval q(. &pushsection \\".ident\\",\\"MS\\",@ &progbits,1; . &asciz $x; . &popsection);
    }' unless defined(&RCSID);
    eval 'sub ALEAF {
        my($x) = @_;
	    eval q( &XLEAF($x));
    }' unless defined(&ALEAF);
    eval 'sub NLEAF {
        my($x) = @_;
	    eval q( &LEAF_NOPROFILE($x));
    }' unless defined(&NLEAF);
    eval 'sub NON_LEAF {
        my($x, $fsize, $retpc) = @_;
	    eval q( &NESTED($x, $fsize, $retpc));
    }' unless defined(&NON_LEAF);
    eval 'sub NNON_LEAF {
        my($x, $fsize, $retpc) = @_;
	    eval q( &NESTED_NOPROFILE($x, $fsize, $retpc));
    }' unless defined(&NNON_LEAF);
    if(defined(&__mips_o32)) {
	eval 'sub SZREG () {4;}' unless defined(&SZREG);
    } else {
	eval 'sub SZREG () {8;}' unless defined(&SZREG);
    }
    if(defined(&__mips_o32) || defined(&__mips_o64)) {
	eval 'sub ALSK () {7;}' unless defined(&ALSK);
	eval 'sub ALMASK () {-7;}' unless defined(&ALMASK);
	eval 'sub SZFPREG () {4;}' unless defined(&SZFPREG);
	eval 'sub FP_L () { &lwc1;}' unless defined(&FP_L);
	eval 'sub FP_S () { &swc1;}' unless defined(&FP_S);
    } else {
	eval 'sub ALSK () {15;}' unless defined(&ALSK);
	eval 'sub ALMASK () {-15;}' unless defined(&ALMASK);
	eval 'sub SZFPREG () {8;}' unless defined(&SZFPREG);
	eval 'sub FP_L () { &ldc1;}' unless defined(&FP_L);
	eval 'sub FP_S () { &sdc1;}' unless defined(&FP_S);
    }
    if(defined(&__mips_o32) || defined(&__mips_o64)) {
	eval 'sub CALLFRAME_SIZ () {( &SZREG * (4+ 2));}' unless defined(&CALLFRAME_SIZ);
	eval 'sub CALLFRAME_S0 () {0;}' unless defined(&CALLFRAME_S0);
    }
 elsif(defined(&__mips_n32) || defined(&__mips_n64)) {
	eval 'sub CALLFRAME_SIZ () {( &SZREG * 4);}' unless defined(&CALLFRAME_SIZ);
	eval 'sub CALLFRAME_S0 () {( &CALLFRAME_SIZ - 4*  &SZREG);}' unless defined(&CALLFRAME_S0);
    }
    unless(defined(&_KERNEL)) {
	eval 'sub CALLFRAME_GP () {( &CALLFRAME_SIZ - 3*  &SZREG);}' unless defined(&CALLFRAME_GP);
    }
    eval 'sub CALLFRAME_SP () {( &CALLFRAME_SIZ - 2*  &SZREG);}' unless defined(&CALLFRAME_SP);
    eval 'sub CALLFRAME_RA () {( &CALLFRAME_SIZ - 1*  &SZREG);}' unless defined(&CALLFRAME_RA);
    if(defined(&__mips_o32)) {
	eval 'sub PTR_ADD () { &add;}' unless defined(&PTR_ADD);
	eval 'sub PTR_ADDI () { &addi;}' unless defined(&PTR_ADDI);
	eval 'sub PTR_ADDU () { &addu;}' unless defined(&PTR_ADDU);
	eval 'sub PTR_ADDIU () { &addiu;}' unless defined(&PTR_ADDIU);
	eval 'sub PTR_SUB () { &subu;}' unless defined(&PTR_SUB);
	eval 'sub PTR_SUBI () { &subi;}' unless defined(&PTR_SUBI);
	eval 'sub PTR_SUBU () { &subu;}' unless defined(&PTR_SUBU);
	eval 'sub PTR_SUBIU () { &subu;}' unless defined(&PTR_SUBIU);
	eval 'sub PTR_L () { &lw;}' unless defined(&PTR_L);
	eval 'sub PTR_LA () { &la;}' unless defined(&PTR_LA);
	eval 'sub PTR_S () { &sw;}' unless defined(&PTR_S);
	eval 'sub PTR_SLL () { &sll;}' unless defined(&PTR_SLL);
	eval 'sub PTR_SLLV () { &sllv;}' unless defined(&PTR_SLLV);
	eval 'sub PTR_SRL () { &srl;}' unless defined(&PTR_SRL);
	eval 'sub PTR_SRLV () { &srlv;}' unless defined(&PTR_SRLV);
	eval 'sub PTR_SRA () { &sra;}' unless defined(&PTR_SRA);
	eval 'sub PTR_SRAV () { &srav;}' unless defined(&PTR_SRAV);
	eval 'sub PTR_LL () { &ll;}' unless defined(&PTR_LL);
	eval 'sub PTR_SC () { &sc;}' unless defined(&PTR_SC);
	eval 'sub PTR_WORD () {. &word;}' unless defined(&PTR_WORD);
	eval 'sub PTR_SCALESHIFT () {2;}' unless defined(&PTR_SCALESHIFT);
    } else {
	eval 'sub PTR_ADD () { &dadd;}' unless defined(&PTR_ADD);
	eval 'sub PTR_ADDI () { &daddi;}' unless defined(&PTR_ADDI);
	eval 'sub PTR_ADDU () { &daddu;}' unless defined(&PTR_ADDU);
	eval 'sub PTR_ADDIU () { &daddiu;}' unless defined(&PTR_ADDIU);
	eval 'sub PTR_SUB () { &dsubu;}' unless defined(&PTR_SUB);
	eval 'sub PTR_SUBI () { &dsubi;}' unless defined(&PTR_SUBI);
	eval 'sub PTR_SUBU () { &dsubu;}' unless defined(&PTR_SUBU);
	eval 'sub PTR_SUBIU () { &dsubu;}' unless defined(&PTR_SUBIU);
	if(defined(&__mips_n32)) {
	    eval 'sub PTR_L () { &lw;}' unless defined(&PTR_L);
	    eval 'sub PTR_LL () { &ll;}' unless defined(&PTR_LL);
	    eval 'sub PTR_SC () { &sc;}' unless defined(&PTR_SC);
	    eval 'sub PTR_S () { &sw;}' unless defined(&PTR_S);
	    eval 'sub PTR_SCALESHIFT () {2;}' unless defined(&PTR_SCALESHIFT);
	    eval 'sub PTR_WORD () {. &word;}' unless defined(&PTR_WORD);
	} else {
	    eval 'sub PTR_L () { &ld;}' unless defined(&PTR_L);
	    eval 'sub PTR_LL () { &lld;}' unless defined(&PTR_LL);
	    eval 'sub PTR_SC () { &scd;}' unless defined(&PTR_SC);
	    eval 'sub PTR_S () { &sd;}' unless defined(&PTR_S);
	    eval 'sub PTR_SCALESHIFT () {3;}' unless defined(&PTR_SCALESHIFT);
	    eval 'sub PTR_WORD () {. &dword;}' unless defined(&PTR_WORD);
	}
	eval 'sub PTR_LA () { &dla;}' unless defined(&PTR_LA);
	eval 'sub PTR_SLL () { &dsll;}' unless defined(&PTR_SLL);
	eval 'sub PTR_SLLV () { &dsllv;}' unless defined(&PTR_SLLV);
	eval 'sub PTR_SRL () { &dsrl;}' unless defined(&PTR_SRL);
	eval 'sub PTR_SRLV () { &dsrlv;}' unless defined(&PTR_SRLV);
	eval 'sub PTR_SRA () { &dsra;}' unless defined(&PTR_SRA);
	eval 'sub PTR_SRAV () { &dsrav;}' unless defined(&PTR_SRAV);
    }
    if((defined(&_MIPS_SZINT) ? &_MIPS_SZINT : undef) == 32) {
	eval 'sub INT_ADD () { &add;}' unless defined(&INT_ADD);
	eval 'sub INT_ADDI () { &addi;}' unless defined(&INT_ADDI);
	eval 'sub INT_ADDU () { &addu;}' unless defined(&INT_ADDU);
	eval 'sub INT_ADDIU () { &addiu;}' unless defined(&INT_ADDIU);
	eval 'sub INT_SUB () { &subu;}' unless defined(&INT_SUB);
	eval 'sub INT_SUBI () { &subi;}' unless defined(&INT_SUBI);
	eval 'sub INT_SUBU () { &subu;}' unless defined(&INT_SUBU);
	eval 'sub INT_SUBIU () { &subu;}' unless defined(&INT_SUBIU);
	eval 'sub INT_L () { &lw;}' unless defined(&INT_L);
	eval 'sub INT_LA () { &la;}' unless defined(&INT_LA);
	eval 'sub INT_S () { &sw;}' unless defined(&INT_S);
	eval 'sub INT_SLL () { &sll;}' unless defined(&INT_SLL);
	eval 'sub INT_SLLV () { &sllv;}' unless defined(&INT_SLLV);
	eval 'sub INT_SRL () { &srl;}' unless defined(&INT_SRL);
	eval 'sub INT_SRLV () { &srlv;}' unless defined(&INT_SRLV);
	eval 'sub INT_SRA () { &sra;}' unless defined(&INT_SRA);
	eval 'sub INT_SRAV () { &srav;}' unless defined(&INT_SRAV);
	eval 'sub INT_LL () { &ll;}' unless defined(&INT_LL);
	eval 'sub INT_SC () { &sc;}' unless defined(&INT_SC);
	eval 'sub INT_WORD () {. &word;}' unless defined(&INT_WORD);
	eval 'sub INT_SCALESHIFT () {2;}' unless defined(&INT_SCALESHIFT);
    } else {
	eval 'sub INT_ADD () { &dadd;}' unless defined(&INT_ADD);
	eval 'sub INT_ADDI () { &daddi;}' unless defined(&INT_ADDI);
	eval 'sub INT_ADDU () { &daddu;}' unless defined(&INT_ADDU);
	eval 'sub INT_ADDIU () { &daddiu;}' unless defined(&INT_ADDIU);
	eval 'sub INT_SUB () { &dsubu;}' unless defined(&INT_SUB);
	eval 'sub INT_SUBI () { &dsubi;}' unless defined(&INT_SUBI);
	eval 'sub INT_SUBU () { &dsubu;}' unless defined(&INT_SUBU);
	eval 'sub INT_SUBIU () { &dsubu;}' unless defined(&INT_SUBIU);
	eval 'sub INT_L () { &ld;}' unless defined(&INT_L);
	eval 'sub INT_LA () { &dla;}' unless defined(&INT_LA);
	eval 'sub INT_S () { &sd;}' unless defined(&INT_S);
	eval 'sub INT_SLL () { &dsll;}' unless defined(&INT_SLL);
	eval 'sub INT_SLLV () { &dsllv;}' unless defined(&INT_SLLV);
	eval 'sub INT_SRL () { &dsrl;}' unless defined(&INT_SRL);
	eval 'sub INT_SRLV () { &dsrlv;}' unless defined(&INT_SRLV);
	eval 'sub INT_SRA () { &dsra;}' unless defined(&INT_SRA);
	eval 'sub INT_SRAV () { &dsrav;}' unless defined(&INT_SRAV);
	eval 'sub INT_LL () { &lld;}' unless defined(&INT_LL);
	eval 'sub INT_SC () { &scd;}' unless defined(&INT_SC);
	eval 'sub INT_WORD () {. &dword;}' unless defined(&INT_WORD);
	eval 'sub INT_SCALESHIFT () {3;}' unless defined(&INT_SCALESHIFT);
    }
    if((defined(&_MIPS_SZLONG) ? &_MIPS_SZLONG : undef) == 32) {
	eval 'sub LONG_ADD () { &add;}' unless defined(&LONG_ADD);
	eval 'sub LONG_ADDI () { &addi;}' unless defined(&LONG_ADDI);
	eval 'sub LONG_ADDU () { &addu;}' unless defined(&LONG_ADDU);
	eval 'sub LONG_ADDIU () { &addiu;}' unless defined(&LONG_ADDIU);
	eval 'sub LONG_SUB () { &subu;}' unless defined(&LONG_SUB);
	eval 'sub LONG_SUBI () { &subi;}' unless defined(&LONG_SUBI);
	eval 'sub LONG_SUBU () { &subu;}' unless defined(&LONG_SUBU);
	eval 'sub LONG_SUBIU () { &subu;}' unless defined(&LONG_SUBIU);
	eval 'sub LONG_L () { &lw;}' unless defined(&LONG_L);
	eval 'sub LONG_LA () { &la;}' unless defined(&LONG_LA);
	eval 'sub LONG_S () { &sw;}' unless defined(&LONG_S);
	eval 'sub LONG_SLL () { &sll;}' unless defined(&LONG_SLL);
	eval 'sub LONG_SLLV () { &sllv;}' unless defined(&LONG_SLLV);
	eval 'sub LONG_SRL () { &srl;}' unless defined(&LONG_SRL);
	eval 'sub LONG_SRLV () { &srlv;}' unless defined(&LONG_SRLV);
	eval 'sub LONG_SRA () { &sra;}' unless defined(&LONG_SRA);
	eval 'sub LONG_SRAV () { &srav;}' unless defined(&LONG_SRAV);
	eval 'sub LONG_LL () { &ll;}' unless defined(&LONG_LL);
	eval 'sub LONG_SC () { &sc;}' unless defined(&LONG_SC);
	eval 'sub LONG_WORD () {. &word;}' unless defined(&LONG_WORD);
	eval 'sub LONG_SCALESHIFT () {2;}' unless defined(&LONG_SCALESHIFT);
    } else {
	eval 'sub LONG_ADD () { &dadd;}' unless defined(&LONG_ADD);
	eval 'sub LONG_ADDI () { &daddi;}' unless defined(&LONG_ADDI);
	eval 'sub LONG_ADDU () { &daddu;}' unless defined(&LONG_ADDU);
	eval 'sub LONG_ADDIU () { &daddiu;}' unless defined(&LONG_ADDIU);
	eval 'sub LONG_SUB () { &dsubu;}' unless defined(&LONG_SUB);
	eval 'sub LONG_SUBI () { &dsubi;}' unless defined(&LONG_SUBI);
	eval 'sub LONG_SUBU () { &dsubu;}' unless defined(&LONG_SUBU);
	eval 'sub LONG_SUBIU () { &dsubu;}' unless defined(&LONG_SUBIU);
	eval 'sub LONG_L () { &ld;}' unless defined(&LONG_L);
	eval 'sub LONG_LA () { &dla;}' unless defined(&LONG_LA);
	eval 'sub LONG_S () { &sd;}' unless defined(&LONG_S);
	eval 'sub LONG_SLL () { &dsll;}' unless defined(&LONG_SLL);
	eval 'sub LONG_SLLV () { &dsllv;}' unless defined(&LONG_SLLV);
	eval 'sub LONG_SRL () { &dsrl;}' unless defined(&LONG_SRL);
	eval 'sub LONG_SRLV () { &dsrlv;}' unless defined(&LONG_SRLV);
	eval 'sub LONG_SRA () { &dsra;}' unless defined(&LONG_SRA);
	eval 'sub LONG_SRAV () { &dsrav;}' unless defined(&LONG_SRAV);
	eval 'sub LONG_LL () { &lld;}' unless defined(&LONG_LL);
	eval 'sub LONG_SC () { &scd;}' unless defined(&LONG_SC);
	eval 'sub LONG_WORD () {. &dword;}' unless defined(&LONG_WORD);
	eval 'sub LONG_SCALESHIFT () {3;}' unless defined(&LONG_SCALESHIFT);
    }
    if((defined(&SZREG) ? &SZREG : undef) == 4) {
	eval 'sub REG_L () { &lw;}' unless defined(&REG_L);
	eval 'sub REG_S () { &sw;}' unless defined(&REG_S);
	eval 'sub REG_LI () { &li;}' unless defined(&REG_LI);
	eval 'sub REG_ADDU () { &addu;}' unless defined(&REG_ADDU);
	eval 'sub REG_SLL () { &sll;}' unless defined(&REG_SLL);
	eval 'sub REG_SLLV () { &sllv;}' unless defined(&REG_SLLV);
	eval 'sub REG_SRL () { &srl;}' unless defined(&REG_SRL);
	eval 'sub REG_SRLV () { &srlv;}' unless defined(&REG_SRLV);
	eval 'sub REG_SRA () { &sra;}' unless defined(&REG_SRA);
	eval 'sub REG_SRAV () { &srav;}' unless defined(&REG_SRAV);
	eval 'sub REG_LL () { &ll;}' unless defined(&REG_LL);
	eval 'sub REG_SC () { &sc;}' unless defined(&REG_SC);
	eval 'sub REG_SCALESHIFT () {2;}' unless defined(&REG_SCALESHIFT);
    } else {
	eval 'sub REG_L () { &ld;}' unless defined(&REG_L);
	eval 'sub REG_S () { &sd;}' unless defined(&REG_S);
	eval 'sub REG_LI () { &dli;}' unless defined(&REG_LI);
	eval 'sub REG_ADDU () { &daddu;}' unless defined(&REG_ADDU);
	eval 'sub REG_SLL () { &dsll;}' unless defined(&REG_SLL);
	eval 'sub REG_SLLV () { &dsllv;}' unless defined(&REG_SLLV);
	eval 'sub REG_SRL () { &dsrl;}' unless defined(&REG_SRL);
	eval 'sub REG_SRLV () { &dsrlv;}' unless defined(&REG_SRLV);
	eval 'sub REG_SRA () { &dsra;}' unless defined(&REG_SRA);
	eval 'sub REG_SRAV () { &dsrav;}' unless defined(&REG_SRAV);
	eval 'sub REG_LL () { &lld;}' unless defined(&REG_LL);
	eval 'sub REG_SC () { &scd;}' unless defined(&REG_SC);
	eval 'sub REG_SCALESHIFT () {3;}' unless defined(&REG_SCALESHIFT);
    }
    if(((defined(&MIPS1) ? &MIPS1 : undef) + (defined(&MIPS2) ? &MIPS2 : undef)) > 0) {
	eval 'sub NOP_L () { &nop;}' unless defined(&NOP_L);
    } else {
	eval 'sub NOP_L () {1;}' unless defined(&NOP_L);
    }
    if(defined(&__OCTEON__)) {
	eval 'sub LLSCSYNC () {1;}' unless defined(&LLSCSYNC);
	eval 'sub BDSYNC () { &sync;}' unless defined(&BDSYNC);
	eval 'sub BDSYNC_ACQ () { &nop;}' unless defined(&BDSYNC_ACQ);
	eval 'sub SYNC_ACQ () {1;}' unless defined(&SYNC_ACQ);
	eval 'sub SYNC_REL () { &sync 4;}' unless defined(&SYNC_REL);
	eval 'sub BDSYNC_PLUNGER () { &sync 4;}' unless defined(&BDSYNC_PLUNGER);
	eval 'sub SYNC_PLUNGER () { &sync 4;}' unless defined(&SYNC_PLUNGER);
    }
 elsif((defined(&__mips) ? &__mips : undef) >= 3|| !defined(&__mips_o32)) {
	eval 'sub LLSCSYNC () {1;}' unless defined(&LLSCSYNC);
	eval 'sub BDSYNC () { &sync;}' unless defined(&BDSYNC);
	eval 'sub BDSYNC_ACQ () { &sync;}' unless defined(&BDSYNC_ACQ);
	eval 'sub SYNC_ACQ () { &sync;}' unless defined(&SYNC_ACQ);
	eval 'sub SYNC_REL () { &sync;}' unless defined(&SYNC_REL);
	eval 'sub BDSYNC_PLUNGER () { &nop;}' unless defined(&BDSYNC_PLUNGER);
	eval 'sub SYNC_PLUNGER () {1;}' unless defined(&SYNC_PLUNGER);
    } else {
	eval 'sub LLSCSYNC () {1;}' unless defined(&LLSCSYNC);
	eval 'sub BDSYNC () { &nop;}' unless defined(&BDSYNC);
	eval 'sub BDSYNC_ACQ () { &nop;}' unless defined(&BDSYNC_ACQ);
	eval 'sub SYNC_ACQ () {1;}' unless defined(&SYNC_ACQ);
	eval 'sub SYNC_REL () {1;}' unless defined(&SYNC_REL);
	eval 'sub BDSYNC_PLUNGER () { &nop;}' unless defined(&BDSYNC_PLUNGER);
	eval 'sub SYNC_PLUNGER () {1;}' unless defined(&SYNC_PLUNGER);
    }
    if(defined(&MULTIPROCESSOR)) {
	eval 'sub SYNC_DEKKER () { &sync;}' unless defined(&SYNC_DEKKER);
    } else {
	eval 'sub SYNC_DEKKER () {1;}' unless defined(&SYNC_DEKKER);
    }
    eval 'sub SYNC_PRODUCER () { &SYNC_REL;}' unless defined(&SYNC_PRODUCER);
    eval 'sub SYNC_CONSUMER () { &SYNC_ACQ;}' unless defined(&SYNC_CONSUMER);
    if(defined(&MIPS1) || defined(&MIPS2) || defined(&MIPS3)) {
	eval 'sub MFC0_HAZARD () { &sll $0,$0,1;}' unless defined(&MFC0_HAZARD);
    } else {
	eval 'sub MFC0_HAZARD () {1;}' unless defined(&MFC0_HAZARD);
    }
    if((defined(&_MIPS_ISA) ? &_MIPS_ISA : undef) == (defined(&_MIPS_ISA_MIPS1) ? &_MIPS_ISA_MIPS1 : undef) || (defined(&_MIPS_ISA) ? &_MIPS_ISA : undef) == (defined(&_MIPS_ISA_MIPS2) ? &_MIPS_ISA_MIPS2 : undef) || (defined(&_MIPS_ISA) ? &_MIPS_ISA : undef) == (defined(&_MIPS_ISA_MIPS32) ? &_MIPS_ISA_MIPS32 : undef)) {
	eval 'sub MFC0 () { &mfc0;}' unless defined(&MFC0);
	eval 'sub MTC0 () { &mtc0;}' unless defined(&MTC0);
    }
    if((defined(&_MIPS_ISA) ? &_MIPS_ISA : undef) == (defined(&_MIPS_ISA_MIPS3) ? &_MIPS_ISA_MIPS3 : undef) || (defined(&_MIPS_ISA) ? &_MIPS_ISA : undef) == (defined(&_MIPS_ISA_MIPS4) ? &_MIPS_ISA_MIPS4 : undef) || (defined(&_MIPS_ISA) ? &_MIPS_ISA : undef) == (defined(&_MIPS_ISA_MIPS64) ? &_MIPS_ISA_MIPS64 : undef)) {
	eval 'sub MFC0 () { &dmfc0;}' unless defined(&MFC0);
	eval 'sub MTC0 () { &dmtc0;}' unless defined(&MTC0);
    }
    if(defined(&__mips_o32) || defined(&__mips_o64)) {
	if(defined(&__mips_abicalls)) {
	    eval 'sub CPRESTORE {
	        my($r) = @_;
    		eval q(. &cprestore $r);
	    }' unless defined(&CPRESTORE);
	    eval 'sub CPLOAD {
	        my($r) = @_;
    		eval q(. &cpload $r);
	    }' unless defined(&CPLOAD);
	} else {
	    eval 'sub CPRESTORE {
	        my($r) = @_;
    		eval q();
	    }' unless defined(&CPRESTORE);
	    eval 'sub CPLOAD {
	        my($r) = @_;
    		eval q();
	    }' unless defined(&CPLOAD);
	}
	eval 'sub SETUP_GP () {. &set  &push; . &set  &noreorder; . &cpload  &t9; . &set  &pop;}' unless defined(&SETUP_GP);
	eval 'sub SETUP_GPX {
	    my($r) = @_;
    	    eval q(. &set  &push; . &set  &noreorder;  &move $r, &ra;  &bal 7 &f;  &nop; 7: . &cpload  &ra;  &move  &ra,$r; . &set  &pop);
	}' unless defined(&SETUP_GPX);
	eval 'sub SETUP_GPX_L {
	    my($r,$lbl) = @_;
    	    eval q(. &set  &push; . &set  &noreorder;  &move $r, &ra;  &bal $lbl;  &nop; $lbl: . &cpload  &ra;  &move  &ra,$r; . &set  &pop);
	}' unless defined(&SETUP_GPX_L);
	eval 'sub SAVE_GP {
	    my($x) = @_;
    	    eval q(. &cprestore $x);
	}' unless defined(&SAVE_GP);
	eval 'sub SETUP_GP64 {
	    my($a,$b) = @_;
    	    eval q();
	}' unless defined(&SETUP_GP64);
	eval 'sub SETUP_GP64_R {
	    my($a,$b) = @_;
    	    eval q();
	}' unless defined(&SETUP_GP64_R);
	eval 'sub SETUP_GPX64 {
	    my($a,$b) = @_;
    	    eval q();
	}' unless defined(&SETUP_GPX64);
	eval 'sub SETUP_GPX64_L {
	    my($a,$b,$c) = @_;
    	    eval q();
	}' unless defined(&SETUP_GPX64_L);
	eval 'sub RESTORE_GP64 () {1;}' unless defined(&RESTORE_GP64);
	eval 'sub USE_ALT_CP {
	    my($a) = @_;
    	    eval q();
	}' unless defined(&USE_ALT_CP);
    }
    if(defined(&__mips_o32) || defined(&__mips_o64)) {
	eval 'sub REG_PROLOGUE () {. &set  &push;}' unless defined(&REG_PROLOGUE);
	eval 'sub REG_EPILOGUE () {. &set  &pop;}' unless defined(&REG_EPILOGUE);
    }
    if(defined(&__mips_n32) || defined(&__mips_n64)) {
	eval 'sub REG_PROLOGUE () {. &set  &push ; . &set  &mips3;}' unless defined(&REG_PROLOGUE);
	eval 'sub REG_EPILOGUE () {. &set  &pop;}' unless defined(&REG_EPILOGUE);
    }
    if(defined(&__mips_n32) || defined(&__mips_n64)) {
	eval 'sub SETUP_GP () {1;}' unless defined(&SETUP_GP);
	eval 'sub SETUP_GPX {
	    my($r) = @_;
    	    eval q();
	}' unless defined(&SETUP_GPX);
	eval 'sub SETUP_GPX_L {
	    my($r,$lbl) = @_;
    	    eval q();
	}' unless defined(&SETUP_GPX_L);
	eval 'sub SAVE_GP {
	    my($x) = @_;
    	    eval q();
	}' unless defined(&SAVE_GP);
	eval 'sub SETUP_GP64 {
	    my($a,$b) = @_;
    	    eval q(. &cpsetup  &t9, $a, $b);
	}' unless defined(&SETUP_GP64);
	eval 'sub SETUP_GPX64 {
	    my($a,$b) = @_;
    	    eval q(. &set  &push;  &move $b, &ra; . &set  &noreorder;  &bal 7 &f;  &nop; 7: . &set  &pop; . &cpsetup  &ra, $a, 7$b;  &move  &ra,$b);
	}' unless defined(&SETUP_GPX64);
	eval 'sub SETUP_GPX64_L {
	    my($a,$b,$c) = @_;
    	    eval q(. &set  &push;  &move $b, &ra; . &set  &noreorder;  &bal $c;  &nop; $c: . &set  &pop; . &cpsetup  &ra, $a, $c;  &move  &ra,$b);
	}' unless defined(&SETUP_GPX64_L);
	eval 'sub RESTORE_GP64 () {. &cpreturn;}' unless defined(&RESTORE_GP64);
	eval 'sub USE_ALT_CP {
	    my($a) = @_;
    	    eval q(. &cplocal $a);
	}' unless defined(&USE_ALT_CP);
    }
    if(defined(&MIPS_DYNAMIC_STATUS_MASK)) {
	eval 'sub DYNAMIC_STATUS_MASK {
	    my($sr,$scratch) = @_;
    	    eval q( &lw $scratch,  &mips_dynamic_status_mask;  &and $sr, $sr, $scratch);
	}' unless defined(&DYNAMIC_STATUS_MASK);
	eval 'sub DYNAMIC_STATUS_MASK_TOUSER {
	    my($sr,$scratch1) = @_;
    	    eval q( &ori $sr, ( &MIPS_INT_MASK |  &MIPS_SR_INT_IE);  &DYNAMIC_STATUS_MASK($sr,$scratch1));
	}' unless defined(&DYNAMIC_STATUS_MASK_TOUSER);
    } else {
	eval 'sub DYNAMIC_STATUS_MASK {
	    my($sr,$scratch) = @_;
    	    eval q();
	}' unless defined(&DYNAMIC_STATUS_MASK);
	eval 'sub DYNAMIC_STATUS_MASK_TOUSER {
	    my($sr,$scratch1) = @_;
    	    eval q();
	}' unless defined(&DYNAMIC_STATUS_MASK_TOUSER);
    }
    eval 'sub LOG2_MIPS_LOCK_RAS_SIZE () {8;}' unless defined(&LOG2_MIPS_LOCK_RAS_SIZE);
    eval 'sub MIPS_LOCK_RAS_SIZE () {256;}' unless defined(&MIPS_LOCK_RAS_SIZE);
    eval 'sub CPUVAR {
        my($off) = @_;
	    eval q( &_C_LABEL( &cpu_info_store)+ &__CONCAT( &CPU_INFO_,$off));
    }' unless defined(&CPUVAR);
}
1;
