/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.ref;

import htsjdk.samtools.cram.CRAMException;
import htsjdk.samtools.cram.ref.ReferenceContextType;

public class ReferenceContext
implements Comparable<ReferenceContext> {
    public static final int UNMAPPED_UNPLACED_ID = -1;
    public static final int MULTIPLE_REFERENCE_ID = -2;
    public static final int UNINITIALIZED_REFERENCE_ID = -3;
    public static final ReferenceContext MULTIPLE_REFERENCE_CONTEXT = new ReferenceContext(-2);
    public static final ReferenceContext UNMAPPED_UNPLACED_CONTEXT = new ReferenceContext(-1);
    private final ReferenceContextType type;
    private final int referenceContextID;

    public ReferenceContext(int referenceContextID) {
        this.referenceContextID = referenceContextID;
        switch (referenceContextID) {
            case -2: {
                this.type = ReferenceContextType.MULTIPLE_REFERENCE_TYPE;
                break;
            }
            case -1: {
                this.type = ReferenceContextType.UNMAPPED_UNPLACED_TYPE;
                break;
            }
            default: {
                if (referenceContextID >= 0) {
                    this.type = ReferenceContextType.SINGLE_REFERENCE_TYPE;
                    break;
                }
                throw new CRAMException("Invalid reference sequence ID: " + referenceContextID);
            }
        }
    }

    public ReferenceContextType getType() {
        return this.type;
    }

    public int getReferenceContextID() {
        return this.referenceContextID;
    }

    public int getReferenceSequenceID() {
        if (this.type != ReferenceContextType.SINGLE_REFERENCE_TYPE) {
            throw new CRAMException(String.format("This ReferenceContext does not have a valid reference sequence ID because its type is %s", this.type.toString()));
        }
        return this.referenceContextID;
    }

    public boolean isUnmappedUnplaced() {
        return this.type == ReferenceContextType.UNMAPPED_UNPLACED_TYPE;
    }

    public boolean isMultiRef() {
        return this.type == ReferenceContextType.MULTIPLE_REFERENCE_TYPE;
    }

    public boolean isMappedSingleRef() {
        return this.type == ReferenceContextType.SINGLE_REFERENCE_TYPE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReferenceContext that = (ReferenceContext)o;
        if (this.referenceContextID != that.referenceContextID) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.referenceContextID;
        return result;
    }

    @Override
    public int compareTo(ReferenceContext o) {
        return Integer.compare(this.referenceContextID, o.referenceContextID);
    }

    public String toString() {
        switch (this.referenceContextID) {
            case -2: {
                return "MULTIPLE_REFERENCE";
            }
            case -1: {
                return "UNMAPPED_UNPLACED";
            }
        }
        return "SINGLE_REFERENCE: " + this.referenceContextID;
    }
}

