require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_NET80211_IEEE80211_NETBSD_H_)) {
    eval 'sub _NET80211_IEEE80211_NETBSD_H_ () {1;}' unless defined(&_NET80211_IEEE80211_NETBSD_H_);
    if(defined(&_KERNEL)) {
	eval 'sub IASSERT {
	    my($__cond, $__complaint) = @_;
    	    eval q( &do {  &if (!($__cond))  &panic $__complaint ; }  &while ( 0));
	}' unless defined(&IASSERT);
	eval 'sub IEEE80211_LOCK_INIT_IMPL {
	    my($_ic, $_name, $_member) = @_;
    	    eval q( &mutex_init(($_ic)->$_member,  &MUTEX_DEFAULT,  &IPL_NET));
	}' unless defined(&IEEE80211_LOCK_INIT_IMPL);
	eval 'sub IEEE80211_LOCK_IMPL {
	    my($_ic, $_member) = @_;
    	    eval q( &mutex_enter(($_ic)->$_member));
	}' unless defined(&IEEE80211_LOCK_IMPL);
	eval 'sub IEEE80211_IS_LOCKED_IMPL {
	    my($_ic, $_member) = @_;
    	    eval q( &mutex_owned(($_ic)->$_member));
	}' unless defined(&IEEE80211_IS_LOCKED_IMPL);
	eval 'sub IEEE80211_UNLOCK_IMPL {
	    my($_ic, $_member) = @_;
    	    eval q( &mutex_exit(($_ic)->$_member));
	}' unless defined(&IEEE80211_UNLOCK_IMPL);
	eval 'sub IEEE80211_LOCK_ASSERT_IMPL {
	    my($_ic, $_member) = @_;
    	    eval q( &IASSERT( &mutex_owned(($_ic)->$_member), (\\"%s: IEEE80211_LOCK not held\\",  &__func__)));
	}' unless defined(&IEEE80211_LOCK_ASSERT_IMPL);
	eval 'sub IEEE80211_LOCK_DESTROY_IMPL {
	    my($_ic, $_member) = @_;
    	    eval q( &mutex_destroy(($_ic)->$_member));
	}' unless defined(&IEEE80211_LOCK_DESTROY_IMPL);
	eval 'sub IEEE80211_BEACON_LOCK_INIT {
	    my($_ic, $_name) = @_;
    	    eval q( &IEEE80211_LOCK_INIT_IMPL($_ic, $_name,  &ic_beaconlock));
	}' unless defined(&IEEE80211_BEACON_LOCK_INIT);
	eval 'sub IEEE80211_BEACON_LOCK_DESTROY {
	    my($_ic) = @_;
    	    eval q( &IEEE80211_LOCK_DESTROY_IMPL($_ic,  &ic_beaconlock));
	}' unless defined(&IEEE80211_BEACON_LOCK_DESTROY);
	eval 'sub IEEE80211_BEACON_LOCK {
	    my($_ic) = @_;
    	    eval q( &IEEE80211_LOCK_IMPL($_ic,  &ic_beaconlock));
	}' unless defined(&IEEE80211_BEACON_LOCK);
	eval 'sub IEEE80211_BEACON_UNLOCK {
	    my($_ic) = @_;
    	    eval q( &IEEE80211_UNLOCK_IMPL($_ic,  &ic_beaconlock));
	}' unless defined(&IEEE80211_BEACON_UNLOCK);
	eval 'sub IEEE80211_BEACON_LOCK_ASSERT {
	    my($_ic) = @_;
    	    eval q( &IEEE80211_LOCK_ASSERT_IMPL($_ic,  &ic_beaconlock));
	}' unless defined(&IEEE80211_BEACON_LOCK_ASSERT);
	eval 'sub IEEE80211_NODE_LOCK_INIT {
	    my($_nt, $_name) = @_;
    	    eval q( &IEEE80211_LOCK_INIT_IMPL($_nt, $_name,  &nt_nodelock));
	}' unless defined(&IEEE80211_NODE_LOCK_INIT);
	eval 'sub IEEE80211_NODE_LOCK_DESTROY {
	    my($_nt) = @_;
    	    eval q( &IEEE80211_LOCK_DESTROY_IMPL($_nt,  &nt_nodelock));
	}' unless defined(&IEEE80211_NODE_LOCK_DESTROY);
	eval 'sub IEEE80211_NODE_LOCK {
	    my($_nt) = @_;
    	    eval q( &IEEE80211_LOCK_IMPL($_nt,  &nt_nodelock));
	}' unless defined(&IEEE80211_NODE_LOCK);
	eval 'sub IEEE80211_NODE_IS_LOCKED {
	    my($_nt) = @_;
    	    eval q( &IEEE80211_IS_LOCKED_IMPL($_nt,  &nt_nodelock));
	}' unless defined(&IEEE80211_NODE_IS_LOCKED);
	eval 'sub IEEE80211_NODE_UNLOCK {
	    my($_nt) = @_;
    	    eval q( &IEEE80211_UNLOCK_IMPL($_nt,  &nt_nodelock));
	}' unless defined(&IEEE80211_NODE_UNLOCK);
	eval 'sub IEEE80211_NODE_LOCK_ASSERT {
	    my($_nt) = @_;
    	    eval q( &IEEE80211_LOCK_ASSERT_IMPL($_nt,  &nt_nodelock));
	}' unless defined(&IEEE80211_NODE_LOCK_ASSERT);
	eval 'sub IEEE80211_SCAN_LOCK_INIT {
	    my($_nt, $_name) = @_;
    	    eval q( &IEEE80211_LOCK_INIT_IMPL($_nt, $_name,  &nt_scanlock));
	}' unless defined(&IEEE80211_SCAN_LOCK_INIT);
	eval 'sub IEEE80211_SCAN_LOCK_DESTROY {
	    my($_nt) = @_;
    	    eval q( &IEEE80211_LOCK_DESTROY_IMPL($_nt,  &nt_scanlock));
	}' unless defined(&IEEE80211_SCAN_LOCK_DESTROY);
	eval 'sub IEEE80211_SCAN_LOCK {
	    my($_nt) = @_;
    	    eval q( &IEEE80211_LOCK_IMPL($_nt,  &nt_scanlock));
	}' unless defined(&IEEE80211_SCAN_LOCK);
	eval 'sub IEEE80211_SCAN_UNLOCK {
	    my($_nt) = @_;
    	    eval q( &IEEE80211_UNLOCK_IMPL($_nt,  &nt_scanlock));
	}' unless defined(&IEEE80211_SCAN_UNLOCK);
	eval 'sub IEEE80211_SCAN_LOCK_ASSERT {
	    my($_nt) = @_;
    	    eval q( &IEEE80211_LOCK_ASSERT_IMPL($_nt,  &nt_scanlock));
	}' unless defined(&IEEE80211_SCAN_LOCK_ASSERT);
	eval 'sub IEEE80211_NODE_SAVEQ_INIT {
	    my($_ni, $_name) = @_;
    	    eval q( &do { ($_ni)-> ($ni_savedq->{ifq_maxlen}) =  &IEEE80211_PS_MAX_QUEUE; }  &while (0));
	}' unless defined(&IEEE80211_NODE_SAVEQ_INIT);
	eval 'sub IEEE80211_NODE_SAVEQ_DESTROY {
	    my($_ni) = @_;
    	    eval q();
	}' unless defined(&IEEE80211_NODE_SAVEQ_DESTROY);
	eval 'sub IEEE80211_NODE_SAVEQ_QLEN {
	    my($_ni) = @_;
    	    eval q((($_ni)-> ($ni_savedq->{ifq_len})));
	}' unless defined(&IEEE80211_NODE_SAVEQ_QLEN);
	eval 'sub IEEE80211_NODE_SAVEQ_LOCK {
	    my($_ni) = @_;
    	    eval q();
	}' unless defined(&IEEE80211_NODE_SAVEQ_LOCK);
	eval 'sub IEEE80211_NODE_SAVEQ_UNLOCK {
	    my($_ni) = @_;
    	    eval q();
	}' unless defined(&IEEE80211_NODE_SAVEQ_UNLOCK);
	eval 'sub IEEE80211_NODE_SAVEQ_DEQUEUE {
	    my($_ni, $_m, $_qlen) = @_;
    	    eval q( &do {  &IEEE80211_NODE_SAVEQ_LOCK($_ni);  &IF_DEQUEUE(($_ni)-> &ni_savedq, $_m); ($_qlen) =  &IEEE80211_NODE_SAVEQ_QLEN($_ni);  &IEEE80211_NODE_SAVEQ_UNLOCK($_ni); }  &while (0));
	}' unless defined(&IEEE80211_NODE_SAVEQ_DEQUEUE);
	eval 'sub IEEE80211_NODE_SAVEQ_DRAIN {
	    my($_ni, $_qlen) = @_;
    	    eval q( &do {  &IEEE80211_NODE_SAVEQ_LOCK($_ni); ($_qlen) =  &IEEE80211_NODE_SAVEQ_QLEN($_ni);  &IF_PURGE(($_ni)-> &ni_savedq);  &IEEE80211_NODE_SAVEQ_UNLOCK($_ni); }  &while (0));
	}' unless defined(&IEEE80211_NODE_SAVEQ_DRAIN);
	eval 'sub _IEEE80211_NODE_SAVEQ_DEQUEUE_HEAD {
	    my($_ni, $_m) = @_;
    	    eval q( &do {  &IF_DEQUEUE(($_ni)-> &ni_savedq,  &m); }  &while (0));
	}' unless defined(&_IEEE80211_NODE_SAVEQ_DEQUEUE_HEAD);
	eval 'sub _IEEE80211_NODE_SAVEQ_ENQUEUE {
	    my($_ni, $_m, $_qlen, $_age) = @_;
    	    eval q( &do { ($_m)-> &m_nextpkt =  &NULL;  &if (($_ni)-> ($ni_savedq->{ifq_tail}) !=  &NULL) { $_age -=  &M_AGE_GET(($_ni)-> ($ni_savedq->{ifq_tail})); ($_ni)-> ($ni_savedq->{ifq_tail}->{m_nextpkt}) = ($_m); }  &else { ($_ni)-> ($ni_savedq->{ifq_head}) = ($_m); }  &M_AGE_SET($_m, $_age); ($_ni)-> ($ni_savedq->{ifq_tail}) = ($_m); ($_qlen) = ++($_ni)-> ($ni_savedq->{ifq_len}); }  &while (0));
	}' unless defined(&_IEEE80211_NODE_SAVEQ_ENQUEUE);
	eval 'sub ACL_LOCK_INIT {
	    my($_as, $_name) = @_;
    	    eval q( &IEEE80211_LOCK_INIT_IMPL($_as, $_name,  &as_lock));
	}' unless defined(&ACL_LOCK_INIT);
	eval 'sub ACL_LOCK_DESTROY {
	    my($_as) = @_;
    	    eval q( &IEEE80211_LOCK_DESTROY_IMPL($_as,  &as_lock));
	}' unless defined(&ACL_LOCK_DESTROY);
	eval 'sub ACL_LOCK {
	    my($_as) = @_;
    	    eval q( &IEEE80211_LOCK_IMPL($_as,  &as_lock));
	}' unless defined(&ACL_LOCK);
	eval 'sub ACL_UNLOCK {
	    my($_as) = @_;
    	    eval q( &IEEE80211_UNLOCK_IMPL($_as,  &as_lock));
	}' unless defined(&ACL_UNLOCK);
	eval 'sub ACL_LOCK_ASSERT {
	    my($_as) = @_;
    	    eval q( &IEEE80211_LOCK_ASSERT_IMPL($_as,  &as_lock));
	}' unless defined(&ACL_LOCK_ASSERT);
	eval 'sub M_PWR_SAV () { &M_PROTO1;}' unless defined(&M_PWR_SAV);
	eval 'sub M_MORE_DATA () { &M_LINK3;}' unless defined(&M_MORE_DATA);
	eval 'sub M_FRAG () { &M_LINK4;}' unless defined(&M_FRAG);
	eval 'sub M_FIRSTFRAG () { &M_LINK5;}' unless defined(&M_FIRSTFRAG);
	eval 'sub M_FF () { &M_LINK6;}' unless defined(&M_FF);
	eval 'sub M_WME_AC_MASK () {( &M_LINK1| &M_LINK2);}' unless defined(&M_WME_AC_MASK);
	eval 'sub M_WME_AC_SHIFT () {13;}' unless defined(&M_WME_AC_SHIFT);
	eval 'sub M_WME_SETAC {
	    my($m, $ac) = @_;
    	    eval q((($m)-> &m_flags = (($m)-> &m_flags &~  &M_WME_AC_MASK) | (($ac) <<  &M_WME_AC_SHIFT)));
	}' unless defined(&M_WME_SETAC);
	eval 'sub M_WME_GETAC {
	    my($m) = @_;
    	    eval q(((($m)-> &m_flags >>  &M_WME_AC_SHIFT) & 0x3));
	}' unless defined(&M_WME_GETAC);
	eval 'sub M_AGE_SET {
	    my($m,$v) = @_;
    	    eval q(( ($m->{m_pkthdr}->{csum_data}) = $v));
	}' unless defined(&M_AGE_SET);
	eval 'sub M_AGE_GET {
	    my($m) = @_;
    	    eval q(( ($m->{m_pkthdr}->{csum_data})));
	}' unless defined(&M_AGE_GET);
	eval 'sub M_AGE_SUB {
	    my($m,$adj) = @_;
    	    eval q(( ($m->{m_pkthdr}->{csum_data}) -= $adj));
	}' unless defined(&M_AGE_SUB);
    }
    eval 'sub RTM_IEEE80211_ASSOC () {100;}' unless defined(&RTM_IEEE80211_ASSOC);
    eval 'sub RTM_IEEE80211_REASSOC () {101;}' unless defined(&RTM_IEEE80211_REASSOC);
    eval 'sub RTM_IEEE80211_DISASSOC () {102;}' unless defined(&RTM_IEEE80211_DISASSOC);
    eval 'sub RTM_IEEE80211_JOIN () {103;}' unless defined(&RTM_IEEE80211_JOIN);
    eval 'sub RTM_IEEE80211_LEAVE () {104;}' unless defined(&RTM_IEEE80211_LEAVE);
    eval 'sub RTM_IEEE80211_SCAN () {105;}' unless defined(&RTM_IEEE80211_SCAN);
    eval 'sub RTM_IEEE80211_REPLAY () {106;}' unless defined(&RTM_IEEE80211_REPLAY);
    eval 'sub RTM_IEEE80211_MICHAEL () {107;}' unless defined(&RTM_IEEE80211_MICHAEL);
    eval 'sub RTM_IEEE80211_REJOIN () {108;}' unless defined(&RTM_IEEE80211_REJOIN);
    if(defined(&_KERNEL)) {
	eval 'sub ticks () { &getticks();}' unless defined(&ticks);
	eval 'sub IEEE80211_CRYPTO_SETUP {
	    my($name) = @_;
    	    eval q( &static  &void $name( &void);  &__link_set_add_text( &ieee80211_funcs, $name);  &static  &void $name( &void));
	}' unless defined(&IEEE80211_CRYPTO_SETUP);
    }
}
1;
