/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class StackTraceElement
implements Serializable {
    private static final long serialVersionUID = 6992337162326171013L;
    private final String fileName;
    private final int lineNumber;
    private final String declaringClass;
    private final String methodName;
    private final transient boolean isNative;
    StackTraceElement next;
    int length;

    public final String getFileName() {
        return this.fileName;
    }

    public final int getLineNumber() {
        return this.lineNumber;
    }

    public final String getClassName() {
        return this.declaringClass;
    }

    public final String getMethodName() {
        return this.methodName;
    }

    public final boolean isNativeMethod() {
        return this.isNative;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.declaringClass != null) {
            sb.append(this.declaringClass);
            if (this.methodName != null) {
                sb.append('.');
            }
        }
        if (this.methodName != null) {
            sb.append(this.methodName);
        }
        sb.append(" (");
        if (this.fileName != null) {
            sb.append(this.fileName);
        } else {
            sb.append(this.isNative ? "Native Method" : "Unknown Source");
        }
        if (this.lineNumber >= 0) {
            sb.append(':').append(this.lineNumber);
        }
        sb.append(')');
        return sb.toString();
    }

    public final boolean equals(Object o) {
        if (!(o instanceof StackTraceElement)) {
            return false;
        }
        StackTraceElement e = (StackTraceElement)o;
        boolean bl = false;
        if (StackTraceElement.equals(this.fileName, e.fileName) && this.lineNumber == e.lineNumber && StackTraceElement.equals(this.declaringClass, e.declaringClass) && StackTraceElement.equals(this.methodName, e.methodName)) {
            bl = true;
        }
        return bl;
    }

    public final int hashCode() {
        return StackTraceElement.hashCode(this.fileName) ^ this.lineNumber ^ StackTraceElement.hashCode(this.declaringClass) ^ StackTraceElement.hashCode(this.methodName);
    }

    private static final boolean equals(Object o1, Object o2) {
        boolean bl;
        if (o1 == null) {
            bl = false;
            if (o2 == null) {
                bl = true;
            }
        } else {
            bl = o1.equals(o2);
        }
        return bl;
    }

    private static final int hashCode(Object o) {
        int n = 0;
        if (o != null) {
            n = o.hashCode();
        }
        return n;
    }

    StackTraceElement(String fileName, int lineNumber, String className, String methodName, boolean isNative) {
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.declaringClass = className.replace('/', '.');
        this.methodName = methodName.equals("<init>") ? className.substring(className.lastIndexOf(47) + 1) : (methodName.equals("<clinit>") ? "static{}" : methodName);
        this.isNative = isNative;
    }
}

