/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.undo;

import java.io.Serializable;
import javax.swing.UIManager;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class AbstractUndoableEdit
implements UndoableEdit,
Serializable {
    static final long serialVersionUID = 580150227676302096L;
    protected static final String UndoName = "Undo";
    protected static final String RedoName = "Redo";
    private boolean hasBeenDone = true;
    private boolean alive = true;

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        this.hasBeenDone = false;
    }

    public boolean canUndo() {
        boolean bl = false;
        if (this.alive && this.hasBeenDone) {
            bl = true;
        }
        return bl;
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        this.hasBeenDone = true;
    }

    public boolean canRedo() {
        boolean bl = false;
        if (this.alive && !this.hasBeenDone) {
            bl = true;
        }
        return bl;
    }

    public void die() {
        this.alive = false;
    }

    public boolean addEdit(UndoableEdit edit) {
        return false;
    }

    public boolean replaceEdit(UndoableEdit edit) {
        return false;
    }

    public boolean isSignificant() {
        return true;
    }

    public String getPresentationName() {
        return "";
    }

    public String getUndoPresentationName() {
        String pres;
        String msg = UIManager.getString("AbstractUndoableEdit.undoText");
        if (msg == null) {
            msg = UndoName;
        }
        if ((pres = this.getPresentationName()) == null || pres.length() == 0) {
            return msg;
        }
        return msg + ' ' + pres;
    }

    public String getRedoPresentationName() {
        String pres;
        String msg = UIManager.getString("AbstractUndoableEdit.redoText");
        if (msg == null) {
            msg = RedoName;
        }
        if ((pres = this.getPresentationName()) == null || pres.length() == 0) {
            return msg;
        }
        return msg + ' ' + pres;
    }

    public String toString() {
        return super.toString() + " hasBeenDone: " + this.hasBeenDone + " alive: " + this.alive;
    }
}

