/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.event.EventManager;
import gnu.classpath.jdwp.event.EventRequest;
import gnu.classpath.jdwp.event.filters.ClassExcludeFilter;
import gnu.classpath.jdwp.event.filters.ClassMatchFilter;
import gnu.classpath.jdwp.event.filters.ClassOnlyFilter;
import gnu.classpath.jdwp.event.filters.ConditionalFilter;
import gnu.classpath.jdwp.event.filters.CountFilter;
import gnu.classpath.jdwp.event.filters.ExceptionOnlyFilter;
import gnu.classpath.jdwp.event.filters.FieldOnlyFilter;
import gnu.classpath.jdwp.event.filters.IEventFilter;
import gnu.classpath.jdwp.event.filters.InstanceOnlyFilter;
import gnu.classpath.jdwp.event.filters.LocationOnlyFilter;
import gnu.classpath.jdwp.event.filters.StepFilter;
import gnu.classpath.jdwp.event.filters.ThreadOnlyFilter;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.id.ReferenceTypeId;
import gnu.classpath.jdwp.id.ThreadId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.util.JdwpString;
import gnu.classpath.jdwp.util.Location;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class EventRequestCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer byteBuffer, DataOutputStream dataOutputStream, byte by) throws JdwpException {
        try {
            switch (by) {
                case 1: {
                    this.executeSet(byteBuffer, dataOutputStream);
                    break;
                }
                case 2: {
                    this.executeClear(byteBuffer, dataOutputStream);
                    break;
                }
                case 3: {
                    this.executeClearAllBreakpoints(byteBuffer, dataOutputStream);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + by + " not found in EventRequest Reference Command Set.");
                }
            }
        }
        catch (IOException iOException) {
            throw new JdwpInternalErrorException(iOException);
        }
        return false;
    }

    private final void executeSet(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        byte by = byteBuffer.get();
        byte by2 = byteBuffer.get();
        int n = byteBuffer.getInt();
        EventRequest eventRequest = new EventRequest(by, by2);
        IEventFilter iEventFilter = null;
        int n2 = 0;
        while (n2 < n) {
            byte by3 = byteBuffer.get();
            switch (by3) {
                case 1: {
                    iEventFilter = new CountFilter(byteBuffer.getInt());
                    break;
                }
                case 2: {
                    iEventFilter = new ConditionalFilter(this.idMan.readObjectId(byteBuffer));
                    break;
                }
                case 3: {
                    iEventFilter = new ThreadOnlyFilter((ThreadId)this.idMan.readObjectId(byteBuffer));
                    break;
                }
                case 4: {
                    iEventFilter = new ClassOnlyFilter(this.idMan.readReferenceTypeId(byteBuffer));
                    break;
                }
                case 5: {
                    iEventFilter = new ClassMatchFilter(JdwpString.readString(byteBuffer));
                    break;
                }
                case 6: {
                    iEventFilter = new ClassExcludeFilter(JdwpString.readString(byteBuffer));
                    break;
                }
                case 7: {
                    iEventFilter = new LocationOnlyFilter(new Location(byteBuffer));
                    break;
                }
                case 8: {
                    long l = byteBuffer.getLong();
                    ReferenceTypeId referenceTypeId = l == 0L ? null : this.idMan.readReferenceTypeId(byteBuffer);
                    int n3 = 0;
                    if (byteBuffer.get() == 0) {
                        n3 = 1;
                    }
                    boolean bl = 1 - n3;
                    int n4 = 0;
                    if (byteBuffer.get() == 0) {
                        n4 = 1;
                    }
                    boolean bl2 = 1 - n4;
                    iEventFilter = new ExceptionOnlyFilter(referenceTypeId, bl, bl2);
                    break;
                }
                case 9: {
                    ReferenceTypeId referenceTypeId = this.idMan.readReferenceTypeId(byteBuffer);
                    ReferenceTypeId referenceTypeId2 = this.idMan.readReferenceTypeId(byteBuffer);
                    iEventFilter = new FieldOnlyFilter(referenceTypeId, referenceTypeId2);
                    break;
                }
                case 10: {
                    ThreadId threadId = (ThreadId)this.idMan.readObjectId(byteBuffer);
                    int n5 = byteBuffer.getInt();
                    int n6 = byteBuffer.getInt();
                    iEventFilter = new StepFilter(threadId, n5, n6);
                    break;
                }
                case 11: {
                    ObjectId objectId = this.idMan.readObjectId(byteBuffer);
                    iEventFilter = new InstanceOnlyFilter(objectId);
                    break;
                }
                default: {
                    throw new NotImplementedException("modKind " + by3 + " is not implemented.");
                }
            }
            eventRequest.addFilter(iEventFilter);
            ++n2;
        }
        EventManager.getDefault().requestEvent(eventRequest);
        dataOutputStream.writeInt(eventRequest.getId());
    }

    private final void executeClear(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        byte by = byteBuffer.get();
        int n = byteBuffer.getInt();
        EventManager.getDefault().deleteRequest(by, n);
    }

    private final void executeClearAllBreakpoints(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        byte by = byteBuffer.get();
        EventManager.getDefault().clearRequests(by);
    }
}

