/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.Enumerated;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class Alert
implements Constructed {
    private final Level level;
    private final Description description;

    static final Alert read(InputStream inputStream) throws IOException {
        Level level = Level.read(inputStream);
        Description description = Description.read(inputStream);
        return new Alert(level, description);
    }

    static final Alert forName(String string) {
        if (string == null) {
            return new Alert(Level.FATAL, Description.INTERNAL_ERROR);
        }
        Description description = Description.INTERNAL_ERROR;
        if (string.equals("close_notify")) {
            description = Description.CLOSE_NOTIFY;
        } else if (string.equals("unexpected_message")) {
            description = Description.UNEXPECTED_MESSAGE;
        } else if (string.equals("bad_record_mac")) {
            description = Description.BAD_RECORD_MAC;
        } else if (string.equals("DECRYPTION_FAILED")) {
            description = Description.DECRYPTION_FAILED;
        } else if (string.equals("record_overflow")) {
            description = Description.RECORD_OVERFLOW;
        } else if (string.equals("decompression_failure")) {
            description = Description.DECOMPRESSION_FAILURE;
        } else if (string.equals("handshake_failure")) {
            description = Description.HANDSHAKE_FAILURE;
        } else if (string.equals("no_certificate")) {
            description = Description.NO_CERTIFICATE;
        } else if (string.equals("bad_certificate")) {
            description = Description.BAD_CERTIFICATE;
        } else if (string.equals("unsupported_certificate")) {
            description = Description.UNSUPPORTED_CERTIFICATE;
        } else if (string.equals("certificate_revoked")) {
            description = Description.CERTIFICATE_REVOKED;
        } else if (string.equals("certificate_expired")) {
            description = Description.CERTIFICATE_EXPIRED;
        } else if (string.equals("certificate_unknown")) {
            description = Description.CERTIFICATE_UNKNOWN;
        } else if (string.equals("illegal_parameter")) {
            description = Description.ILLEGAL_PARAMETER;
        } else if (string.equals("unknown_ca")) {
            description = Description.UNKNOWN_CA;
        } else if (string.equals("access_denied")) {
            description = Description.ACCESS_DENIED;
        } else if (string.equals("decode_error")) {
            description = Description.DECODE_ERROR;
        } else if (string.equals("decrypt_error")) {
            description = Description.DECRYPT_ERROR;
        } else if (string.equals("export_restriction")) {
            description = Description.EXPORT_RESTRICTION;
        } else if (string.equals("protocol_version")) {
            description = Description.PROTOCOL_VERSION;
        } else if (string.equals("insufficient_security")) {
            description = Description.INSUFFICIENT_SECURITY;
        } else if (string.equals("internal_error")) {
            description = Description.INTERNAL_ERROR;
        } else if (string.equals("user_canceled")) {
            description = Description.USER_CANCELED;
        } else if (string.equals("no_renegotiation")) {
            description = Description.NO_RENEGOTIATION;
        } else if (string.equals("unsupported_extension")) {
            description = Description.UNSUPPORTED_EXTENSION;
        } else if (string.equals("certificate_unobtainable")) {
            description = Description.CERTIFICATE_UNOBTAINABLE;
        } else if (string.equals("unrecognized_name")) {
            description = Description.UNRECOGNIZED_NAME;
        } else if (string.equals("bad_certificate_status_response")) {
            description = Description.BAD_CERTIFICATE_STATUS_RESPONSE;
        } else if (string.equals("bad_certificate_hash_value")) {
            description = Description.BAD_CERTIFICATE_HASH_VALUE;
        } else if (string.equals("unknown_srp_username")) {
            description = Description.UNKNOWN_SRP_USERNAME;
        } else if (string.equals("missing_srp_username")) {
            description = Description.MISSING_SRP_USERNAME;
        }
        return new Alert(Level.FATAL, description);
    }

    public final void write(OutputStream outputStream) throws IOException {
        outputStream.write((byte)this.level.getValue());
        outputStream.write((byte)this.description.getValue());
    }

    final byte[] getEncoded() {
        return new byte[]{(byte)this.level.getValue(), (byte)this.description.getValue()};
    }

    final Level getLevel() {
        return this.level;
    }

    final Description getDescription() {
        return this.description;
    }

    public final String toString() {
        String string = System.getProperty("line.separator");
        return "struct {" + string + "  level = " + this.level + ';' + string + "  description = " + this.description + ';' + string + "} Alert;" + string;
    }

    Alert(Level level, Description description) {
        this.level = level;
        this.description = description;
    }

    static final class Level
    implements Enumerated {
        static final Level WARNING = new Level(1);
        static final Level FATAL = new Level(2);
        private final int value;

        static final Level read(InputStream inputStream) throws IOException {
            int n = inputStream.read();
            if (n == -1) {
                throw new EOFException("unexpected end of stream");
            }
            switch (n & 0xFF) {
                case 1: {
                    return WARNING;
                }
                case 2: {
                    return FATAL;
                }
            }
            return new Level(n);
        }

        public final byte[] getEncoded() {
            return new byte[]{(byte)this.value};
        }

        public final int getValue() {
            return this.value;
        }

        public final String toString() {
            switch (this.value) {
                case 1: {
                    return "warning";
                }
                case 2: {
                    return "fatal";
                }
            }
            return "unknown(" + this.value + ')';
        }

        private Level(int n) {
            this.value = n;
        }
    }

    static final class Description
    implements Enumerated {
        static final Description CLOSE_NOTIFY = new Description(0);
        static final Description UNEXPECTED_MESSAGE = new Description(10);
        static final Description BAD_RECORD_MAC = new Description(20);
        static final Description DECRYPTION_FAILED = new Description(21);
        static final Description RECORD_OVERFLOW = new Description(22);
        static final Description DECOMPRESSION_FAILURE = new Description(30);
        static final Description HANDSHAKE_FAILURE = new Description(40);
        static final Description NO_CERTIFICATE = new Description(41);
        static final Description BAD_CERTIFICATE = new Description(42);
        static final Description UNSUPPORTED_CERTIFICATE = new Description(43);
        static final Description CERTIFICATE_REVOKED = new Description(44);
        static final Description CERTIFICATE_EXPIRED = new Description(45);
        static final Description CERTIFICATE_UNKNOWN = new Description(46);
        static final Description ILLEGAL_PARAMETER = new Description(47);
        static final Description UNKNOWN_CA = new Description(48);
        static final Description ACCESS_DENIED = new Description(49);
        static final Description DECODE_ERROR = new Description(50);
        static final Description DECRYPT_ERROR = new Description(51);
        static final Description EXPORT_RESTRICTION = new Description(60);
        static final Description PROTOCOL_VERSION = new Description(70);
        static final Description INSUFFICIENT_SECURITY = new Description(71);
        static final Description INTERNAL_ERROR = new Description(80);
        static final Description USER_CANCELED = new Description(90);
        static final Description NO_RENEGOTIATION = new Description(100);
        static final Description UNSUPPORTED_EXTENSION = new Description(110);
        static final Description CERTIFICATE_UNOBTAINABLE = new Description(111);
        static final Description UNRECOGNIZED_NAME = new Description(112);
        static final Description BAD_CERTIFICATE_STATUS_RESPONSE = new Description(113);
        static final Description BAD_CERTIFICATE_HASH_VALUE = new Description(114);
        static final Description UNKNOWN_SRP_USERNAME = new Description(120);
        static final Description MISSING_SRP_USERNAME = new Description(121);
        private final int value;

        static final Description read(InputStream inputStream) throws IOException {
            int n = inputStream.read();
            if (n == -1) {
                throw new EOFException("unexpected end of input stream");
            }
            switch (n) {
                case 0: {
                    return CLOSE_NOTIFY;
                }
                case 10: {
                    return UNEXPECTED_MESSAGE;
                }
                case 20: {
                    return BAD_RECORD_MAC;
                }
                case 21: {
                    return DECRYPTION_FAILED;
                }
                case 22: {
                    return RECORD_OVERFLOW;
                }
                case 30: {
                    return DECOMPRESSION_FAILURE;
                }
                case 40: {
                    return HANDSHAKE_FAILURE;
                }
                case 41: {
                    return NO_CERTIFICATE;
                }
                case 42: {
                    return BAD_CERTIFICATE;
                }
                case 43: {
                    return UNSUPPORTED_CERTIFICATE;
                }
                case 44: {
                    return CERTIFICATE_REVOKED;
                }
                case 45: {
                    return CERTIFICATE_EXPIRED;
                }
                case 46: {
                    return CERTIFICATE_UNKNOWN;
                }
                case 47: {
                    return ILLEGAL_PARAMETER;
                }
                case 48: {
                    return UNKNOWN_CA;
                }
                case 49: {
                    return ACCESS_DENIED;
                }
                case 50: {
                    return DECODE_ERROR;
                }
                case 51: {
                    return DECRYPT_ERROR;
                }
                case 60: {
                    return EXPORT_RESTRICTION;
                }
                case 70: {
                    return PROTOCOL_VERSION;
                }
                case 71: {
                    return INSUFFICIENT_SECURITY;
                }
                case 80: {
                    return INTERNAL_ERROR;
                }
                case 90: {
                    return USER_CANCELED;
                }
                case 100: {
                    return NO_RENEGOTIATION;
                }
                case 120: {
                    return UNKNOWN_SRP_USERNAME;
                }
                case 121: {
                    return MISSING_SRP_USERNAME;
                }
            }
            return new Description(n);
        }

        public final byte[] getEncoded() {
            return new byte[]{(byte)this.value};
        }

        public final int getValue() {
            return this.value;
        }

        public final String toString() {
            switch (this.value) {
                case 0: {
                    return "close_notify";
                }
                case 10: {
                    return "unexpected_message";
                }
                case 20: {
                    return "bad_record_mac";
                }
                case 21: {
                    return "decryption_failed";
                }
                case 22: {
                    return "record_overflow";
                }
                case 30: {
                    return "decompression_failure";
                }
                case 40: {
                    return "handshake_failure";
                }
                case 42: {
                    return "bad_certificate";
                }
                case 43: {
                    return "unsupported_certificate";
                }
                case 44: {
                    return "certificate_revoked";
                }
                case 45: {
                    return "certificate_expired";
                }
                case 46: {
                    return "certificate_unknown";
                }
                case 47: {
                    return "illegal_parameter";
                }
                case 48: {
                    return "unknown_ca";
                }
                case 49: {
                    return "access_denied";
                }
                case 50: {
                    return "decode_error";
                }
                case 51: {
                    return "decrypt_error";
                }
                case 60: {
                    return "export_restriction";
                }
                case 70: {
                    return "protocol_version";
                }
                case 71: {
                    return "insufficient_security";
                }
                case 80: {
                    return "internal_error";
                }
                case 90: {
                    return "user_canceled";
                }
                case 100: {
                    return "no_renegotiation";
                }
                case 110: {
                    return "unsupported_extension";
                }
                case 111: {
                    return "certificate_unobtainable";
                }
                case 112: {
                    return "unrecognized_name";
                }
                case 113: {
                    return "bad_certificate_status_response";
                }
                case 114: {
                    return "bad_certificate_hash_value";
                }
                case 120: {
                    return "unknown_srp_username";
                }
                case 121: {
                    return "missing_srp_username";
                }
            }
            return "unknown(" + this.value + ')';
        }

        private Description(int n) {
            this.value = n;
        }
    }
}

