/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Session;
import gnu.javax.net.ssl.provider.Util;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;

class SessionContext
implements SSLSessionContext {
    protected final HashMap sessions = new HashMap();
    protected int cacheSize = 0;
    protected int timeout;

    public synchronized Enumeration getIds() {
        Vector vector = new Vector();
        Iterator iterator = this.sessions.keySet().iterator();
        while (iterator.hasNext()) {
            Session.ID iD = (Session.ID)iterator.next();
            vector.add(iD.getId());
        }
        return vector.elements();
    }

    public synchronized SSLSession getSession(byte[] byArray) {
        Session session = (Session)this.sessions.get(new Session.ID(byArray));
        if (session == null) {
            return null;
        }
        long l = System.currentTimeMillis() - session.getLastAccessedTime();
        if ((int)(l / 1000L) > this.timeout) {
            this.removeSession(session.sessionId);
            session.invalidate();
            return null;
        }
        if (!session.valid) {
            this.removeSession(session.sessionId);
            session.invalidate();
            return null;
        }
        return session;
    }

    public int getSessionCacheSize() {
        return this.cacheSize;
    }

    public void setSessionCacheSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.cacheSize = n;
    }

    public int getSessionTimeout() {
        return this.timeout;
    }

    public void setSessionTimeout(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.timeout = n;
    }

    public String toString() {
        return this.sessions.keySet().toString();
    }

    synchronized boolean addSession(Session.ID iD, Session session) {
        if (this.sessions.containsKey(iD)) {
            return false;
        }
        if (this.cacheSize > 0 && this.sessions.size() > this.cacheSize) {
            boolean bl = false;
            Iterator iterator = this.sessions.values().iterator();
            while (iterator.hasNext()) {
                Session session2 = (Session)iterator.next();
                long l = System.currentTimeMillis() - session2.getCreationTime();
                if (!session2.valid) {
                    this.removeSession(session.sessionId);
                    bl = true;
                    continue;
                }
                if ((int)(l / 1000L) <= this.timeout) continue;
                this.removeSession(session.sessionId);
                bl = true;
            }
            if (bl) {
                this.sessions.put(iD, session);
                session.context = this;
                session.sessionId = iD;
                return true;
            }
            return false;
        }
        this.sessions.put(iD, session);
        session.context = this;
        session.sessionId = iD;
        return true;
    }

    synchronized boolean containsSessionID(Session.ID iD) {
        Session session = (Session)this.sessions.get(iD);
        if (session == null) {
            return false;
        }
        long l = System.currentTimeMillis() - session.getCreationTime();
        if (!session.valid || (int)(l / 1000L) > this.timeout) {
            this.removeSession(iD);
            return false;
        }
        return true;
    }

    synchronized boolean removeSession(Session.ID iD) {
        boolean bl = false;
        if (this.sessions.remove(iD) != null) {
            bl = true;
        }
        return bl;
    }

    void notifyAccess(Session session) {
    }

    SessionContext() {
        try {
            this.timeout = Integer.parseInt(Util.getSecurityProperty("jessie.session.timeout"));
        }
        catch (Exception exception) {
            this.timeout = 86400;
        }
    }
}

