/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509Extension;
import java.util.Date;

public abstract class X509CRLEntry
implements X509Extension {
    public boolean equals(Object object) {
        if (object instanceof X509CRLEntry) {
            try {
                X509CRLEntry x509CRLEntry = (X509CRLEntry)object;
                if (this.getEncoded().length != x509CRLEntry.getEncoded().length) {
                    return false;
                }
                byte[] byArray = this.getEncoded();
                byte[] byArray2 = x509CRLEntry.getEncoded();
                int n = 0;
                while (n < byArray.length) {
                    if (byArray[n] != byArray2[n]) {
                        return false;
                    }
                    ++n;
                }
            }
            catch (CRLException cRLException) {
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public abstract byte[] getEncoded() throws CRLException;

    public abstract BigInteger getSerialNumber();

    public abstract Date getRevocationDate();

    public abstract boolean hasExtensions();

    public abstract String toString();
}

