/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_H__
#define __SG_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtkextra/gtkextra.h>

#include "widgets/sg_widgets_enums.h" 
#include "widgets/sg_entry.h"
#include "widgets/sg_worksheet.h"
#include "widgets/sg_worksheet_window.h"
#include "widgets/sg_matrix.h"
#include "widgets/sg_plot.h"
#include "widgets/sg_plot_window.h"
#include "widgets/sg_layer.h"
#include "widgets/sg_stock.h"
#include "widgets/sg_clipboard.h"
#include "widgets/sg_list.h"
#include "widgets/sg_misc.h"
#include "widgets/sg_dialog.h"
#include "widgets/sg_toggle_combos.h"
#include "widgets/sg_toolbox.h"

#include "sg_python.h" 
#include "sg_config.h" 
#include "sg_features.h" 
#include "sg_dataset.h"
#include "sg_layer_control.h"
#include "sg_file.h"
#include "sg_locale.h"

#include "sg_plugin.h"
#include "sg_plugin_menu.h"
#include "sg_plugin_iterator.h"
#include "sg_plugin_style.h"
#include "sg_plugin_file.h"
#include "sg_plugin_layer.h"
#include "sg_plugin_array.h"
#include "sg_plugin_loader.h"

/*
#define GINT(DOUBLE) ((gint)floor((DOUBLE) + 0.5)) 
*/
#define GINT(DOUBLE) (DOUBLE) 

extern GdkPixmap *icon_pixmap;
extern GdkPixmap *icon_mask;

void		sg_init					(const gchar *progname);
void 		sg_quit					(void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_H__ */
