/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import uk.ac.ic.doc.scenebeans.Null;
import uk.ac.ic.doc.scenebeans.SceneGraph;
import uk.ac.ic.doc.scenebeans.SceneGraphBase;
import uk.ac.ic.doc.scenebeans.SceneGraphProcessor;
import uk.ac.ic.doc.scenebeans.Transform;

public abstract class TransformBase
extends SceneGraphBase
implements Transform {
    private SceneGraph _child;
    private transient SceneGraph _last_drawn_child = new Null();
    private transient AffineTransform _last_drawn_transform = null;

    protected TransformBase() {
        this._child = new Null();
    }

    protected TransformBase(SceneGraph sceneGraph) {
        this._child = sceneGraph == null ? new Null() : sceneGraph;
    }

    public SceneGraph getTransformedGraph() {
        return this._child;
    }

    public void setTransformedGraph(SceneGraph sceneGraph) {
        this._child = sceneGraph == null ? new Null() : sceneGraph;
        this.setDirty(true);
    }

    public SceneGraph getLastDrawnTransformedGraph() {
        return this._last_drawn_child;
    }

    public AffineTransform getLastDrawnTransform() {
        return this._last_drawn_transform;
    }

    public void accept(SceneGraphProcessor sceneGraphProcessor) {
        sceneGraphProcessor.process(this);
    }

    public void draw(Graphics2D graphics2D) {
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = this.getTransform();
        graphics2D.transform(affineTransform2);
        this._child.draw(graphics2D);
        graphics2D.setTransform(affineTransform);
        this._last_drawn_child = this._child;
        this._last_drawn_transform = affineTransform2;
        this.setDirty(false);
    }

    public abstract AffineTransform getTransform();
}

