.\" $Header: /home/vikas/netmgt/nocol/src/doc/RCS/noclogd.8,v 1.4 1994/11/29 20:12:56 vikas Exp $
.\"
.TH NOCLOGD 8 "May 1994"
.SH NAME
noclogd \- NOCOL event logging daemon
.SH SYNOPSIS
.B noclogd
[
.B \-d
] [
.B \-e
.I output-error-filename
] [
.B \-f
.I config-filename
]
.LP
The
.I noclogd
daemon logs NOCOL events (as text lines) to the files specified in the config
file, based
on the loglevels specified. Alternately, it can open a pipe to a process
and run that process instead of writing to a file (similar to 
.IR syslog ).
It only logs
.I CHANGES
in severity levels of the events.
.SH OPTIONS
.TP
.B \-d
For debug mode. Will not daemonize and writes errrors to terminal.
.TP
.B \-e 
.I <errorfile>
For writing out errors to. Default is \fI ETCDIR/noclogd.errors\fR
.TP
.B \-f 
.I <config filename>
Location of the configuration file. Default is \fI ETCDIR/noclogd.cf\fR

.SH DESCRIPTION
.LP
The
.B noclogd
daemon is the logging daemon for the NOCOL network monitoring program.
It listens on a UDP port (5354) for the various nocol monitors to send
it EVENT structures. It then logs these events (as
.I text
lines), to various output files depending of the configuration file
for the daemon. Alternatively, the output can be piped to a program
to be executed. The logging methodology is similar to the Unix
.B syslog
facility.
The format of the
.I noclogd
log lines are:
.RS
.I date
[
.I sender
]: SITE
.I sitename address
VAR
.I varname value threshold units
LEVEL
.I severity
LOGLEVEL
.I log severity
NOCOP
.I up down unknown test
.RE
.LP
Sending a HUP signal to the server closes all streams currently open, and
reopens them. This is useful if you move the old log files every night
or so.
.LP
For security purposes, only the hosts specified in the configuration file
are allowed to send log messages (see CAVEATS below).
.LP
.B NOTE:
Since an
.I event
in NOCOL is generally generated only when the severity of an event
.IR changes ,
you might not see any events logged until such a change in severity occurs
(restarting a NOCOL monitor will generate log messages- useful for testing).
.\"
.SH DESIGN CONSIDERATIONS
.LP
The following are important 'features' about
.B noclogd
that should be kept in mind while logging and running programs through it:
.RS
.TP 3
1.
Security is implemented by allowing only a select list of IP addresses
to log (specified in the configuration file). The IP address of the
host sending the packets is verified using the 
.IR recvfrom (2)
system call. Also see CAVEATS below.
.TP 3
2.
Since the sockets used are of the UDP type, datagrams can be lost if
too many events are sent to the daemon at the same time. However, since
the monitors only log an event when its severity changes, this is usually not
a problem. Additionally, there is a counter in the
.I eventlog()
call to pause for a second after logging 100 events.
.TP 3
3.
The daemon does not
.I fork(2)
off a child for each packet that comes in. It processes each event 
itself. Thus,if you are piping the output to a program 
(instead of logging to a file), then make sure that the program being 
run does its main procesing in the background and returns control to
the noclogd daemon as soon as possible.
.I i.e.
the various output programs being executed are responsible for doing
their own "fork-ing", the daemon will not do it for them, and might
lose other incoming log packets if the piped process does not release the
.I stdin
(it uses the
.IR popen (3)
call).
.TP 3
4.
The hostname on which the 
.I noclogd
daemon runs, is compiled during runtime so that the various NOCOL
monitors know the system on which the logging daemon runs. Typically,
it is easier to define this (in 
.IR noclogd.h )
as
.I noclog.your.domain
and create a CNAME for it in the nameserver.
.TP 3
5.
The server might not be running when the various monitors startup.
Hence, the library subroutine
.I eventlog()
does not try to log for RETRY_REOPEN seconds (set to 60 secs) if it has
failed to log to eventlog.
.RE
.\"
.SH CONFIG FILE
The configuration file format is:
.RS
.sp .5
.nf
# Comments begin with a # character.
#
# The following hosts are permitted to log entries to this daemon:
permithosts     127.0.0.1  128.121.50.2 128.121.50.7
permithosts     128.121.50.145
##
## Give full pathnames in filenames since the daemon changes dir.
##
## SENDER	LEVEL		LOGFILE or PIPEFILE
##
*		critical		/nocol/logs/log-critical
nsmon		error		/nocol/logs/log-error
test		warning		/nocol/logs/log-warning
*		info		/nocol/logs/log-info
#
pingmon		critical		|/nocol/bin/beeper
.fi
.RE
Comments begin with a '#' and sender names can be specified as '*' to
indicate a wildcard. Keep in mind that an event is logged to all streams
with a severity lower than its severity/loglevel. Thus, in the above example,
events with a loglevel of ERROR will be logged to all the 3 files
.I log-info, log-warning & log-error.
.\"
.SH FUTURE DEVELOPMENTS
.LP
Possible future enhancements are:
.RS
.TP 3
1.
Creating another daemon that does all the time consuming 'work' with a 
sort of queue mechanism.
.TP 3
2.
Listening on a STREAM socket also, so that some monitors (who so desire)
can open a STREAM connection and spew events down this reliable connection.
.\"
.SH CAVEATS
Logging is restricted to the hosts listed in the configuration file.
However, any user can send log messages from a permitted host, since there 
is no authentication using passwords, etc (in the same manner as
.IR syslogd ).
.\"
.SH AUTHOR
.nf
Vikas Aggarwal (vikas@navya.com)
David Wagner (wagner@phoenix.princeton.edu).
.fi
.SH SEE ALSO
netconsole(1) nocol-prog(3) perlnocol(3)
etherload(8) eventselect(8) genmon(8) noclogd(8) nocol-overview(8)
nocol-utility(8) nsmon(8) pingmon(8) portmon(8) 
tpmon(8) trapmon(8)
