/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.util.list;

import org.apache.activemq.apollo.util.list.LinkedNodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedNode<T extends LinkedNode<T>> {
    protected LinkedNodeList<T> list;
    protected T next;
    protected T prev;

    private final T getThis() {
        return (T)this;
    }

    public final T getHeadNode() {
        return this.list.head;
    }

    public final T getTailNode() {
        return ((LinkedNode)this.list.head).prev;
    }

    public final T getNext() {
        return this.isTailNode() ? null : (T)this.next;
    }

    public final T getPrevious() {
        return this.isHeadNode() ? null : (T)this.prev;
    }

    public final T getNextCircular() {
        return this.next;
    }

    public final T getPreviousCircular() {
        return this.prev;
    }

    private final void assertLinked() {
        assert (this.list != null && !this.list.isEmpty()) : "Node is not linked";
    }

    public final boolean isHeadNode() {
        this.assertLinked();
        return this.list.head == this;
    }

    public final boolean isTailNode() {
        this.assertLinked();
        return ((LinkedNode)this.list.head).prev == this;
    }

    public final void linkAfter(T node) {
        if (node == this) {
            throw new IllegalArgumentException("You cannot link to yourself");
        }
        if (((LinkedNode)node).list != null) {
            throw new IllegalArgumentException("You only insert nodes that are not in a list");
        }
        if (this.list == null) {
            throw new IllegalArgumentException("This node is not yet in a list");
        }
        ((LinkedNode)node).list = this.list;
        ((LinkedNode)node).prev = this.getThis();
        ((LinkedNode)node).next = this.next;
        ((LinkedNode)this.next).prev = node;
        this.next = node;
        ++this.list.size;
    }

    public final void linkAfter(LinkedNodeList<T> rightList) {
        if (rightList == this.list) {
            throw new IllegalArgumentException("You cannot link to yourself");
        }
        if (this.list == null) {
            throw new IllegalArgumentException("This node is not yet in a list");
        }
        Object rightHead = rightList.head;
        T rightTail = ((LinkedNode)rightList.head).prev;
        this.list.reparent(rightList);
        ((LinkedNode)rightHead).prev = this.getThis();
        ((LinkedNode)rightTail).next = this.next;
        ((LinkedNode)this.next).prev = rightTail;
        this.next = rightHead;
    }

    public final void linkBefore(T node) {
        if (node == this) {
            throw new IllegalArgumentException("You cannot link to yourself");
        }
        if (((LinkedNode)node).list != null) {
            throw new IllegalArgumentException("You only insert nodes that are not in a list");
        }
        if (this.list == null) {
            throw new IllegalArgumentException("This node is not yet in a list");
        }
        ((LinkedNode)node).list = this.list;
        ((LinkedNode)node).next = this.getThis();
        ((LinkedNode)node).prev = this.prev;
        ((LinkedNode)this.prev).next = node;
        this.prev = node;
        if (this == this.list.head) {
            this.list.head = node;
        }
        ++this.list.size;
    }

    public final void linkBefore(LinkedNodeList<T> leftList) {
        if (leftList == this.list) {
            throw new IllegalArgumentException("You cannot link to yourself");
        }
        if (this.list == null) {
            throw new IllegalArgumentException("This node is not yet in a list");
        }
        Object leftHead = leftList.head;
        T leftTail = ((LinkedNode)leftList.head).prev;
        this.list.reparent(leftList);
        ((LinkedNode)leftTail).next = this.getThis();
        ((LinkedNode)leftHead).prev = this.prev;
        ((LinkedNode)this.prev).next = leftHead;
        this.prev = leftTail;
        if (this.isHeadNode()) {
            this.list.head = leftHead;
        }
    }

    public final void linkToTail(LinkedNodeList<T> target) {
        if (this.list != null) {
            throw new IllegalArgumentException("This node is already linked to a node");
        }
        if (target.head == null) {
            target.head = this.getThis();
            this.prev = target.head;
            this.next = target.head;
            this.list = target;
            ++this.list.size;
        } else {
            ((LinkedNode)((LinkedNode)target.head).prev).linkAfter(this.getThis());
        }
    }

    public final void linkToHead(LinkedNodeList<T> target) {
        if (this.list != null) {
            throw new IllegalArgumentException("This node is already linked to a node");
        }
        if (target.head == null) {
            target.head = this.getThis();
            this.prev = target.head;
            this.next = target.head;
            this.list = target;
            ++this.list.size;
        } else {
            ((LinkedNode)target.head).linkBefore(this.getThis());
        }
    }

    public final boolean unlink() {
        if (this.list == null) {
            return false;
        }
        if (this.getThis() == this.prev) {
            this.list.head = null;
        } else {
            ((LinkedNode)this.next).prev = this.prev;
            ((LinkedNode)this.prev).next = this.next;
            if (this.isHeadNode()) {
                this.list.head = this.next;
            }
        }
        --this.list.size;
        this.list = null;
        return true;
    }

    public final LinkedNodeList<T> splitAfter() {
        if (this.isTailNode()) {
            return new LinkedNodeList();
        }
        LinkedNodeList newList = new LinkedNodeList();
        newList.head = this.next;
        ((LinkedNode)newList.head).prev = ((LinkedNode)this.list.head).prev;
        ((LinkedNode)((LinkedNode)newList.head).prev).next = newList.head;
        this.next = this.list.head;
        ((LinkedNode)this.list.head).prev = this.getThis();
        Object n = newList.head;
        ++newList.size;
        --this.list.size;
        do {
            ((LinkedNode)n).list = newList;
            n = ((LinkedNode)n).next;
            ++newList.size;
            --this.list.size;
        } while (n != newList.head);
        return newList;
    }

    public final LinkedNodeList<T> splitBefore() {
        if (this.isHeadNode()) {
            return new LinkedNodeList();
        }
        LinkedNodeList newList = new LinkedNodeList();
        newList.head = this.list.head;
        this.list.head = this.getThis();
        T newListTail = this.prev;
        this.prev = ((LinkedNode)newList.head).prev;
        ((LinkedNode)this.prev).next = this.getThis();
        ((LinkedNode)newList.head).prev = newListTail;
        ((LinkedNode)newListTail).next = newList.head;
        Object n = newList.head;
        ++newList.size;
        --this.list.size;
        do {
            ((LinkedNode)n).list = newList;
            n = ((LinkedNode)n).next;
            ++newList.size;
            --this.list.size;
        } while (n != newList.head);
        return newList;
    }

    public final boolean isLinked() {
        return this.list != null;
    }

    public final LinkedNodeList<T> getList() {
        return this.list;
    }
}

