/*
 * Decompiled with CFR 0.152.
 */
package org.diylc;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.appframework.miscutils.PropertyInjector;
import org.diylc.common.IPlugInPort;
import org.diylc.swing.gui.MainFrame;
import org.diylc.swing.gui.TemplateDialog;

public class DIYLCStarter {
    private static final Logger LOG = Logger.getLogger(DIYLCStarter.class);
    private static final String SCRIPT_RUN = "org.diylc.scriptRun";

    public static void main(String[] stringArray) {
        int n;
        URL uRL = DIYLCStarter.class.getResource("log4j.properties");
        Properties properties = new Properties();
        try {
            properties.load(uRL.openStream());
            PropertyConfigurator.configure((Properties)properties);
        }
        catch (Exception exception) {
            LOG.error((Object)"Could not initialize log4j configuration", (Throwable)exception);
        }
        LOG.debug((Object)("Java version: " + System.getProperty("java.runtime.version") + " by " + System.getProperty("java.vm.vendor")));
        LOG.debug((Object)("OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version")));
        LOG.info((Object)("Starting DIYLC with working directory " + System.getProperty("user.dir")));
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            LOG.error((Object)"Could not set Look&Feel", (Throwable)exception);
        }
        String string = System.getProperty(SCRIPT_RUN);
        if (!"true".equals(string) && (n = JOptionPane.showConfirmDialog(null, "It is not recommended to run DIYLC by clicking on the diylc.jar file.\nPlease use diylc.exe on Windows or run.sh on OSX/Linux to ensure the best\nperformance and reliability. Do you want to continue?", "DIYLC", 0, 2)) != 0) {
            System.exit(0);
        }
        MainFrame mainFrame = new MainFrame();
        mainFrame.setLocationRelativeTo(null);
        mainFrame.setVisible(true);
        if (stringArray.length > 0) {
            mainFrame.getPresenter().loadProjectFromFile(stringArray[0]);
        } else {
            TemplateDialog templateDialog;
            boolean bl = ConfigurationManager.getInstance().readBoolean("showTemplatesAtStartup", true);
            if (bl && !(templateDialog = new TemplateDialog(mainFrame, (IPlugInPort)mainFrame.getPresenter())).getFiles().isEmpty()) {
                templateDialog.setVisible(true);
            }
        }
        properties = new Properties();
        try {
            LOG.info((Object)"Injecting default properties.");
            File file = new File("config.properties");
            if (file.exists()) {
                properties.load(new FileInputStream(file));
                PropertyInjector.injectProperties((Properties)properties);
            }
        }
        catch (Exception exception) {
            LOG.error((Object)"Could not read config.properties file", (Throwable)exception);
        }
    }
}

