/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.util;

import com.l2fprod.util.ImageUtils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RGBImageFilter;

public class ColorFillFilter
extends RGBImageFilter {
    public int m_Red;
    public int m_Green;
    public int m_Blue;

    public ColorFillFilter(int r, int g, int b) {
        this.setColor(r, g, b);
        this.canFilterIndexColorModel = true;
    }

    public ColorFillFilter(Color color) {
        this(100 * color.getRed() / 255, 100 * color.getGreen() / 255, 100 * color.getBlue() / 255);
    }

    public ColorFillFilter() {
        this(100, 100, 100);
    }

    public void setColor(int r, int g, int b) {
        this.m_Red = r;
        this.m_Green = g;
        this.m_Blue = b;
    }

    public void setRed(int r) {
        this.m_Red = r;
    }

    public void setGreen(int g) {
        this.m_Green = g;
    }

    public void setBlue(int b) {
        this.m_Blue = b;
    }

    public int filterRGB(int x, int y, int rgb) {
        int b;
        int g;
        if (rgb == 0 || rgb == ImageUtils.TRANSPARENT_PIXEL) {
            return rgb;
        }
        int r = ((rgb & 0xFF0000) >> 16) * this.m_Red / 100;
        if (r < 0) {
            r = 0;
        }
        if (r > 255) {
            r = 255;
        }
        if ((g = ((rgb & 0xFF00) >> 8) * this.m_Green / 100) < 0) {
            g = 0;
        }
        if (g > 255) {
            g = 255;
        }
        if ((b = (rgb & 0xFF) * this.m_Blue / 100) < 0) {
            b = 0;
        }
        if (b > 255) {
            b = 255;
        }
        return 0xFF000000 | r << 16 | g << 8 | b << 0;
    }

    public void filter(BufferedImage src, BufferedImage dest) {
        int c = src.getWidth();
        for (int x = 0; x < c; ++x) {
            int d = src.getHeight();
            for (int y = 0; y < d; ++y) {
                dest.setRGB(x, y, this.filterRGB(x, y, src.getRGB(x, y)));
            }
        }
    }
}

