/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.io;

import edu.cornell.med.icb.io.ConditionField;
import edu.cornell.med.icb.io.ConditionsParsingException;
import edu.cornell.med.icb.io.TSVReader;
import edu.cornell.med.icb.util.ICBStringUtils;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class ConditionsParser {
    private final List<ConditionField> fields;
    private static final char FIELD_SEPARATOR_DEFAULT = '\t';
    private static final String COMMENT_PREFIX_DEFAULT = "#";
    private static final char ESCAPE_CHAR_DEFAULT = '\\';
    private char fieldSeparator = (char)9;
    private String commentPrefix = "#";
    private Character escapeChar = Character.valueOf('\\');
    private TSVReader tsvReader;
    private boolean hasNext;
    private int lineNumber;
    private Map<String, Integer> nameToFieldNumberMap;

    public ConditionsParser() {
        this(new ArrayList<ConditionField>());
    }

    public ConditionsParser(List<ConditionField> fieldsVal) {
        this.fields = new ArrayList<ConditionField>(fieldsVal.size());
        this.fields.addAll(fieldsVal);
        this.tsvReader = null;
        this.hasNext = false;
    }

    public ConditionsParser addField(ConditionField field) {
        this.fields.add(field);
        return this;
    }

    public ConditionsParser clearFields() {
        this.fields.clear();
        return this;
    }

    public ConditionsParser setFieldSeparator(char fieldSeparatorVal) {
        this.fieldSeparator = fieldSeparatorVal;
        return this;
    }

    public char getFieldSeparator() {
        return this.fieldSeparator;
    }

    public int getFieldsCount() {
        if (this.fields == null) {
            return 0;
        }
        return this.fields.size();
    }

    public List<ConditionField> getFields() {
        return this.fields;
    }

    public ConditionsParser setCommentPrefix(String commentPrefixVal) {
        this.commentPrefix = commentPrefixVal;
        return this;
    }

    public String getCommentPrefix() {
        return this.commentPrefix;
    }

    public ConditionsParser setEscapeChar(Character escapeCharVal) {
        this.escapeChar = escapeCharVal;
        return this;
    }

    public Character getEscapeChar() {
        return this.escapeChar;
    }

    public void beginParse(Reader sourceReader) {
        this.tsvReader = new TSVReader(sourceReader, this.fieldSeparator);
        this.hasNext = false;
        this.lineNumber = 0;
        this.tsvReader.setCommentPrefix(this.commentPrefix);
        this.tsvReader.setEscapeChar(this.escapeChar);
        this.tsvReader.setUnescapeResults(false);
        this.nameToFieldNumberMap = new HashMap<String, Integer>(this.fields.size());
        int pos = 0;
        for (ConditionField field : this.fields) {
            Integer current = this.nameToFieldNumberMap.get(field.getFieldName());
            if (current == null) {
                this.nameToFieldNumberMap.put(field.getFieldName(), pos);
            }
            ++pos;
        }
    }

    public <T> List<T> beginParseAllToBeans(Reader sourceReader, Class<T> templateClass, Map<String, String> valuesMap) throws IOException, ConditionsParsingException {
        ArrayList<T> resultObjs = new ArrayList<T>();
        this.beginParse(sourceReader);
        while (this.hasNext()) {
            T object;
            try {
                object = templateClass.newInstance();
            }
            catch (IllegalAccessException e) {
                throw new ConditionsParsingException("Could not create new object for classname " + templateClass.getName() + " - IllegalAccessException for line " + this.lineNumber, e);
            }
            catch (InstantiationException e) {
                throw new ConditionsParsingException("Could not create new object for classname " + templateClass.getName() + " - InstantiationException for line " + this.lineNumber, e);
            }
            resultObjs.add(object);
            this.parseAllFieldsBean(object, valuesMap);
        }
        return resultObjs;
    }

    public <T> List<T> beginParseAllToBeans(Reader sourceReader, T templateObject, Map<String, String> valuesMap) throws IOException, ConditionsParsingException {
        if (templateObject == null) {
            throw new ConditionsParsingException("templateObject cannot be is null when calling parseAllFieldsBean");
        }
        ArrayList<Object> resultObjs = new ArrayList<Object>();
        this.beginParse(sourceReader);
        while (this.hasNext()) {
            Object object;
            try {
                object = BeanUtils.cloneBean(templateObject);
            }
            catch (IllegalAccessException e) {
                throw new ConditionsParsingException("Could not create new object for classname " + templateObject.getClass().getName() + " - IllegalAccessException for line " + this.lineNumber, e);
            }
            catch (InvocationTargetException e) {
                throw new ConditionsParsingException("Could not create new object for classname " + templateObject.getClass().getName() + " - InvocationTargetException for line " + this.lineNumber, e);
            }
            catch (NoSuchMethodException e) {
                throw new ConditionsParsingException("Could not create new object for classname " + templateObject.getClass().getName() + " - NoSuchMethodException for line " + this.lineNumber, e);
            }
            catch (InstantiationException e) {
                throw new ConditionsParsingException("Could not create new object for classname " + templateObject.getClass().getName() + " - InstantiationException for line " + this.lineNumber, e);
            }
            resultObjs.add(object);
            this.parseAllFieldsBean(object, valuesMap);
        }
        return resultObjs;
    }

    public boolean hasNext() throws IOException, ConditionsParsingException {
        block6: {
            block5: {
                if (this.tsvReader == null) {
                    throw new ConditionsParsingException("No tsvReader, did you call beginParse(...)?");
                }
                for (ConditionField field : this.fields) {
                    field.resetValueToDefault();
                }
                while (true) {
                    this.hasNext = this.tsvReader.hasNext();
                    if (!this.hasNext) break block5;
                    ++this.lineNumber;
                    if (!this.tsvReader.isCommentLine() && !this.tsvReader.isEmptyLine()) break;
                    this.tsvReader.skip();
                }
                this.tsvReader.next();
                int numFields = this.tsvReader.numTokens();
                if (numFields > this.fields.size()) {
                    this.tsvReader.close();
                    this.tsvReader = null;
                    this.hasNext = false;
                    throw new ConditionsParsingException("Source file has too many fields on line " + this.lineNumber);
                }
                for (int i = 0; i < numFields; ++i) {
                    this.fields.get(i).setCurrentValue(this.tsvReader.getString());
                }
                break block6;
            }
            this.tsvReader.close();
            this.tsvReader = null;
        }
        return this.hasNext;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    private int getFieldNumber(String fieldName) throws ConditionsParsingException {
        Integer fieldNumber = this.nameToFieldNumberMap.get(fieldName);
        if (fieldNumber == null) {
            throw new ConditionsParsingException("Field name " + fieldName + " does not exist in specified fields");
        }
        return fieldNumber;
    }

    public String parseFieldValueString(String fieldName) throws ConditionsParsingException {
        if (!this.hasNext) {
            throw new ConditionsParsingException("No line to parse. Did you call beginParse(...) and hasNext()?");
        }
        int fieldNumber = this.getFieldNumber(fieldName);
        ConditionField field = this.fields.get(fieldNumber);
        String wholeValue = field.getCurrentValue();
        if (wholeValue == null) {
            wholeValue = "";
        }
        if (field.isList()) {
            String[] listVals = ICBStringUtils.split(wholeValue, field.getListSeparator(), this.escapeChar);
            if (listVals.length == 0) {
                return "";
            }
            return ICBStringUtils.unescape(listVals[0], this.escapeChar);
        }
        return ICBStringUtils.unescape(field.getCurrentValue(), this.escapeChar);
    }

    public String[] parseFieldValueStringArray(String fieldName) throws ConditionsParsingException {
        if (!this.hasNext) {
            throw new ConditionsParsingException("No line to parse. Did you call beginParse(...) and hasNext()?");
        }
        int fieldNumber = this.getFieldNumber(fieldName);
        ConditionField field = this.fields.get(fieldNumber);
        String wholeValue = field.getCurrentValue();
        if (wholeValue == null) {
            wholeValue = "";
        }
        if (field.isList()) {
            String[] listVals = ICBStringUtils.split(wholeValue, field.getListSeparator(), this.escapeChar);
            listVals = ICBStringUtils.unescape(listVals, this.escapeChar);
            return listVals;
        }
        String[] listVals = new String[]{ICBStringUtils.unescape(field.getCurrentValue(), this.escapeChar)};
        return listVals;
    }

    public int parseFieldValueInt(String fieldName) throws ConditionsParsingException {
        String fieldValue = this.parseFieldValueString(fieldName);
        return Integer.parseInt(fieldValue);
    }

    public int[] parseFieldValueIntArray(String fieldName) throws ConditionsParsingException {
        String[] fieldValues = this.parseFieldValueStringArray(fieldName);
        int[] outValues = new int[fieldValues.length];
        for (int i = 0; i < fieldValues.length; ++i) {
            outValues[i] = Integer.parseInt(fieldValues[i]);
        }
        return outValues;
    }

    public double parseFieldValueDouble(String fieldName) throws ConditionsParsingException {
        String fieldValue = this.parseFieldValueString(fieldName);
        return Double.parseDouble(fieldValue);
    }

    public double[] parseFieldValueDoubleArray(String fieldName) throws ConditionsParsingException {
        String[] fieldValues = this.parseFieldValueStringArray(fieldName);
        double[] outValues = new double[fieldValues.length];
        for (int i = 0; i < fieldValues.length; ++i) {
            outValues[i] = Double.parseDouble(fieldValues[i]);
        }
        return outValues;
    }

    public boolean parseFieldValueBoolean(String fieldName) throws ConditionsParsingException {
        String fieldValue = this.parseFieldValueString(fieldName);
        return Boolean.parseBoolean(fieldValue);
    }

    public boolean[] parseFieldValueBooleanArray(String fieldName) throws ConditionsParsingException {
        String[] fieldValues = this.parseFieldValueStringArray(fieldName);
        boolean[] outValues = new boolean[fieldValues.length];
        for (int i = 0; i < fieldValues.length; ++i) {
            outValues[i] = Boolean.parseBoolean(fieldValues[i]);
        }
        return outValues;
    }

    public Map<String, String> parseFieldMap(String fieldName) throws ConditionsParsingException {
        String[] fieldValues = this.parseFieldValueStringArray(fieldName);
        ConditionField field = this.fields.get(this.getFieldNumber(fieldName));
        char valueSeparator = field.getKeyValueSeparator();
        HashMap<String, String> outValues = new HashMap<String, String>();
        for (String fieldValue : fieldValues) {
            int pos = fieldValue.indexOf(valueSeparator);
            if (pos == -1) {
                outValues.put(fieldValue, "");
                continue;
            }
            String left = fieldValue.substring(0, pos);
            String right = fieldValue.substring(pos + 1, fieldValue.length());
            outValues.put(left, right);
        }
        return outValues;
    }

    public void parseAllFieldsBean(Object targetObject, Map<String, String> valuesMap) throws ConditionsParsingException {
        if (targetObject == null) {
            throw new ConditionsParsingException("targetObject cannot be is null when calling parseAllFieldsBean");
        }
        for (ConditionField field : this.fields) {
            if (!StringUtils.isNotBlank((String)field.getValueBeanProperty())) continue;
            this.parseFieldBean(field.getFieldName(), targetObject, valuesMap);
        }
    }

    public Object parseFieldBean(String fieldName, Object targetObject, Map<String, String> valuesMap) throws ConditionsParsingException {
        Object object;
        int fieldNumber = this.getFieldNumber(fieldName);
        ConditionField field = this.fields.get(fieldNumber);
        if (field.getFieldType() == ConditionField.FieldType.VALUE) {
            if (targetObject != null && StringUtils.isNotBlank((String)field.getValueBeanProperty())) {
                this.parseFieldBeanValue(field, targetObject, valuesMap);
            }
            return targetObject;
        }
        Map<String, String> fieldValues = this.parseFieldMap(fieldName);
        String classname = fieldValues.get(field.getClassnameKey());
        String prependObjectBean = "";
        if (StringUtils.isNotBlank((String)field.getValueBeanProperty()) && StringUtils.isNotBlank((String)classname)) {
            prependObjectBean = field.getValueBeanProperty();
        }
        if ((object = targetObject) == null || prependObjectBean.length() > 0) {
            if (classname == null) {
                throw new ConditionsParsingException("targetObject is null and " + field.getClassnameKey() + " is not specified for line " + this.lineNumber);
            }
            try {
                Object newObject = Class.forName(classname).newInstance();
                if (prependObjectBean.length() > 0) {
                    BeanUtils.setProperty((Object)object, (String)prependObjectBean, newObject);
                    prependObjectBean = prependObjectBean + ".";
                } else {
                    object = newObject;
                }
            }
            catch (InvocationTargetException e) {
                throw new ConditionsParsingException("Could not create new object for classname " + classname + " - InvocationTargetException for line " + this.lineNumber, e);
            }
            catch (InstantiationException e) {
                throw new ConditionsParsingException("Could not create new object for classname " + classname + " - InstantiationException for line " + this.lineNumber, e);
            }
            catch (IllegalAccessException e) {
                throw new ConditionsParsingException("Could not create new object for classname " + classname + " - IllegalAccessException for line " + this.lineNumber, e);
            }
            catch (ClassNotFoundException e) {
                throw new ConditionsParsingException("Could not create new object for classname " + classname + " - ClassNotFoundException for line " + this.lineNumber, e);
            }
        }
        for (String key : fieldValues.keySet()) {
            if (key.equals(field.getClassnameKey())) continue;
            String value = fieldValues.get(key);
            try {
                BeanUtils.setProperty((Object)object, (String)(prependObjectBean + key), (Object)value);
                if (valuesMap == null) continue;
                valuesMap.put(key, value);
            }
            catch (IllegalAccessException e) {
                throw new ConditionsParsingException("Could not create new object for classname " + classname + " - IllegalAccessException for line " + this.lineNumber + " key = " + prependObjectBean + key + " / value = " + value, e);
            }
            catch (InvocationTargetException e) {
                throw new ConditionsParsingException("Could not create new object for classname " + classname + " - InvocationTargetException for line " + this.lineNumber + " key = " + prependObjectBean + key + " / value = " + value, e);
            }
        }
        return object;
    }

    private void parseFieldBeanValue(ConditionField field, Object targetObject, Map<String, String> valuesMap) throws ConditionsParsingException {
        Object fieldValue;
        boolean isClassname = false;
        if (field.isList()) {
            fieldValue = this.parseFieldValueStringArray(field.getFieldName());
        } else {
            if (field.isClassname()) {
                isClassname = true;
            }
            fieldValue = this.parseFieldValueString(field.getFieldName());
        }
        try {
            if (isClassname) {
                Object newObject = Class.forName((String)fieldValue).newInstance();
                BeanUtils.setProperty((Object)targetObject, (String)field.getValueBeanProperty(), newObject);
            } else {
                BeanUtils.setProperty((Object)targetObject, (String)field.getValueBeanProperty(), (Object)fieldValue);
                if (valuesMap != null) {
                    valuesMap.put(field.getValueBeanProperty(), ArrayUtils.toString((Object)fieldValue));
                }
            }
        }
        catch (InvocationTargetException e) {
            throw new ConditionsParsingException("BeanUtils problem  - InvocationTargetException for line " + this.lineNumber + " key = " + field.getValueBeanProperty() + " / value = " + fieldValue, e);
        }
        catch (InstantiationException e) {
            throw new ConditionsParsingException("BeanUtils problem  - InstantiationException for line " + this.lineNumber + " key = " + field.getValueBeanProperty() + " / value = " + fieldValue, e);
        }
        catch (IllegalAccessException e) {
            throw new ConditionsParsingException("BeanUtils problem  - IllegalAccessException for line " + this.lineNumber + " key = " + field.getValueBeanProperty() + " / value = " + fieldValue, e);
        }
        catch (ClassNotFoundException e) {
            throw new ConditionsParsingException("Could not create new object  - ClassNotFoundException for line " + this.lineNumber + " key = " + field.getValueBeanProperty() + " / value = " + fieldValue, e);
        }
    }
}

