/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; version 
 * 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#ifndef _SML_AUTH_H_
#define _SML_AUTH_H_

typedef struct SmlAuthenticator SmlAuthenticator;
typedef void (* SmlAuthVerifyCb)(SmlAuthenticator *auth, const char *username, const char *password, void *userdata, SmlErrorType *reply);

SmlAuthenticator *smlAuthNew(SmlError **error);
void smlAuthFree(SmlAuthenticator *auth);
SmlBool smlAuthRegister(SmlAuthenticator *auth, SmlManager *manager, SmlError **error);
void smlAuthSetState(SmlAuthenticator *auth, SmlErrorType type);
SmlStatus *smlAuthHeaderReply(SmlSession *session, SmlAuthType code, SmlError **error);
void smlAuthSetVerifyCallback(SmlAuthenticator *auth, SmlAuthVerifyCb callback, void *userdata);
void smlAuthSetEnable(SmlAuthenticator *auth, SmlBool enabled);
SmlBool smlAuthIsEnabled(SmlAuthenticator *auth);

#endif //_SML_AUTH_H_
