/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.digest;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.jasypt.digest.ByteDigester;
import org.jasypt.digest.config.DigesterConfig;
import org.jasypt.exceptions.AlreadyInitializedException;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.jasypt.salt.RandomSaltGenerator;
import org.jasypt.salt.SaltGenerator;

public final class StandardByteDigester
implements ByteDigester {
    public static final String DEFAULT_ALGORITHM = "MD5";
    public static final int DEFAULT_SALT_SIZE_BYTES = 8;
    public static final int DEFAULT_ITERATIONS = 1000;
    private String algorithm = "MD5";
    private int saltSizeBytes = 8;
    private int iterations = 1000;
    private SaltGenerator saltGenerator = null;
    private String providerName = null;
    private Provider provider = null;
    private DigesterConfig config = null;
    private boolean algorithmSet = false;
    private boolean saltSizeBytesSet = false;
    private boolean iterationsSet = false;
    private boolean saltGeneratorSet = false;
    private boolean providerNameSet = false;
    private boolean providerSet = false;
    private boolean initialized = false;
    private boolean useSalt = true;
    private MessageDigest md = null;

    public synchronized void setConfig(DigesterConfig config) {
        Validate.notNull((Object)config, (String)"Config cannot be set null");
        if (this.isInitialized()) {
            throw new AlreadyInitializedException();
        }
        this.config = config;
    }

    public synchronized void setAlgorithm(String algorithm) {
        Validate.notEmpty((String)algorithm, (String)"Algorithm cannot be empty");
        if (this.isInitialized()) {
            throw new AlreadyInitializedException();
        }
        this.algorithm = algorithm;
        this.algorithmSet = true;
    }

    public synchronized void setSaltSizeBytes(int saltSizeBytes) {
        Validate.isTrue((saltSizeBytes >= 0 ? 1 : 0) != 0, (String)"Salt size in bytes must be non-negative");
        if (this.isInitialized()) {
            throw new AlreadyInitializedException();
        }
        this.saltSizeBytes = saltSizeBytes;
        this.useSalt = saltSizeBytes > 0;
        this.saltSizeBytesSet = true;
    }

    public synchronized void setIterations(int iterations) {
        Validate.isTrue((iterations > 0 ? 1 : 0) != 0, (String)"Number of iterations must be greater than zero");
        if (this.isInitialized()) {
            throw new AlreadyInitializedException();
        }
        this.iterations = iterations;
        this.iterationsSet = true;
    }

    public synchronized void setSaltGenerator(SaltGenerator saltGenerator) {
        Validate.notNull((Object)saltGenerator, (String)"Salt generator cannot be set null");
        if (this.isInitialized()) {
            throw new AlreadyInitializedException();
        }
        this.saltGenerator = saltGenerator;
        this.saltGeneratorSet = true;
    }

    public synchronized void setProviderName(String providerName) {
        Validate.notNull((Object)providerName, (String)"Provider name cannot be set null");
        if (this.isInitialized()) {
            throw new AlreadyInitializedException();
        }
        this.providerName = providerName;
        this.providerNameSet = true;
    }

    public synchronized void setProvider(Provider provider) {
        Validate.notNull((Object)provider, (String)"Provider cannot be set null");
        if (this.isInitialized()) {
            throw new AlreadyInitializedException();
        }
        this.provider = provider;
        this.providerSet = true;
    }

    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    public synchronized void initialize() {
        if (!this.initialized) {
            if (this.config != null) {
                Integer configIterations;
                Integer configSaltSizeBytes;
                String configAlgorithm = this.config.getAlgorithm();
                if (configAlgorithm != null) {
                    Validate.notEmpty((String)configAlgorithm, (String)"Algorithm cannot be empty");
                }
                if ((configSaltSizeBytes = this.config.getSaltSizeBytes()) != null) {
                    Validate.isTrue((configSaltSizeBytes >= 0 ? 1 : 0) != 0, (String)"Salt size in bytes must be non-negative");
                }
                if ((configIterations = this.config.getIterations()) != null) {
                    Validate.isTrue((configIterations > 0 ? 1 : 0) != 0, (String)"Number of iterations must be greater than zero");
                }
                SaltGenerator configSaltGenerator = this.config.getSaltGenerator();
                String configProviderName = this.config.getProviderName();
                if (configProviderName != null) {
                    Validate.notEmpty((String)configProviderName, (String)"Provider name cannot be empty");
                }
                Provider configProvider = this.config.getProvider();
                this.algorithm = this.algorithmSet || configAlgorithm == null ? this.algorithm : configAlgorithm;
                this.saltSizeBytes = this.saltSizeBytesSet || configSaltSizeBytes == null ? this.saltSizeBytes : configSaltSizeBytes;
                this.iterations = this.iterationsSet || configIterations == null ? this.iterations : configIterations;
                this.saltGenerator = this.saltGeneratorSet || configSaltGenerator == null ? this.saltGenerator : configSaltGenerator;
                this.providerName = this.providerNameSet || configProviderName == null ? this.providerName : configProviderName;
                Provider provider = this.provider = this.providerSet || configProvider == null ? this.provider : configProvider;
            }
            if (this.saltGenerator == null) {
                this.saltGenerator = new RandomSaltGenerator();
            }
            try {
                this.md = this.provider != null ? MessageDigest.getInstance(this.algorithm, this.provider) : (this.providerName != null ? MessageDigest.getInstance(this.algorithm, this.providerName) : MessageDigest.getInstance(this.algorithm));
            }
            catch (NoSuchAlgorithmException e) {
                throw new EncryptionInitializationException(e);
            }
            catch (NoSuchProviderException e) {
                throw new EncryptionInitializationException(e);
            }
            this.initialized = true;
        }
    }

    public byte[] digest(byte[] message) {
        if (message == null) {
            return null;
        }
        if (!this.isInitialized()) {
            this.initialize();
        }
        byte[] salt = null;
        if (this.useSalt) {
            salt = this.saltGenerator.generateSalt(this.saltSizeBytes);
        }
        return this.digest(message, salt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] digest(byte[] message, byte[] salt) {
        try {
            byte[] encryptedMessage = new byte[]{};
            if (salt != null) {
                encryptedMessage = ArrayUtils.addAll((byte[])encryptedMessage, (byte[])salt);
            }
            byte[] digest = null;
            MessageDigest messageDigest = this.md;
            synchronized (messageDigest) {
                this.md.reset();
                if (salt != null) {
                    this.md.update(salt);
                }
                this.md.update(message);
                digest = this.md.digest();
                for (int i = 0; i < this.iterations - 1; ++i) {
                    this.md.reset();
                    digest = this.md.digest(digest);
                }
            }
            encryptedMessage = this.saltGenerator.includePlainSaltInEncryptionResults() ? ArrayUtils.addAll((byte[])encryptedMessage, (byte[])digest) : digest;
            return encryptedMessage;
        }
        catch (Exception e) {
            throw new EncryptionOperationNotPossibleException();
        }
    }

    public boolean matches(byte[] message, byte[] digest) {
        if (message == null) {
            return digest == null;
        }
        if (digest == null) {
            return false;
        }
        if (!this.isInitialized()) {
            this.initialize();
        }
        try {
            byte[] salt = null;
            if (this.useSalt) {
                salt = this.saltGenerator.includePlainSaltInEncryptionResults() ? ArrayUtils.subarray((byte[])digest, (int)0, (int)this.saltSizeBytes) : this.saltGenerator.generateSalt(this.saltSizeBytes);
            }
            byte[] encryptedMessage = this.digest(message, salt);
            return Arrays.equals(encryptedMessage, digest);
        }
        catch (Exception e) {
            throw new EncryptionOperationNotPossibleException();
        }
    }
}

