/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.UIManager;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.igoweb.igoweb.client.CChannel;
import org.igoweb.igoweb.client.CRoom;
import org.igoweb.igoweb.client.Client;
import org.igoweb.util.Defs;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.Multicaster;
import org.igoweb.util.swing.AFrame;
import org.igoweb.util.swing.ATextField;
import org.igoweb.util.swing.Errout;
import org.igoweb.util.swing.MsgOut;
import org.igoweb.util.swing.TextLog;

public class ChatPane
extends TextLog {
    private static final Object ANNC_LISTENER_KEY = new Object();
    public static final int FORMAT_NORMAL = 0;
    public static final int FORMAT_BOLD = 1;
    public static final int FORMAT_DIM = 2;
    public static final int FORMAT_COUNT = 3;
    protected final Client client;
    private CChannel channel;
    private boolean showRanks;
    private boolean isAdded = false;
    private final Listener listener = new Listener();
    private ATextField input;
    private static final SimpleAttributeSet[] attrs = new SimpleAttributeSet[3];

    public ChatPane(Client newClient, CChannel newChannel, int maxMessages) {
        super(attrs, maxMessages);
        this.client = newClient;
        this.setChannel(newChannel);
    }

    public void setShowRanks(boolean newShowRanks) {
        this.showRanks = newShowRanks;
    }

    @Override
    public void addNotify() {
        if (!this.isAdded) {
            this.isAdded = true;
            this.setAnncListener(Multicaster.add(this.getAnncListener(), this.listener));
            if (this.channel != null) {
                this.channel.addListener(this.listener);
            }
        }
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        if (this.isAdded) {
            this.isAdded = false;
            this.setAnncListener(Multicaster.remove(this.getAnncListener(), this.listener));
            if (this.channel != null) {
                this.channel.removeListener(this.listener);
            }
        }
        super.removeNotify();
    }

    protected void handleChannelEvent(Event event) {
        if (event.type == 17) {
            this.handleChat((CChannel.Chat)event.arg);
        }
    }

    protected void handleChat(CChannel.Chat chat) {
        this.append(chat);
    }

    protected void append(CChannel.Chat chat) {
        if (chat.user == null) {
            this.append(" ");
        } else {
            String text = chat.text;
            this.append((this.showRanks ? chat.user.getNameAndRank().replace(' ', '\u00a0') : chat.user.name) + ":\u00a0" + text, chat.announcement ? 1 : 0, true);
        }
    }

    private void setAnncListener(EventListener anncListener) {
        if (this.client != null) {
            this.client.objects.put(ANNC_LISTENER_KEY, anncListener);
        }
    }

    private EventListener getAnncListener() {
        return this.client == null ? null : (EventListener)this.client.objects.get(ANNC_LISTENER_KEY);
    }

    public static void announce(Event event, AFrame parent) {
        EventListener listener = (EventListener)((Client)event.source).objects.get(ANNC_LISTENER_KEY);
        if (listener == null) {
            new MsgOut(Defs.getString(-903340802), (String)event.arg, 1, (Component)parent);
        } else {
            listener.handleEvent(event);
        }
    }

    public void setChannel(CChannel newChannel) {
        if (this.channel != null) {
            this.channel.removeListener(this.listener);
        }
        this.channel = newChannel;
        if (this.isAdded && newChannel != null) {
            newChannel.addListener(this.listener);
        }
        boolean enable = newChannel != null;
        this.setEnabled(enable);
        if (this.input != null) {
            this.input.setEnabled(enable);
        }
    }

    public CChannel getChannel() {
        return this.channel;
    }

    public final EventListener getChannelListener() {
        return this.listener;
    }

    public ATextField getInput() {
        if (this.input == null) {
            this.input = new ATextField(this.listener);
            this.input.setEnabled(this.isEnabled());
        }
        return this.input;
    }

    protected String handleInput(ATextField src) {
        if (this.channel == null) {
            return null;
        }
        String msg = src.getText();
        if (!msg.isEmpty()) {
            if (msg.length() > 1000) {
                new Errout(Defs.getString(-903340583, 1000.0));
                return null;
            }
            if (msg.charAt(0) == '!' && (this.client.getMe().getAuthLevel() >= 3 || this.channel.isOwner() && this.channel instanceof CRoom)) {
                boolean toAll = msg.length() > 1 && msg.charAt(1) == '!';
                if (!(msg = msg.substring(toAll ? 2 : 1).trim()).isEmpty()) {
                    this.channel.sendChat(msg, true, toAll);
                }
                msg = null;
            } else {
                this.channel.sendChat(msg);
            }
            src.setText("");
            return msg;
        }
        return null;
    }

    static {
        for (int i = 0; i < 3; ++i) {
            ChatPane.attrs[i] = ChatPane.getBasicAttributeSet(true);
        }
        StyleConstants.setBold(attrs[1], true);
        StyleConstants.setForeground(attrs[2], UIManager.getColor("org.igoweb.stdBg").darker());
    }

    public class Listener
    implements ActionListener,
    EventListener {
        @Override
        public void handleEvent(Event event) {
            if (event.source == ChatPane.this.getChannel()) {
                ChatPane.this.handleChannelEvent(event);
            } else {
                String msg = (String)event.arg;
                if (!msg.endsWith("\n")) {
                    msg = msg + '\n';
                }
                ChatPane.this.append(msg, 1, true);
            }
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ChatPane.this.handleInput((ATextField)event.getSource());
        }
    }
}

