/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.resource;

import java.util.Locale;
import org.igoweb.resource.ResEntry;
import org.igoweb.util.xml.XhtmlValidator;

public class XhtmlEntry
extends ResEntry {
    private static final String PRE_TITLE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta http-equiv=\"Content-Type\" content=\"application/xhtml+xml;charset=UTF-8\"/><title>";
    private static final String TITLE_TO_BODY = "</title></head><body>";
    private static final String BODY_POSTFIX = "</body></html>";
    private static final XhtmlValidator validator = new XhtmlValidator();
    private final Location location;

    public XhtmlEntry(String key, int index, Location location, String original, String notes) {
        super(key, index, original, notes);
        this.location = location;
    }

    public XhtmlEntry(String key, int index, Location location, String original, String notes, Object[][] args) {
        super(key, index, original, notes, args);
        this.location = location;
    }

    public XhtmlEntry(String key, int index, Location location, String original) {
        super(key, index, original);
        this.location = location;
    }

    @Override
    public ResEntry repackage(String pkgName) {
        return new XhtmlEntry(pkgName + ':' + this.key, this.index, this.location, this.original, this.comment, this.getSampleArgs());
    }

    @Override
    public String isValid(String translation, Locale locale) {
        String prevErr = super.isValid(translation, locale);
        if (prevErr != null) {
            return prevErr;
        }
        return validator.validate(this.location.PREFIX + translation + this.location.POSTFIX);
    }

    public static enum Location {
        BODY("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta http-equiv=\"Content-Type\" content=\"application/xhtml+xml;charset=UTF-8\"/><title>default</title></head><body>", "</body></html>"),
        LIST("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta http-equiv=\"Content-Type\" content=\"application/xhtml+xml;charset=UTF-8\"/><title>default</title></head><body><ul>", "</ul></body></html>"),
        TITLE("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta http-equiv=\"Content-Type\" content=\"application/xhtml+xml;charset=UTF-8\"/><title>", "</title></head><body><p>xxx</p></body></html>"),
        PARAGRAPH("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta http-equiv=\"Content-Type\" content=\"application/xhtml+xml;charset=UTF-8\"/><title>default</title></head><body><p>", "</p></body></html>"),
        CELL("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta http-equiv=\"Content-Type\" content=\"application/xhtml+xml;charset=UTF-8\"/><title>default</title></head><body><table><tr><td>", "</td></tr></table></body></html>"),
        ATTRIBUTE("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta http-equiv=\"Content-Type\" content=\"application/xhtml+xml;charset=UTF-8\"/><title>default</title></head><body><p style=\"", "\">default</p></body></html>"),
        HEADER("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta http-equiv=\"Content-Type\" content=\"application/xhtml+xml;charset=UTF-8\"/><title>default</title></head><body><h1>", "</h1></body></html>"),
        P_SPAN("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta http-equiv=\"Content-Type\" content=\"application/xhtml+xml;charset=UTF-8\"/><title>default</title></head><body><p><span>", "</span></p></body></html>"),
        CELL_LABEL("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta http-equiv=\"Content-Type\" content=\"application/xhtml+xml;charset=UTF-8\"/><title>default</title></head><body><table><tr><td><label>", "</label></td></tr></table></body></html>"),
        BUTTON_SPAN("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta http-equiv=\"Content-Type\" content=\"application/xhtml+xml;charset=UTF-8\"/><title>default</title></head><body><form action=\"foo.jsp\" method=\"post\"><div><button name=\"submit\" type=\"submit\"><span>", "</span></button></div></form></body></html>"),
        LI("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta http-equiv=\"Content-Type\" content=\"application/xhtml+xml;charset=UTF-8\"/><title>default</title></head><body><ul><li>", "</li></ul></body></html>"),
        FORM("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta http-equiv=\"Content-Type\" content=\"application/xhtml+xml;charset=UTF-8\"/><title>default</title></head><body><form action=\"foo.jsp\" method=\"post\">", "<div><button name=\"submit\" type=\"submit\"/></div></form></body></html>");

        public final String PREFIX;
        public final String POSTFIX;

        private Location(String prefix, String postfix) {
            this.PREFIX = prefix;
            this.POSTFIX = postfix;
        }
    }
}

