/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.util.barcode;

import it.unimi.dsi.lang.MutableString;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.campagnelab.goby.util.barcode.BarcodeMatcher;

public class BarcodeMatcherResult {
    private static final Log LOG = LogFactory.getLog(BarcodeMatcherResult.class);
    private int barcodeIndex = -1;
    private int numberOfDiffs = -1;
    private int sequenceStartPosition = -1;
    private int sequenceLength = -1;
    private int barcodeStartPosition = -1;
    private int barcodeMatchLength = -1;
    private boolean ambiguous;
    private static Map<String, Field> FIELDS_MAP = null;

    public BarcodeMatcherResult(int barcodeIndex, int numberOfDiffs, int sequenceStartPosition, int sequenceLength, int barcodeStartPosition, int barcodeMatchLength) {
        this.barcodeIndex = barcodeIndex;
        this.numberOfDiffs = numberOfDiffs;
        this.sequenceStartPosition = sequenceStartPosition;
        this.sequenceLength = sequenceLength;
        this.barcodeStartPosition = barcodeStartPosition;
        this.barcodeMatchLength = barcodeMatchLength;
    }

    public static synchronized void ensureFieldsMap() {
        if (FIELDS_MAP != null) {
            return;
        }
        Field[] fields = BarcodeMatcherResult.class.getDeclaredFields();
        FIELDS_MAP = new HashMap<String, Field>(fields.length);
        for (Field field : fields) {
            FIELDS_MAP.put(field.getName(), field);
        }
    }

    public BarcodeMatcherResult(Map<String, Object> init) {
        BarcodeMatcherResult.ensureFieldsMap();
        for (Map.Entry<String, Object> entry : init.entrySet()) {
            try {
                Object value = entry.getValue();
                if (value == null) continue;
                Field f = FIELDS_MAP.get(entry.getKey());
                if (value instanceof Integer) {
                    f.setInt(this, (Integer)value);
                    continue;
                }
                if (!(value instanceof Boolean)) continue;
                f.setBoolean(this, (Boolean)value);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)e);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)e);
            }
        }
    }

    public int getBarcodeIndex() {
        return this.barcodeIndex;
    }

    public int getNumberOfDiffs() {
        return this.numberOfDiffs;
    }

    public int getSequenceStartPosition() {
        return this.sequenceStartPosition;
    }

    public int getSequenceLength() {
        return this.sequenceLength;
    }

    public int getBarcodeStartPosition() {
        return this.barcodeStartPosition;
    }

    public int getBarcodeMatchLength() {
        return this.barcodeMatchLength;
    }

    public boolean isAmbiguous() {
        return this.ambiguous;
    }

    public void setAmbiguous(boolean ambiguous) {
        this.ambiguous = ambiguous;
    }

    public MutableString sequenceOf(MutableString sequence) {
        return sequence.substring(this.getSequenceStartPosition(), this.getSequenceStartPosition() + this.getSequenceLength());
    }

    public MutableString sequenceBarcodeOf(MutableString sequence) {
        return sequence.substring(this.getBarcodeStartPosition(), this.getBarcodeStartPosition() + this.getBarcodeMatchLength());
    }

    public MutableString barcodeWithMatchingAdapterOf(BarcodeMatcher matcher) {
        return matcher.getBarcodeWithAdapterAtIndex(this.getBarcodeIndex()).substring(0, this.getBarcodeMatchLength());
    }

    public MutableString barcodeOnlyOf(BarcodeMatcher matcher) {
        return matcher.getBarcodeOnlyAtIndex(this.getBarcodeIndex());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BarcodeMatcherResult that = (BarcodeMatcherResult)o;
        if (this.ambiguous != that.ambiguous) {
            return false;
        }
        if (this.barcodeIndex != that.barcodeIndex) {
            return false;
        }
        if (this.barcodeMatchLength != that.barcodeMatchLength) {
            return false;
        }
        if (this.barcodeStartPosition != that.barcodeStartPosition) {
            return false;
        }
        if (this.numberOfDiffs != that.numberOfDiffs) {
            return false;
        }
        if (this.sequenceLength != that.sequenceLength) {
            return false;
        }
        return this.sequenceStartPosition == that.sequenceStartPosition;
    }

    public int hashCode() {
        int result = this.barcodeIndex;
        result = 31 * result + this.numberOfDiffs;
        result = 31 * result + this.sequenceStartPosition;
        result = 31 * result + this.sequenceLength;
        result = 31 * result + this.barcodeStartPosition;
        result = 31 * result + this.barcodeMatchLength;
        result = 31 * result + (this.ambiguous ? 1 : 0);
        return result;
    }
}

