/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.session;

import org.broad.igv.renderer.BarChartRenderer;
import org.broad.igv.renderer.FeatureDensityRenderer;
import org.broad.igv.renderer.GeneTrackRenderer;
import org.broad.igv.renderer.GisticTrackRenderer;
import org.broad.igv.renderer.HeatmapRenderer;
import org.broad.igv.renderer.IGVFeatureRenderer;
import org.broad.igv.renderer.LineplotRenderer;
import org.broad.igv.renderer.MutationRenderer;
import org.broad.igv.renderer.PointsRenderer;
import org.broad.igv.renderer.Renderer;

public class RendererFactory {
    static Class defaultRendererClass = BarChartRenderer.class;

    public static Class getRendererClass(String rendererTypeName) {
        String typeName = rendererTypeName.toUpperCase();
        if (typeName.equals(RendererType.BAR_CHART.name()) || typeName.equals("BAR")) {
            return BarChartRenderer.class;
        }
        if (typeName.equals(RendererType.BASIC_FEATURE.name())) {
            return IGVFeatureRenderer.class;
        }
        if (typeName.equals(RendererType.FEATURE_DENSITY.name())) {
            return FeatureDensityRenderer.class;
        }
        if (typeName.equals(RendererType.GENE_TRACK.name())) {
            return GeneTrackRenderer.class;
        }
        if (typeName.equals(RendererType.GISTIC_TRACK.name())) {
            return GisticTrackRenderer.class;
        }
        if (typeName.equals(RendererType.HEATMAP.name())) {
            return HeatmapRenderer.class;
        }
        if (typeName.equals(RendererType.MUTATION.name())) {
            return MutationRenderer.class;
        }
        if (typeName.equals(RendererType.SCATTER_PLOT.name()) || typeName.toUpperCase().equals("POINTS")) {
            return PointsRenderer.class;
        }
        if (typeName.equals(RendererType.LINE_PLOT.name()) || typeName.toUpperCase().equals("LINE")) {
            return LineplotRenderer.class;
        }
        return null;
    }

    public static RendererType getRenderType(Renderer renderer) {
        Class<?> rendererClass = renderer.getClass();
        RendererType rendererType = null;
        if (rendererClass.equals(BarChartRenderer.class)) {
            rendererType = RendererType.BAR_CHART;
        } else if (rendererClass.equals(IGVFeatureRenderer.class)) {
            rendererType = RendererType.BASIC_FEATURE;
        } else if (rendererClass.equals(FeatureDensityRenderer.class)) {
            rendererType = RendererType.FEATURE_DENSITY;
        } else if (rendererClass.equals(GeneTrackRenderer.class)) {
            rendererType = RendererType.GENE_TRACK;
        } else if (rendererClass.equals(GisticTrackRenderer.class)) {
            rendererType = RendererType.GISTIC_TRACK;
        } else if (rendererClass.equals(HeatmapRenderer.class)) {
            rendererType = RendererType.HEATMAP;
        } else if (rendererClass.equals(MutationRenderer.class)) {
            rendererType = RendererType.MUTATION;
        } else if (rendererClass.equals(PointsRenderer.class)) {
            rendererType = RendererType.SCATTER_PLOT;
        } else if (rendererClass.equals(LineplotRenderer.class)) {
            rendererType = RendererType.LINE_PLOT;
        }
        return rendererType;
    }

    public static enum RendererType {
        BAR_CHART,
        BASIC_FEATURE,
        FEATURE_DENSITY,
        GENE_TRACK,
        GISTIC_TRACK,
        HEATMAP,
        MUTATION,
        SCATTER_PLOT,
        LINE_PLOT;

    }
}

