/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.RuntimeEOFException;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamUtils {
    public static byte[] readFully(InputStream input) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtil.copyStream(input, output);
        return output.toByteArray();
    }

    public static byte[] readFully(InputStream inputStream, int length) {
        byte[] b = new byte[length];
        InputStreamUtils.readFully(inputStream, b, 0, length);
        return b;
    }

    public static void readFully(InputStream inputStream, byte[] b, int off, int length) {
        int count;
        if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < length; n += count) {
            try {
                count = inputStream.read(b, off + n, length - n);
                if (count >= 0) continue;
                throw new RuntimeEOFException();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
    }

    public static void skipFully(InputStream in, long length) {
        long ret;
        for (long amt = length; amt > 0L; amt -= ret) {
            try {
                ret = in.skip(amt);
                if (ret != 0L) continue;
                int b = in.read();
                if (b == -1) {
                    throw new RuntimeEOFException("Premature EOF from inputStream after skipping " + (length - amt) + " byte(s).");
                }
                ret = 1L;
                continue;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
    }
}

