/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_CONFIG_H__
#define __SG_CONFIG_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <Python.h>

typedef struct _SGconfig SGconfig;

typedef gint (*SGconfigFunc) (SGconfig *config);

typedef enum {
        SG_CONFIG_PYTHON,
        SG_CONFIG_C
} SGconfigType;

typedef enum {
        SG_CONFIG_NEW,
        SG_CONFIG_INIT,
        SG_CONFIG_COMMIT,
} SGconfigStatus;


struct _SGconfig {
        gchar *name;
        gchar *group;
        SGconfigFunc def;
        SGconfigFunc commit;
        SGconfigType type;
        SGconfigStatus status;
};

extern PyObject *sg_config_dict;


void            sg_config_init                          (void);
SGconfig *      sg_config_new_python                    (gchar *name,
                                                         gchar *group,
                                                         PyObject *def,
                                                         PyObject *commit);
SGconfig *      sg_config_new_c                         (gchar *name,
                                                         gchar *group,
                                                         SGconfigFunc def,
                                                         SGconfigFunc commit);
PyObject *      sg_config_get_value                     (gchar *name,
                                                         gchar *group);
SGconfig *      sg_config_get_config                    (gchar *name,
                                                         gchar *group);
void            sg_config_exec_default                  (SGconfig *config);
void            sg_config_exec_commit                   (SGconfig *config);
void            sg_config_exec_commit_all               (void);
gboolean        sg_config_set_value                     (gchar *name,
                                                         gchar *group,
                                                         PyObject *value,
                                                         gboolean overwrite);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_CONFIG_H__ */
