#ifndef _SG_FEATURES_H_
#define _SG_FEATURES_H_

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* SciGraphica version.  */

#define SG_MAJOR_VERSION			(2)
#define SG_MINOR_VERSION			(1)
#define SG_MICRO_VERSION			(1)
#define SG_BINARY_AGE				(0)
#define SG_INTERFACE_AGE			(0)
#define SG_CHECK_VERSION(major,minor,micro)    \
   (SG_MAJOR_VERSION > (major) || \
   (SG_MAJOR_VERSION == (major) && SG_MINOR_VERSION > (minor)) || \
   (SG_MAJOR_VERSION == (major) && SG_MINOR_VERSION == (minor) && \
    SG_MICRO_VERSION >= (micro)))

/* SciGraphica Paths */

extern const guint sg_major_version;
extern const guint sg_minor_version;
extern const guint sg_micro_version;
extern const guint sg_binary_age;
extern const guint sg_interface_age;
extern const gchar *sg_prefix;
extern const gchar *sg_datadir;
extern const gchar *sg_libdir;
extern const gchar *sg_plugindir;

gchar* sg_check_version (guint required_major,
                         guint required_minor,
                         guint required_micro);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* _SG_FEATURES_H_ */
